/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool;

import com.openexchange.threadpool.CancelableCompletionService;
import com.openexchange.threadpool.RefusedExecutionBehavior;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolCompletionService<V>
implements CancelableCompletionService<V> {
    private final ThreadPoolService threadPoolService;
    private final BlockingQueue<Future<V>> completionQueue;
    private final RefusedExecutionBehavior<V> behavior;
    private final List<Future<V>> submittedFutures;
    private final AtomicInteger numberOfSubmits;
    private boolean trackable;

    public ThreadPoolCompletionService(ThreadPoolService threadPoolService) {
        if (threadPoolService == null) {
            throw new NullPointerException();
        }
        this.threadPoolService = threadPoolService;
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
        this.numberOfSubmits = new AtomicInteger(0);
        this.behavior = CallerRunsBehavior.getInstance();
        this.submittedFutures = new LinkedList<Future<V>>();
    }

    public ThreadPoolCompletionService(ThreadPoolService threadPoolService, BlockingQueue<Future<V>> completionQueue, RefusedExecutionBehavior<V> behavior) {
        if (threadPoolService == null) {
            throw new NullPointerException();
        }
        if (completionQueue == null) {
            throw new NullPointerException();
        }
        if (behavior == null) {
            throw new NullPointerException();
        }
        this.threadPoolService = threadPoolService;
        this.completionQueue = completionQueue;
        this.behavior = behavior;
        this.numberOfSubmits = new AtomicInteger(0);
        this.submittedFutures = new LinkedList<Future<V>>();
    }

    public ThreadPoolCompletionService<V> setTrackable(boolean trackable) {
        this.trackable = trackable;
        return this;
    }

    @Override
    public Future<V> submit(Task<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingTaskFuture f = new QueueingTaskFuture(task);
        this.submitFutureTask(f);
        return f;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture f = new QueueingFuture(task);
        this.submitFutureTask(f);
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture f = new QueueingFuture(task, result);
        this.submitFutureTask(f);
        return f;
    }

    public int getNumberOfSubmits() {
        return this.numberOfSubmits.get();
    }

    protected void submitFutureTask(FutureTask<V> f) {
        Future<Object> submitted = this.threadPoolService.submit(ThreadPools.task(f, null, this.trackable), this.behavior);
        this.numberOfSubmits.incrementAndGet();
        this.submittedFutures.add(submitted);
    }

    protected void taskDone(Future<V> task) {
        this.completionQueue.add(task);
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    @Override
    public void cancel(boolean mayInterruptIfRunning) {
        while (!this.submittedFutures.isEmpty()) {
            this.submittedFutures.remove(0).cancel(mayInterruptIfRunning);
        }
    }

    private final class QueueingTaskFuture
    extends FutureTask<V> {
        private final Task<V> t;

        QueueingTaskFuture(Task<V> t) {
            super(t);
            this.t = t;
        }

        @Override
        public void run() {
            block2: {
                boolean ran = false;
                this.t.beforeExecute(Thread.currentThread());
                try {
                    super.run();
                    ran = true;
                    this.t.afterExecute(null);
                }
                catch (Exception ex) {
                    if (ran) break block2;
                    this.t.afterExecute(ex);
                }
            }
        }

        @Override
        protected void done() {
            ThreadPoolCompletionService.this.taskDone(this);
        }
    }

    private final class QueueingFuture
    extends FutureTask<V> {
        QueueingFuture(Callable<V> c) {
            super(c);
        }

        QueueingFuture(Runnable t, V r) {
            super(t, r);
        }

        @Override
        protected void done() {
            ThreadPoolCompletionService.this.taskDone(this);
        }
    }
}

