/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.parser;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.subscribe.parser.MicroformatAppointmentSAXHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MicroformatAppointmentParser {
    private static final Logger LOG = LoggerFactory.getLogger(MicroformatAppointmentParser.class);
    private Collection<CalendarDataObject> appointments;

    public void parse(String text) {
        XMLReader xmlReader = null;
        try {
            MicroformatAppointmentSAXHandler handler = new MicroformatAppointmentSAXHandler();
            xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.parse(new InputSource(new ByteArrayInputStream(text.getBytes())));
            this.appointments = handler.getObjects();
        }
        catch (SAXException e) {
            LOG.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public Collection<CalendarDataObject> getAppointments() {
        return this.appointments;
    }
}

