/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.FolderUpdaterServiceV2;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrategyFolderUpdaterService<T>
implements FolderUpdaterServiceV2<T> {
    private final Logger LOG = LoggerFactory.getLogger(StrategyFolderUpdaterService.class);
    private final FolderUpdaterStrategy<T> strategy;
    private boolean usesMultipleStrategy = false;

    public StrategyFolderUpdaterService(FolderUpdaterStrategy<T> strategy) {
        this.strategy = strategy;
    }

    public StrategyFolderUpdaterService(FolderUpdaterStrategy<T> strategy, boolean usesMultipleStrategy) {
        this.strategy = strategy;
        this.usesMultipleStrategy = usesMultipleStrategy;
    }

    public boolean handles(FolderObject folder) {
        return this.strategy.handles(folder);
    }

    public void save(SearchIterator<T> data, TargetFolderDefinition target) throws OXException {
        this.save(data, target, null);
    }

    public void save(SearchIterator<T> data, TargetFolderDefinition target, Collection<OXException> errors) throws OXException {
        Object session = this.strategy.startSession(target);
        Collection<T> dataInFolder = this.strategy.getData(target, session);
        try {
            while (data.hasNext()) {
                Object element = data.next();
                if (null != element) {
                    Object bestMatch = this.findBestMatch(element, dataInFolder, session);
                    if (bestMatch == null) {
                        this.strategy.save(element, session, errors);
                    } else {
                        this.strategy.update(bestMatch, element, session);
                    }
                }
                element = null;
            }
        }
        catch (OXException x) {
            if (null == errors) {
                this.LOG.error("", (Throwable)x);
            } else {
                errors.add(x);
            }
            throw x;
        }
        finally {
            SearchIterators.close(data);
            this.strategy.closeSession(session);
        }
    }

    private T findBestMatch(T element, Collection<T> dataInFolder, Object session) throws OXException {
        int maxScore = -1;
        T maxElement = null;
        for (T elementInFolder : dataInFolder) {
            int currentScore = this.strategy.calculateSimilarityScore(elementInFolder, element, session);
            if (currentScore <= maxScore) continue;
            maxElement = elementInFolder;
            maxScore = currentScore;
        }
        if (maxScore > this.strategy.getThreshold(session)) {
            return maxElement;
        }
        return null;
    }

    public boolean usesMultipleStrategy() {
        return this.usesMultipleStrategy;
    }
}

