/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.helpers;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactConfig;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.infostore.ConverterException;
import com.openexchange.java.Streams;
import com.openexchange.subscribe.SubscriptionErrorMessage;
import com.openexchange.subscribe.helpers.TrustAllAdapter;
import com.openexchange.subscribe.osgi.SubscriptionServiceRegistry;
import com.openexchange.tools.ImageTypeDetector;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;
import javax.activation.FileTypeMap;
import javax.imageio.ImageIO;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpContentTooLargeException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.URIUtil;
import org.slf4j.LoggerFactory;

public class HTTPToolkit {
    private static final String UTF_8 = "UTF-8";

    public static InputStream grabStream(String site) throws IOException {
        return HTTPToolkit.grabStream(site, true);
    }

    public static InputStream grabStream(String site, boolean check) throws IOException {
        HttpClient client = new HttpClient();
        int timeout = 5000;
        client.getParams().setSoTimeout(5000);
        client.getParams().setIntParameter("http.connection.timeout", 5000);
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        client.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        client.getParams().setCookiePolicy("compatibility");
        String encodedSite = URIUtil.encodeQuery((String)site);
        URL javaURL = new URL(encodedSite);
        if (check) {
            HTTPToolkit.checkContentAndLength(javaURL, 5000);
        }
        if (javaURL.getProtocol().equalsIgnoreCase("https")) {
            int port = javaURL.getPort();
            if (port == -1) {
                port = 443;
            }
            Protocol https = new Protocol("https", (ProtocolSocketFactory)new TrustAllAdapter(), 443);
            client.getHostConfiguration().setHost(javaURL.getHost(), port, https);
            GetMethod getMethod = new GetMethod(javaURL.getFile());
            getMethod.getParams().setSoTimeout(5000);
            getMethod.setQueryString(javaURL.getQuery());
            client.executeMethod((HttpMethod)getMethod);
            return getMethod.getResponseBodyAsStream();
        }
        GetMethod getMethod = new GetMethod(encodedSite);
        client.executeMethod((HttpMethod)getMethod);
        return getMethod.getResponseBodyAsStream();
    }

    public static Reader grab(String site) throws HttpException, IOException {
        return new InputStreamReader(HTTPToolkit.grabStream(site), UTF_8);
    }

    public static Reader post(String site, Map<String, String> values) throws HttpException, IOException {
        HttpClient client = new HttpClient();
        int timeout = 5000;
        client.getParams().setSoTimeout(5000);
        client.getParams().setIntParameter("http.connection.timeout", 5000);
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        client.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        client.getParams().setCookiePolicy("compatibility");
        URL javaURL = new URL(site);
        HTTPToolkit.checkContentAndLength(javaURL, 5000);
        if (javaURL.getProtocol().equalsIgnoreCase("https")) {
            int port = javaURL.getPort();
            if (port == -1) {
                port = 443;
            }
            Protocol https = new Protocol("https", (ProtocolSocketFactory)new TrustAllAdapter(), 443);
            client.getHostConfiguration().setHost(javaURL.getHost(), port, https);
            PostMethod postMethod = new PostMethod(javaURL.getFile());
            for (Map.Entry<String, String> entry : values.entrySet()) {
                postMethod.addParameter(new NameValuePair(entry.getKey(), entry.getValue()));
            }
            postMethod.getParams().setSoTimeout(5000);
            postMethod.setQueryString(javaURL.getQuery());
            client.executeMethod((HttpMethod)postMethod);
            return new InputStreamReader(postMethod.getResponseBodyAsStream(), UTF_8);
        }
        PostMethod postMethod = new PostMethod(site);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            postMethod.addParameter(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        client.executeMethod((HttpMethod)postMethod);
        return new InputStreamReader(postMethod.getResponseBodyAsStream(), UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkContentAndLength(URL url, int timeout) throws IOException, HttpException {
        int length;
        String mimeType;
        URLConnection urlCon = url.openConnection();
        try {
            urlCon.setConnectTimeout(timeout);
            urlCon.setReadTimeout(timeout);
            urlCon.connect();
            String ct = urlCon.getContentType();
            mimeType = null == ct ? "application/octet-stream" : ct.toLowerCase(Locale.ENGLISH);
            length = urlCon.getContentLength();
        }
        finally {
            Streams.close((Closeable)urlCon.getInputStream());
        }
        if (!mimeType.startsWith("text/htm")) {
            throw new HttpException("No HTML content. Content-Type is " + mimeType);
        }
        ConfigurationService configurationService = (ConfigurationService)SubscriptionServiceRegistry.getInstance().getService(ConfigurationService.class);
        int maxLen = null == configurationService ? -1 : configurationService.getIntProperty("MAX_UPLOAD_SIZE", -1);
        if (maxLen > 0 && length > maxLen) {
            throw new HttpContentTooLargeException("Content-Length is " + length, maxLen);
        }
    }

    public static void loadImageFromURL(Contact contact, String url) throws OXException {
        try {
            HTTPToolkit.loadImageFromURL(contact, new URL(url));
        }
        catch (MalformedURLException e) {
            SubscriptionErrorMessage.COMMUNICATION_PROBLEM.create(e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadImageFromURL(Contact contact, URL url) throws OXException {
        String mimeType = null;
        byte[] bytes = null;
        try {
            URLConnection urlCon = url.openConnection();
            urlCon.setConnectTimeout(2500);
            urlCon.setReadTimeout(2500);
            urlCon.connect();
            mimeType = urlCon.getContentType();
            InputStream in = null;
            try {
                in = urlCon.getInputStream();
                bytes = Streams.stream2bytes((InputStream)in);
                long maxSize = ContactConfig.getInstance().getMaxImageSize();
                if (maxSize > 0L && (long)bytes.length > maxSize) {
                    ConverterException e = new ConverterException("Contact image is " + bytes.length + " bytes large and limit is " + maxSize + " bytes. Image is therefore ignored.");
                    LoggerFactory.getLogger(HTTPToolkit.class).warn("", (Throwable)e);
                    bytes = null;
                }
            }
            finally {
                Streams.close((Closeable)in);
            }
        }
        catch (SocketTimeoutException e) {
            throw SubscriptionErrorMessage.COMMUNICATION_PROBLEM.create(e, new Object[0]);
        }
        catch (IOException e) {
            throw SubscriptionErrorMessage.IO_ERROR.create("IO problem while reading \"" + url.toString() + "\"", e);
        }
        if (mimeType == null && "application/octet-stream".equals(mimeType = ImageTypeDetector.getMimeType((byte[])bytes))) {
            mimeType = HTTPToolkit.getMimeType(url.toString());
        }
        if (bytes != null && HTTPToolkit.isValidImage(bytes)) {
            contact.setImage1(bytes);
            contact.setImageContentType(mimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isValidImage(byte[] data) {
        ByteArrayInputStream inputStream = null;
        BufferedImage bimg = null;
        try {
            inputStream = Streams.newByteArrayInputStream((byte[])data);
            bimg = ImageIO.read(inputStream);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
        return bimg != null;
    }

    private static String getMimeType(String filename) {
        return FileTypeMap.getDefaultFileTypeMap().getContentType(filename);
    }
}

