/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.subscribe.parser.MicroformatAppointmentParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import junit.framework.TestCase;

public class MicroformatAppointmentParserTest
extends TestCase {
    public Date defaultStartDate;
    public Date defaultEndDate;
    public SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss z");
    public String wellBehavedHtml;

    public MicroformatAppointmentParserTest() {
        try {
            this.defaultStartDate = this.dateFormat.parse("1935-01-08, 12:00:00 GMT");
            this.defaultEndDate = this.dateFormat.parse("1977-08-16, 13:00:00 GMT");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.wellBehavedHtml = "<div class=\"ox-appointment\">\n   <span class=\"title\">My appointment</span>\n   <span class=\"note\">There are many appointments but this one is mine</span>\n   <span class=\"location\">Your place or mine?</span>\n   <span class=\"startDate\">" + this.dateFormat.format(this.defaultStartDate) + "</span>\n" + "   <span class=\"endDate\">" + this.dateFormat.format(this.defaultEndDate) + "</span>\n" + "</div>";
    }

    public void testShouldWorkUnderBestPossibleCircumstances() {
        MicroformatAppointmentParser parser = new MicroformatAppointmentParser();
        parser.parse(this.wellBehavedHtml);
        Collection appointments = parser.getAppointments();
        MicroformatAppointmentParserTest.assertEquals((String)"Should contain one element", (int)1, (int)appointments.size());
        CalendarDataObject appointment = (CalendarDataObject)appointments.iterator().next();
        MicroformatAppointmentParserTest.assertEquals((String)"Should parse title", (String)"My appointment", (String)appointment.getTitle());
        MicroformatAppointmentParserTest.assertEquals((String)"Should parse note", (String)"There are many appointments but this one is mine", (String)appointment.getNote());
        MicroformatAppointmentParserTest.assertEquals((String)"Should parse location", (String)"Your place or mine?", (String)appointment.getLocation());
        MicroformatAppointmentParserTest.assertEquals((String)"Should parse start date", (Object)this.defaultStartDate, (Object)appointment.getStartDate());
        MicroformatAppointmentParserTest.assertEquals((String)"Should parse end date", (Object)this.defaultEndDate, (Object)appointment.getEndDate());
    }
}

