/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.subscribe.Asserts;
import com.openexchange.subscribe.CompositeSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.SimSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.util.List;
import junit.framework.TestCase;

public class CompositeSubscriptionSourceDiscoveryServiceTest
extends TestCase {
    private CompositeSubscriptionSourceDiscoveryService compositeDiscoverer;

    public void setUp() {
        SimSubscriptionSourceDiscoveryService discoverer1 = new SimSubscriptionSourceDiscoveryService();
        SimSubscriptionSourceDiscoveryService discoverer2 = new SimSubscriptionSourceDiscoveryService();
        SimSubscriptionSourceDiscoveryService discoverer3 = new SimSubscriptionSourceDiscoveryService();
        discoverer1.addSource(this.source("com.openexchange.example.source1.1"));
        discoverer1.addSource(this.source("com.openexchange.example.source1.2"));
        discoverer2.addSource(this.source("com.openexchange.example.source2.1"));
        discoverer2.addSource(this.source("com.openexchange.example.source2.2"));
        discoverer2.addSource(this.source("com.openexchange.example.source2.3"));
        discoverer3.addSource(this.sourceWithPriority("com.openexchange.example.source1.1", 2));
        this.compositeDiscoverer = new CompositeSubscriptionSourceDiscoveryService();
        this.compositeDiscoverer.addSubscriptionSourceDiscoveryService((SubscriptionSourceDiscoveryService)discoverer1);
        this.compositeDiscoverer.addSubscriptionSourceDiscoveryService((SubscriptionSourceDiscoveryService)discoverer2);
        this.compositeDiscoverer.addSubscriptionSourceDiscoveryService((SubscriptionSourceDiscoveryService)discoverer3);
    }

    public void testCompositeList() {
        List allSources = this.compositeDiscoverer.getSources(-1);
        CompositeSubscriptionSourceDiscoveryServiceTest.assertNotNull((String)"compositeDiscoverer returned null!", (Object)allSources);
        Asserts.assertSources(allSources, "com.openexchange.example.source1.1", "com.openexchange.example.source1.2", "com.openexchange.example.source2.1", "com.openexchange.example.source2.2", "com.openexchange.example.source2.3");
        Asserts.assertPriority(allSources, "com.openexchange.example.source1.1", 2);
    }

    public void testCompositeKnowsSource() {
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.compositeDiscoverer, "com.openexchange.example.source1.1");
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.compositeDiscoverer, "com.openexchange.example.source1.2");
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.compositeDiscoverer, "com.openexchange.example.source2.1");
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.compositeDiscoverer, "com.openexchange.example.source2.2");
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.compositeDiscoverer, "com.openexchange.example.source2.3");
        Asserts.assertDoesNotKnow((SubscriptionSourceDiscoveryService)this.compositeDiscoverer, "com.openexchange.example.source3.1");
    }

    public void testCompositeGet() {
        CompositeSubscriptionSourceDiscoveryServiceTest.assertNotNull((String)"Failed getting com.openexchange.example.source1.1", (Object)this.compositeDiscoverer.getSource("com.openexchange.example.source1.1"));
        CompositeSubscriptionSourceDiscoveryServiceTest.assertNotNull((String)"Failed getting com.openexchange.example.source1.1", (Object)this.compositeDiscoverer.getSource("com.openexchange.example.source1.2"));
        CompositeSubscriptionSourceDiscoveryServiceTest.assertNotNull((String)"Failed getting com.openexchange.example.source1.1", (Object)this.compositeDiscoverer.getSource("com.openexchange.example.source2.1"));
        CompositeSubscriptionSourceDiscoveryServiceTest.assertNotNull((String)"Failed getting com.openexchange.example.source1.1", (Object)this.compositeDiscoverer.getSource("com.openexchange.example.source2.2"));
        CompositeSubscriptionSourceDiscoveryServiceTest.assertNotNull((String)"Failed getting com.openexchange.example.source1.1", (Object)this.compositeDiscoverer.getSource("com.openexchange.example.source2.3"));
        CompositeSubscriptionSourceDiscoveryServiceTest.assertNull((String)"Got com.openexchange.example.source3.1 ?!?", (Object)this.compositeDiscoverer.getSource("com.openexchange.example.source3.1"));
        Asserts.assertPriority(this.compositeDiscoverer.getSource("com.openexchange.example.source1.1"), 2);
    }

    private SubscriptionSource sourceWithPriority(String string, int i) {
        SubscriptionSource source = this.source(string);
        source.setPriority(i);
        return source;
    }

    private SubscriptionSource source(String identifier) {
        SubscriptionSource source = new SubscriptionSource();
        source.setId(identifier);
        return source;
    }
}

