/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.config;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.MailCapabilities;
import com.openexchange.mail.api.UrlInfo;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportAuthSupportAware;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mailaccount.Account;
import com.openexchange.mailaccount.TransportAuth;
import com.openexchange.session.Session;
import com.openexchange.smtp.SMTPExceptionCode;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import java.net.URI;
import java.net.URISyntaxException;
import javax.mail.internet.idn.IDNA;

public final class SMTPConfig
extends TransportConfig
implements TransportAuthSupportAware {
    private static final String PROTOCOL_SMTP_SECURE = "smtps";
    private boolean secure;
    private int smtpPort;
    private String smtpServer;
    private ISMTPProperties transportProperties;

    public MailCapabilities getCapabilities() {
        return MailCapabilities.EMPTY_CAPS;
    }

    public int getPort() {
        return this.smtpPort;
    }

    public String getServer() {
        return this.smtpServer;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected void parseServerURL(UrlInfo urlInfo) throws OXException {
        URI uri;
        try {
            uri = URIParser.parse((String)urlInfo.getServerURL(), (URIDefaults)URIDefaults.SMTP);
        }
        catch (URISyntaxException e) {
            throw SMTPExceptionCode.URI_PARSE_FAILED.create(e, urlInfo.getServerURL());
        }
        this.secure = PROTOCOL_SMTP_SECURE.equals(uri.getScheme());
        this.smtpServer = uri.getHost();
        this.smtpPort = uri.getPort();
        this.startTls = urlInfo.isStartTls();
    }

    public void setPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServer(String smtpServer) {
        this.smtpServer = null == smtpServer ? null : IDNA.toUnicode((String)smtpServer);
    }

    public ITransportProperties getTransportProperties() {
        return this.transportProperties;
    }

    public boolean isAuthSupported() throws OXException {
        ISMTPProperties transportProperties = this.transportProperties;
        if (null == transportProperties) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(new Object[]{"SMTP config not yet initialized"});
        }
        return transportProperties.isSmtpAuth();
    }

    public ISMTPProperties getSMTPProperties() {
        return this.transportProperties;
    }

    public void setTransportProperties(ITransportProperties transportProperties) {
        this.transportProperties = (ISMTPProperties)transportProperties;
    }

    protected boolean doCustomParsing(Account account, Session session) throws OXException {
        if (!account.isDefaultAccount()) {
            TransportAuth transportAuth = account.getTransportAuth();
            if (transportAuth == null) {
                return true;
            }
            switch (transportAuth) {
                case CUSTOM: {
                    this.login = SMTPConfig.saneLogin((String)account.getTransportLogin());
                    this.password = MailPasswordUtil.decrypt((String)account.getTransportPassword(), (Session)session, (int)account.getId(), (String)this.login, (String)account.getTransportServer());
                    break;
                }
                case NONE: {
                    this.login = null;
                    this.password = null;
                    break;
                }
            }
            return true;
        }
        return false;
    }
}

