/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.resources;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.protocol.Multistatus;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.WebdavStatusImpl;
import com.openexchange.webdav.xml.resources.PropertiesMarshaller;
import com.openexchange.webdav.xml.resources.ResourceMarshaller;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PropfindResponseMarshaller
extends PropertiesMarshaller
implements ResourceMarshaller {
    private final Set<WebdavProperty> requestedProps = new HashSet<WebdavProperty>();
    private final boolean brief;

    public PropfindResponseMarshaller(String uriPrefix, String charset, boolean brief) {
        super(uriPrefix, charset);
        this.brief = brief;
    }

    public PropfindResponseMarshaller addProperty(String namespace, String name) {
        this.requestedProps.add(new WebdavProperty(namespace, name));
        return this;
    }

    @Override
    protected Multistatus<Iterable<WebdavProperty>> getProps(WebdavResource resource) {
        Multistatus<Iterable<WebdavProperty>> multistatus = new Multistatus<Iterable<WebdavProperty>>();
        LinkedList<WebdavProperty> props = new LinkedList<WebdavProperty>();
        LinkedList<WebdavProperty> notFound = new LinkedList<WebdavProperty>();
        for (WebdavProperty prop : this.requestedProps) {
            try {
                WebdavProperty p = resource.getProperty(prop.getNamespace(), prop.getName());
                if (p == null) {
                    if (this.brief) continue;
                    notFound.add(prop);
                    continue;
                }
                props.add(p);
            }
            catch (WebdavProtocolException e) {
                multistatus.addStatus(new WebdavStatusImpl<List<WebdavProperty>>(e.getStatus(), e.getUrl(), Arrays.asList(prop)));
            }
            catch (OXException e) {
                multistatus.addStatus(new WebdavStatusImpl<List<WebdavProperty>>(500, new WebdavPath(new String[0]), Arrays.asList(prop)));
            }
        }
        if (!props.isEmpty()) {
            multistatus.addStatus(new WebdavStatusImpl(200, resource.getUrl(), props));
        }
        if (!notFound.isEmpty()) {
            multistatus.addStatus(new WebdavStatusImpl(404, resource.getUrl(), notFound));
        }
        return multistatus;
    }
}

