/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.impl;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavMultistatusException;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.impl.DummyResource;
import com.openexchange.webdav.protocol.impl.DummyResourceManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DummyCollection
extends DummyResource
implements WebdavCollection {
    private final List<WebdavResource> children = new ArrayList<WebdavResource>();

    public DummyCollection(DummyResourceManager manager, WebdavPath url) {
        super(manager, url);
    }

    @Override
    protected boolean isset(Protocol.Property p) {
        switch (p.getId()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public WebdavCollection toCollection() {
        return this;
    }

    @Override
    public String getResourceType() throws WebdavProtocolException {
        return "<D:collection />";
    }

    @Override
    public void putBody(InputStream data, boolean guessSize) throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public String getLanguage() throws WebdavProtocolException {
        return null;
    }

    @Override
    public void setLanguage(String lang) throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public Long getLength() throws WebdavProtocolException {
        return null;
    }

    @Override
    public void delete() throws WebdavProtocolException {
        ArrayList<WebdavResource> copy = new ArrayList<WebdavResource>(this.children);
        ArrayList<WebdavProtocolException> exceptions = new ArrayList<WebdavProtocolException>();
        for (WebdavResource res : copy) {
            try {
                res.delete();
            }
            catch (WebdavProtocolException x) {
                exceptions.add(x);
            }
        }
        try {
            super.delete();
        }
        catch (WebdavProtocolException x) {
            exceptions.add(x);
        }
        if (exceptions.size() > 0) {
            throw WebdavMultistatusException.create(this.getUrl(), exceptions);
        }
    }

    @Override
    public DummyCollection instance(WebdavPath url) {
        return new DummyCollection(this.mgr, url);
    }

    @Override
    public WebdavResource copy(WebdavPath dest, boolean noroot, boolean overwrite) throws WebdavProtocolException {
        try {
            this.checkParentExists(dest);
        }
        catch (OXException e) {
            throw new WebdavProtocolException(this.getUrl(), 500, e);
        }
        ArrayList<WebdavProtocolException> exceptions = new ArrayList<WebdavProtocolException>();
        try {
            WebdavResource copy = null;
            if (!noroot) {
                try {
                    copy = super.copy(dest, noroot, overwrite);
                }
                catch (OXException e) {
                    throw new WebdavProtocolException(this.getUrl(), 500, e);
                }
            } else {
                copy = this.mgr.resolveCollection(dest);
            }
            ArrayList<WebdavResource> tmpList = new ArrayList<WebdavResource>(this.children);
            for (WebdavResource res : tmpList) {
                try {
                    res.copy(dest.dup().append(res.getUrl().name()));
                }
                catch (WebdavProtocolException x) {
                    exceptions.add(x);
                }
            }
            return copy;
        }
        catch (WebdavProtocolException x) {
            exceptions.add(x);
            if (exceptions.size() > 0) {
                throw WebdavMultistatusException.create(this.getUrl(), exceptions);
            }
            throw new IllegalStateException("Impossible");
        }
    }

    @Override
    public void setLength(Long l) throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public String getETag() throws WebdavProtocolException {
        return null;
    }

    @Override
    public void setContentType(String s) throws WebdavProtocolException {
        throw WebdavProtocolException.Code.NO_BODIES_ALLOWED.create(this.getUrl(), 415);
    }

    @Override
    public WebdavResource resolveResource(WebdavPath subPath) throws WebdavProtocolException {
        return this.mgr.resolveResource(this.url.dup().append(subPath));
    }

    @Override
    public WebdavCollection resolveCollection(WebdavPath subPath) throws WebdavProtocolException {
        return this.mgr.resolveCollection(this.url.dup().append(subPath));
    }

    @Override
    public List<WebdavResource> getChildren() {
        return new ArrayList<WebdavResource>(this.children);
    }

    public void addChild(WebdavResource child) {
        this.children.add(child);
    }

    public void removeChild(WebdavResource child) {
        this.children.remove(child);
    }

    @Override
    public Iterator<WebdavResource> iterator() {
        return new ChildTreeIterator(this.children.iterator());
    }

    @Override
    public Iterable<WebdavResource> toIterable(int depth) {
        switch (depth) {
            case 0: {
                return new LinkedList<WebdavResource>();
            }
            case 1: {
                return this.getChildren();
            }
            case -1: {
                return this;
            }
        }
        throw new IllegalArgumentException("Depth can only be one of 0, 1 or INFINITY");
    }

    private static class ChildTreeIterator
    implements Iterator<WebdavResource> {
        private Iterator<WebdavResource> subIterator;
        private final Iterator<WebdavResource> childIterator;

        public ChildTreeIterator(Iterator<WebdavResource> childIterator) {
            this.childIterator = childIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.subIterator != null) {
                if (this.subIterator.hasNext()) {
                    return true;
                }
                this.subIterator = null;
            }
            return this.childIterator.hasNext();
        }

        @Override
        public WebdavResource next() {
            if (this.subIterator != null && this.subIterator.hasNext()) {
                return this.subIterator.next();
            }
            WebdavResource res = this.childIterator.next();
            if (res.isCollection()) {
                this.subIterator = res.toCollection().iterator();
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

