/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.behaviour;

import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.behaviour.Behaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSpecificBehaviourRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSpecificBehaviourRegistry.class);
    private final Map<Class<? extends Object>, List<Behaviour>> registry = new HashMap<Class<? extends Object>, List<Behaviour>>();

    public void add(Behaviour behaviour) {
        for (Class<? extends Object> clazz : behaviour.provides()) {
            List<Behaviour> behaviours = this.registry.get(clazz);
            if (behaviours == null) {
                behaviours = new ArrayList<Behaviour>();
                this.registry.put(clazz, behaviours);
            }
            behaviours.add(behaviour);
        }
    }

    public void addAll(Collection<Behaviour> behaviours) {
        for (Behaviour behaviour : behaviours) {
            this.add(behaviour);
        }
    }

    public void setBehaviours(Collection<Behaviour> behaviours) {
        this.registry.clear();
        this.addAll(behaviours);
    }

    public <T> T get(WebdavRequest request, Class<T> clazz) {
        List<Behaviour> behaviours = this.registry.get(clazz);
        if (behaviours == null) {
            return null;
        }
        for (Behaviour behaviour : behaviours) {
            if (!behaviour.matches(request)) continue;
            return behaviour.get(clazz);
        }
        return null;
    }

    public void log() {
        LOG.info("Using {} overrides for WebDAV", new Object(){

            public String toString() {
                int sum = 0;
                for (Map.Entry entry : RequestSpecificBehaviourRegistry.this.registry.entrySet()) {
                    sum += ((List)entry.getValue()).size();
                }
                return Integer.toString(sum);
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Overrides for WebDAV:");
            for (Map.Entry<Class<? extends Object>, List<Behaviour>> entry : this.registry.entrySet()) {
                for (Behaviour behaviour : entry.getValue()) {
                    LOG.debug("{} provides override for {}", (Object)behaviour, entry.getKey());
                }
            }
        }
    }
}

