/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.loader.LoadingHints;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;

public abstract class WebdavStructureAction
extends AbstractAction {
    private final WebdavFactory factory;

    public WebdavStructureAction(WebdavFactory factory) {
        this.factory = factory;
    }

    protected void checkOverwrite(WebdavRequest req) throws WebdavProtocolException {
        if (req.getHeader("Overwrite") != null && "F".equals(req.getHeader("Overwrite"))) {
            LoadingHints loadingHints = new LoadingHints();
            loadingHints.setUrl(req.getDestinationUrl());
            loadingHints.setDepth(-1);
            loadingHints.setProps(LoadingHints.Property.NONE);
            this.preLoad(loadingHints);
            WebdavResource dest = req.getDestination();
            if (!dest.exists()) {
                return;
            }
            if (dest.isCollection()) {
                int depth = req.getDepth(-1);
                int sourceUrlLength = req.getUrl().size();
                WebdavPath destUrl = req.getDestinationUrl();
                for (WebdavResource res : req.getCollection().toIterable(depth)) {
                    WebdavPath url = res.getUrl();
                    url = destUrl.dup().append(url.subpath(sourceUrlLength));
                    WebdavResource d = this.factory.resolveResource(url);
                    if (!d.exists() || d.isCollection()) continue;
                    throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 412);
                }
            } else {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 412);
            }
        }
    }

    protected int chooseReturnCode(WebdavRequest req) throws WebdavProtocolException {
        return req.getDestination().exists() ? 204 : 201;
    }

    protected void checkSame(WebdavRequest req) throws WebdavProtocolException {
        if (req.getUrl().equals(req.getDestinationUrl())) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 403);
        }
    }
}

