/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public final class RateLimitedException
extends RuntimeException {
    private static final long serialVersionUID = 5342199025241682441L;
    private static final int SC_TOO_MANY_REQUESTS = 429;
    private final int retryAfterSeconds;

    public RateLimitedException(String message, int retryAfterSeconds) {
        super(message);
        this.retryAfterSeconds = retryAfterSeconds;
    }

    public int getRetryAfter() {
        return this.retryAfterSeconds;
    }

    public void send(HttpServletResponse response) throws IOException {
        response.setContentType("text/plain; charset=UTF-8");
        if (0 < this.retryAfterSeconds) {
            response.setHeader("Retry-After", String.valueOf(this.retryAfterSeconds));
        }
        response.sendError(429, "Too Many Requests - Your request is being rate limited.");
    }
}

