/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.modules.Module;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.share.ShareService;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OXFolderDependentDeleter {
    public static void folderDeleted(Connection con, Session session, FolderObject folder, boolean handDown) throws OXException {
        List<Integer> subfolderIDs;
        ServerSession serverSession = ServerSessionAdapter.valueOf(session);
        Context context = serverSession.getContext();
        try {
            subfolderIDs = handDown ? OXFolderSQL.getSubfolderIDs(folder.getObjectID(), con, context, true) : null;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        OXFolderDependentDeleter.deletePublicationsAndSubscriptions(con, context, folder, subfolderIDs);
        HashSet<Integer> affectedEntities = new HashSet<Integer>();
        affectedEntities.addAll(OXFolderDependentDeleter.getPermissionEntities(folder, false));
        if (null != subfolderIDs && 0 < subfolderIDs.size()) {
            try {
                affectedEntities.addAll(OXFolderSQL.getPermissionEntities(subfolderIDs, con, context, false));
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        affectedEntities.addAll(OXFolderDependentDeleter.getObjectPermissionEntities(con, context, folder, subfolderIDs, false));
        OXFolderDependentDeleter.deleteObjectPermissions(con, context, folder, subfolderIDs);
        List<Integer> guestIDs = OXFolderDependentDeleter.filterGuests(con, context, new ArrayList<Integer>(affectedEntities));
        if (!guestIDs.isEmpty()) {
            ServerServiceRegistry.getInstance().getService(ShareService.class, true).scheduleGuestCleanup(context.getContextId(), Autoboxing.I2i(guestIDs));
        }
    }

    private static List<Integer> filterGuests(Connection con, Context context, List<Integer> entityIDs) throws OXException {
        if (0 == entityIDs.size()) {
            return entityIDs;
        }
        ArrayList<Integer> guestIDs = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder("SELECT DISTINCT id FROM user where cid=? AND id");
        if (1 == entityIDs.size()) {
            stringBuilder.append("=?");
        } else {
            stringBuilder.append(" IN (?");
            for (int i = 1; i < entityIDs.size(); ++i) {
                stringBuilder.append(",?");
            }
            stringBuilder.append(')');
        }
        stringBuilder.append(" AND guestCreatedBy>0;");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(stringBuilder.toString());
            stmt.setInt(1, context.getContextId());
            for (int i = 0; i < entityIDs.size(); ++i) {
                stmt.setInt(i + 2, Autoboxing.i((Integer)entityIDs.get(i)));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                guestIDs.add(Autoboxing.I((int)rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return guestIDs;
    }

    private static List<Integer> getObjectPermissionEntities(Connection con, Context context, FolderObject folder, List<Integer> subfolderIDs, boolean includeGroups) throws OXException {
        ArrayList<Integer> entityIDs = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder("SELECT DISTINCT permission_id FROM object_permission WHERE cid=? AND module=? AND folder_id");
        if (null == subfolderIDs || 0 == subfolderIDs.size()) {
            stringBuilder.append("=?");
        } else {
            stringBuilder.append(" IN (?");
            for (int i = 0; i < subfolderIDs.size(); ++i) {
                stringBuilder.append(",?");
            }
            stringBuilder.append(')');
        }
        if (!includeGroups) {
            stringBuilder.append(" AND group_flag=0");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(stringBuilder.toString());
            stmt.setInt(1, context.getContextId());
            int folderID = folder.getObjectID();
            stmt.setInt(2, folder.getModule());
            stmt.setInt(3, folderID);
            if (null != subfolderIDs && 0 < subfolderIDs.size()) {
                for (int i = 0; i < subfolderIDs.size(); ++i) {
                    stmt.setInt(i + 4, Autoboxing.i((Integer)subfolderIDs.get(i)));
                }
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                entityIDs.add(Autoboxing.I((int)rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return entityIDs;
    }

    private static void deleteObjectPermissions(Connection con, Context context, FolderObject folder, List<Integer> subfolderIDs) throws OXException {
        PreparedStatement stmt = null;
        try {
            int i;
            String whereFolderID;
            if (null == subfolderIDs || 0 == subfolderIDs.size()) {
                whereFolderID = "=?;";
            } else {
                StringBuilder StringBuilder2 = new StringBuilder(" IN (?");
                for (i = 0; i < subfolderIDs.size(); ++i) {
                    StringBuilder2.append(",?");
                }
                StringBuilder2.append(");");
                whereFolderID = StringBuilder2.toString();
            }
            stmt = con.prepareStatement("DELETE FROM object_permission WHERE cid=? AND module=? AND folder_id" + whereFolderID);
            stmt.setInt(1, context.getContextId());
            int folderID = folder.getObjectID();
            stmt.setInt(2, folder.getModule());
            stmt.setInt(3, folderID);
            if (null != subfolderIDs && 0 < subfolderIDs.size()) {
                for (i = 0; i < subfolderIDs.size(); ++i) {
                    stmt.setInt(i + 4, Autoboxing.i((Integer)subfolderIDs.get(i)));
                }
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    private static void deletePublicationsAndSubscriptions(Connection con, Context context, FolderObject folder, List<Integer> subfolderIDs) throws OXException {
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        try {
            int i;
            String whereFolderID;
            if (null == subfolderIDs || 0 == subfolderIDs.size()) {
                whereFolderID = "=?;";
            } else {
                StringBuilder stringBuilder = new StringBuilder(" IN (?");
                for (i = 0; i < subfolderIDs.size(); ++i) {
                    stringBuilder.append(",?");
                }
                stringBuilder.append(");");
                whereFolderID = stringBuilder.toString();
            }
            stmt1 = con.prepareStatement("DELETE FROM publications WHERE cid=? AND module=? AND entity" + whereFolderID);
            stmt1.setInt(1, context.getContextId());
            int folderID = folder.getObjectID();
            stmt1.setString(2, Module.getModuleString(folder.getModule(), folderID));
            stmt1.setInt(3, folderID);
            if (null != subfolderIDs && 0 < subfolderIDs.size()) {
                for (i = 0; i < subfolderIDs.size(); ++i) {
                    stmt1.setInt(i + 4, Autoboxing.i((Integer)subfolderIDs.get(i)));
                }
            }
            stmt1.executeUpdate();
            stmt2 = con.prepareStatement("DELETE FROM subscriptions WHERE cid=? AND folder_id" + whereFolderID);
            stmt2.setInt(1, context.getContextId());
            stmt2.setInt(2, folderID);
            if (null != subfolderIDs && 0 < subfolderIDs.size()) {
                for (i = 0; i < subfolderIDs.size(); ++i) {
                    stmt2.setInt(i + 3, subfolderIDs.get(i));
                }
            }
            stmt2.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt1);
                DBUtils.closeSQLStuff(stmt2);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt1);
        DBUtils.closeSQLStuff(stmt2);
    }

    private static Set<Integer> getPermissionEntities(FolderObject folder, boolean includeGroups) {
        List<OCLPermission> permissions = folder.getPermissions();
        if (null == permissions) {
            return Collections.emptySet();
        }
        HashSet<Integer> entityIDs = new HashSet<Integer>(permissions.size());
        for (OCLPermission permission : permissions) {
            if (!includeGroups && permission.isGroupPermission()) continue;
            entityIDs.add(Autoboxing.I((int)permission.getEntity()));
        }
        return entityIDs;
    }
}

