/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.osgi;

import com.openexchange.filestore.FileStorageService;
import com.openexchange.filestore.QuotaFileStorageService;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FileStorageWrapperActivator
implements BundleActivator {
    private ServiceTracker<FileStorageService, FileStorageService> fsTracker;
    private ServiceTracker<QuotaFileStorageService, QuotaFileStorageService> qfsTracker;

    public void start(BundleContext context) throws Exception {
        ServiceTracker qfsTracker;
        ServiceTracker fsTracker;
        this.fsTracker = fsTracker = new ServiceTracker(context, FileStorageService.class, (ServiceTrackerCustomizer)new FSTrackerCustomizer(context));
        this.qfsTracker = qfsTracker = new ServiceTracker(context, QuotaFileStorageService.class, (ServiceTrackerCustomizer)new QFSTrackerCustomizer(context));
        fsTracker.open();
        qfsTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        ServiceTracker<QuotaFileStorageService, QuotaFileStorageService> qfsTracker;
        ServiceTracker<FileStorageService, FileStorageService> fsTracker = this.fsTracker;
        if (null != fsTracker) {
            fsTracker.close();
            this.fsTracker = null;
        }
        if (null != (qfsTracker = this.qfsTracker)) {
            qfsTracker.close();
            this.qfsTracker = null;
        }
    }

    private static class QFSTrackerCustomizer
    implements ServiceTrackerCustomizer<QuotaFileStorageService, QuotaFileStorageService> {
        private final BundleContext context;

        public QFSTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public QuotaFileStorageService addingService(ServiceReference<QuotaFileStorageService> reference) {
            QuotaFileStorageService service = (QuotaFileStorageService)this.context.getService(reference);
            QuotaFileStorage.setQuotaFileStorageStarter(service);
            return service;
        }

        public void modifiedService(ServiceReference<QuotaFileStorageService> reference, QuotaFileStorageService service) {
        }

        public void removedService(ServiceReference<QuotaFileStorageService> reference, QuotaFileStorageService service) {
            QuotaFileStorage.setQuotaFileStorageStarter(null);
            this.context.ungetService(reference);
        }
    }

    private static class FSTrackerCustomizer
    implements ServiceTrackerCustomizer<FileStorageService, FileStorageService> {
        private final BundleContext context;

        public FSTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public FileStorageService addingService(ServiceReference<FileStorageService> reference) {
            FileStorageService service = (FileStorageService)this.context.getService(reference);
            FileStorage.setFileStorageStarter(service);
            return service;
        }

        public void modifiedService(ServiceReference<FileStorageService> reference, FileStorageService service) {
        }

        public void removedService(ServiceReference<FileStorageService> reference, FileStorageService service) {
            FileStorage.setFileStorageStarter(null);
            this.context.ungetService(reference);
        }
    }
}

