/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.server.services.ServerServiceRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublicationTargetDiscoveryServiceTrackerCustomizer
implements ServiceTrackerCustomizer<PublicationTargetDiscoveryService, PublicationTargetDiscoveryService> {
    private static final Logger LOG = LoggerFactory.getLogger(PublicationTargetDiscoveryServiceTrackerCustomizer.class);
    private final BundleContext context;
    private final int ranking;

    public PublicationTargetDiscoveryServiceTrackerCustomizer(BundleContext context) {
        this.context = context;
        this.ranking = -1;
    }

    public PublicationTargetDiscoveryService addingService(ServiceReference<PublicationTargetDiscoveryService> reference) {
        int refRanking = PublicationTargetDiscoveryServiceTrackerCustomizer.getServiceReferenceRanking(reference);
        if (refRanking <= this.ranking) {
            return null;
        }
        PublicationTargetDiscoveryService addedService = (PublicationTargetDiscoveryService)this.context.getService(reference);
        ServerServiceRegistry.getInstance().addService(PublicationTargetDiscoveryService.class, addedService);
        return addedService;
    }

    public void modifiedService(ServiceReference<PublicationTargetDiscoveryService> reference, PublicationTargetDiscoveryService service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<PublicationTargetDiscoveryService> reference, PublicationTargetDiscoveryService service) {
        if (null != service) {
            try {
                ServerServiceRegistry.getInstance().removeService(PublicationTargetDiscoveryService.class);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }

    private static int getServiceReferenceRanking(ServiceReference<PublicationTargetDiscoveryService> reference) {
        Object property = reference.getProperty("service.ranking");
        if (property == null) {
            return 0;
        }
        if (Integer.class.isInstance(property)) {
            return (Integer)property;
        }
        try {
            return Integer.parseInt(property.toString());
        }
        catch (NumberFormatException e) {
            LOG.error("Service ranking cannot be parsed to an integer: {}", property, (Object)e);
            return 0;
        }
    }
}

