/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.folderstorage.internal.FolderI18nNamesServiceImpl;
import com.openexchange.group.internal.GroupI18nNamesService;
import com.openexchange.i18n.I18nService;
import com.openexchange.server.services.I18nServices;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class I18nServiceListener
implements ServiceTrackerCustomizer<I18nService, I18nService> {
    private final BundleContext context;
    private final I18nServices services = I18nServices.getInstance();

    public I18nServiceListener(BundleContext context) {
        this.context = context;
    }

    public I18nService addingService(ServiceReference<I18nService> reference) {
        I18nService i18n = (I18nService)this.context.getService(reference);
        this.services.addService(i18n);
        FolderI18nNamesServiceImpl.getInstance().addService(i18n);
        GroupI18nNamesService.getInstance().addService(i18n);
        return i18n;
    }

    public void modifiedService(ServiceReference<I18nService> reference, I18nService service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<I18nService> reference, I18nService service) {
        try {
            this.services.removeService(service);
            FolderI18nNamesServiceImpl.getInstance().removeService(service);
            GroupI18nNamesService.getInstance().removeService(service);
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

