/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.impl;

import com.openexchange.cache.registry.CacheAvailabilityRegistryInit;
import com.openexchange.charset.CustomCharsetProviderInit;
import com.openexchange.configuration.SystemConfig;
import com.openexchange.event.impl.EventInit;
import com.openexchange.exception.OXException;
import com.openexchange.folder.internal.FolderInitialization;
import com.openexchange.group.internal.GroupInit;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.attach.AttachmentInit;
import com.openexchange.groupware.calendar.CalendarConfig;
import com.openexchange.groupware.contexts.impl.ContextInit;
import com.openexchange.groupware.delete.DeleteRegistryInitialization;
import com.openexchange.groupware.downgrade.DowngradeRegistryInit;
import com.openexchange.groupware.impl.id.IDGeneratorInit;
import com.openexchange.groupware.infostore.InfostoreConfig;
import com.openexchange.groupware.notify.NotificationConfig;
import com.openexchange.groupware.settings.impl.ConfigTreeInit;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorageInit;
import com.openexchange.mail.MailInitialization;
import com.openexchange.mail.transport.TransportInitialization;
import com.openexchange.mailaccount.internal.MailAccountStorageInit;
import com.openexchange.multiple.internal.MultipleHandlerInit;
import com.openexchange.resource.internal.ResourceStorageInit;
import com.openexchange.server.Initialization;
import com.openexchange.tools.exceptions.ExceptionUtils;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.version.Version;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starter
implements Initialization {
    private final Initialization[] inits = new Initialization[]{SystemConfig.getInstance(), CacheAvailabilityRegistryInit.getInstance(), CalendarConfig.getInstance(), new CustomCharsetProviderInit(), ContextInit.getInstance(), OXFolderProperties.getInstance(), new FolderInitialization(), MailInitialization.getInstance(), TransportInitialization.getInstance(), InfostoreConfig.getInstance(), AttachmentConfig.getInstance(), GroupInit.getInstance(), ResourceStorageInit.getInstance(), UserConfigurationStorageInit.getInstance(), NotificationConfig.getInstance(), ConfigTreeInit.getInstance(), new EventInit(), new DeleteRegistryInitialization(), DowngradeRegistryInit.getInstance(), new AttachmentInit(), new MailAccountStorageInit(), new MultipleHandlerInit(), new IDGeneratorInit()};
    private static final Logger LOG = LoggerFactory.getLogger(Starter.class);
    private final Stack<Initialization> started = new Stack();

    public void start() {
        Starter.dumpServerInfos();
        for (Initialization init : this.inits) {
            try {
                init.start();
                this.started.push(init);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                LOG.error("initialization of {} failed", (Object)init.getClass().getName(), (Object)t);
            }
        }
        if (this.started.size() == this.inits.length) {
            LOG.info("Groupware server successfully initialized.");
        } else {
            LOG.info("Groupware server initialized with errors.");
        }
    }

    private static final void dumpServerInfos() {
        try {
            Properties p = System.getProperties();
            LOG.info("{} {} {}", new Object[]{p.getProperty("os.name"), p.getProperty("os.arch"), p.getProperty("os.version")});
            LOG.info(p.getProperty("java.runtime.version"));
            long totalMemory = Runtime.getRuntime().totalMemory() >> 10;
            LOG.info("VM Total Memory       : {} KB", (Object)NumberFormat.getNumberInstance().format(totalMemory));
            long freeMemory = Runtime.getRuntime().freeMemory() >> 10;
            LOG.info("VM Free Memory        : {} KB", (Object)NumberFormat.getNumberInstance().format(freeMemory));
            long usedMemory = totalMemory - freeMemory;
            LOG.info("VM Used Memory        : {} KB", (Object)NumberFormat.getNumberInstance().format(usedMemory));
        }
        catch (Exception gee) {
            LOG.error("", (Throwable)gee);
        }
        LOG.info("System version : {} Server [{}] initializing ...", (Object)"Open-Xchange", (Object)Version.getInstance().getVersionString());
        LOG.info("Server Footprint : {}", (Object)OXException.getServerId());
    }

    public void stop() {
        while (!this.started.isEmpty()) {
            try {
                this.started.pop().stop();
            }
            catch (OXException e) {
                LOG.error("Component shutdown failed.", (Throwable)e);
            }
        }
    }
}

