/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.resource.Resource;
import com.openexchange.resource.internal.ResourceServiceImpl;
import com.openexchange.resource.json.ResourceAJAXRequest;
import com.openexchange.resource.json.actions.AbstractResourceAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="get", description="Get a resource", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The resource id.")}, responseDescription="An array of resource objects as described in Resource response.")
public final class GetAction
extends AbstractResourceAction {
    private static final Logger LOG = LoggerFactory.getLogger(GetAction.class);

    public GetAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ResourceAJAXRequest req) throws OXException, JSONException {
        int id = req.checkInt("id");
        ServerSession session = req.getSession();
        Resource r = null;
        try {
            r = ResourceServiceImpl.getInstance().getResource(id, session.getContext());
        }
        catch (OXException exc) {
            LOG.debug("resource not found try to find id in user table", (Throwable)exc);
        }
        if (r == null) {
            User u = UserStorage.getInstance().getUser(id, session.getContext());
            r = new Resource();
            r.setIdentifier(u.getId());
            r.setDisplayName(u.getDisplayName());
            r.setLastModified(new Date(0L));
        }
        return new AJAXRequestResult(r, r.getLastModified(), "resource");
    }
}

