/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.user.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastLoginRecorder
implements LoginHandlerService {
    private static final Logger LOG = LoggerFactory.getLogger(LastLoginRecorder.class);
    private int maxClientCount = -1;
    private final UserService userService;
    private static final String[] KNOWN_CLIENTS = new String[]{"com.openexchange.ox.gui.dhtml", "open-xchange-appsuite", "com.openexchange.mobileapp", "OpenXchange.HTTPClient.OXAddIn", "OpenXchange.HTTPClient.OXNotifier", "com.open-xchange.updater.olox1", "com.open-xchange.updater.olox2"};

    public LastLoginRecorder(ConfigurationService confService, UserService userService) {
        this.userService = userService;
        this.readConfiguration(confService);
    }

    private void readConfiguration(ConfigurationService confService) {
        this.maxClientCount = confService.getIntProperty("com.openexchange.user.maxClientCount", -1);
    }

    @Override
    public void handleLogin(LoginResult login) throws OXException {
        LoginRequest request = login.getRequest();
        String client = request.getClient();
        if (null == client) {
            Interface interfaze = request.getInterface();
            String string = client = null == interfaze ? null : interfaze.toString();
        }
        if (null == client) {
            return;
        }
        Context context = login.getContext();
        User user = login.getUser();
        if (!LastLoginRecorder.isWhitelistedClient(client) && this.maxClientCount > 0) {
            int count = 0;
            for (String origKey : user.getAttributes().keySet()) {
                if (!origKey.startsWith("client:") || ++count <= this.maxClientCount) continue;
                LOG.warn("Login of client {} for login {} (Context: {}, User: {}) will not be recorded in the database.", new Object[]{client, login, context.getContextId(), user.getId()});
            }
        }
        LastLoginRecorder.updateLastLogin(this.userService, client, user, context);
    }

    static void updateLastLogin(UserService userService, String client, User origUser, Context context) throws OXException {
        if (context.isReadOnly()) {
            return;
        }
        userService.setAttribute("client:" + client, Long.toString(System.currentTimeMillis()), origUser.getId(), context);
    }

    private static boolean isWhitelistedClient(String client) {
        for (Interface interface_ : Interface.values()) {
            if (!interface_.toString().equals(client)) continue;
            return true;
        }
        for (String string : KNOWN_CLIENTS) {
            if (!string.equals(client)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleLogout(LoginResult logout) {
    }
}

