/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.quota.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.quota.json.QuotaAJAXRequest;
import com.openexchange.quota.json.actions.AbstractQuotaAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="mail", description="Get the mail usage data", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="A JSON Object containing the fields \"use\" and \"quota\". \"use\" represents the use mail quota and the field \"quota\" represents the maximum. -1 represents an unlimited quota.")
public final class MailAction
extends AbstractQuotaAction {
    private static final Logger LOG = LoggerFactory.getLogger(MailAction.class);

    public MailAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(QuotaAJAXRequest req) throws OXException, JSONException {
        long[][] quotaInfo = this.getQuotaInfo(req.getSession());
        JSONObject data = new JSONObject(6);
        data.put("quota", quotaInfo[0][0] << 10);
        data.put("use", quotaInfo[0][1] << 10);
        data.put("countquota", quotaInfo[1][0]);
        data.put("countuse", quotaInfo[1][1]);
        return new AJAXRequestResult((Object)data, "json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[][] getQuotaInfo(Session session) throws OXException {
        MailServletInterface mi = null;
        try {
            mi = MailServletInterface.getInstance(session);
            long[][] lArray = mi.getQuotas(new int[]{1, 2});
            return lArray;
        }
        finally {
            if (mi != null) {
                try {
                    mi.close(false);
                }
                catch (Exception e) {}
            }
        }
    }
}

