/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.factory;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.java.SortableConcurrentList;
import com.openexchange.mailaccount.json.DefaultMailAccountActionProvider;
import com.openexchange.mailaccount.json.MailAccountActionProvider;
import com.openexchange.osgi.util.RankedService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class TrackingMailAccountActionFactory
implements ServiceTrackerCustomizer<MailAccountActionProvider, MailAccountActionProvider>,
AJAXActionServiceFactory,
AJAXActionService {
    private final BundleContext context;
    private final DefaultMailAccountActionProvider defaultProvider;
    private final SortableConcurrentList<RankedService<MailAccountActionProvider>> trackedProviders;

    public TrackingMailAccountActionFactory(DefaultMailAccountActionProvider defaultProvider, BundleContext context) {
        this.context = context;
        this.defaultProvider = defaultProvider;
        SortableConcurrentList trackedProviders = new SortableConcurrentList();
        trackedProviders.add((Object)new RankedService((Object)defaultProvider, 0));
        this.trackedProviders = trackedProviders;
    }

    public Collection<?> getSupportedServices() {
        return this.defaultProvider.getActions().values();
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this;
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        String action = requestData.getAction();
        if (null == action) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create("null");
        }
        MailAccountActionProvider provider = this.getActiveProvider(session);
        AJAXActionService actionService = provider.getAction(action);
        if (null == actionService) {
            if (this.defaultProvider != provider) {
                actionService = this.defaultProvider.getAction(action);
            }
            if (null == actionService) {
                throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
            }
        }
        return actionService.perform(requestData, session);
    }

    private MailAccountActionProvider getActiveProvider(ServerSession session) throws OXException {
        for (RankedService rankedService : this.trackedProviders) {
            MailAccountActionProvider provider = (MailAccountActionProvider)rankedService.service;
            if (!provider.isApplicableFor(session)) continue;
            return provider;
        }
        return this.defaultProvider;
    }

    public synchronized MailAccountActionProvider addingService(ServiceReference<MailAccountActionProvider> reference) {
        MailAccountActionProvider provider = (MailAccountActionProvider)this.context.getService(reference);
        this.trackedProviders.addAndSort((Comparable)new RankedService((Object)provider, RankedService.getRanking(reference)));
        return provider;
    }

    public void modifiedService(ServiceReference<MailAccountActionProvider> reference, MailAccountActionProvider provider) {
    }

    public synchronized void removedService(ServiceReference<MailAccountActionProvider> reference, MailAccountActionProvider provider) {
        this.trackedProviders.remove((Object)new RankedService((Object)provider, RankedService.getRanking(reference)));
        this.context.ungetService(reference);
    }
}

