/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.crypto.CryptoErrorMessage;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.TransportAuth;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountTreeAction;
import com.openexchange.mailaccount.json.parser.DefaultMailAccountParser;
import com.openexchange.mailaccount.utils.MailAccountUtils;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.net.URITools;
import com.openexchange.tools.session.ServerSession;
import com.sun.mail.iap.ConnectionException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="validate", description="Validate a mail account (which shall be created)", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="tree", optional=true, description="An optional boolean parameter which indicates whether on successful validation the folder tree shall be returned (NULL on failure) or if set to \"false\" or missing only a boolean is returned which indicates validation result.")}, requestBody="A JSON object describing the new account to validate. See mail account data.", responseDescription="Dependent on optional \"tree\" parameter a JSON folder object or a boolean value indicating the validation result.")
public final class ValidateAction
extends AbstractMailAccountTreeAction {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateAction.class);
    public static final String ACTION = "validate";

    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jData) throws OXException, JSONException {
        if (!session.getUserPermissionBits().isMultipleMailAccounts()) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
        }
        MailAccountDescription accountDescription = new MailAccountDescription();
        LinkedList<OXException> warnings = new LinkedList<OXException>();
        Set<Attribute> availableAttributes = DefaultMailAccountParser.getInstance().parse(accountDescription, jData.toObject(), warnings);
        if (accountDescription.getId() == 0) {
            return new AJAXRequestResult(Boolean.TRUE);
        }
        if (!availableAttributes.contains((Object)Attribute.TRANSPORT_AUTH_LITERAL)) {
            accountDescription.setTransportAuth(TransportAuth.MAIL);
            availableAttributes.add(Attribute.TRANSPORT_AUTH_LITERAL);
        }
        String tmp = requestData.getParameter("tree");
        boolean tree = AJAXRequestDataTools.parseBoolParameter(tmp);
        if (accountDescription.getId() >= 0) {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            MailAccount storageMailAccount = storageService.getMailAccount(accountDescription.getId(), session.getUserId(), session.getContextId());
            boolean checkPassword = true;
            if (null == accountDescription.getPassword()) {
                checkPassword = false;
                try {
                    String password = storageMailAccount.getPassword();
                    if (null != password) {
                        String decryptedPassword = MailPasswordUtil.decrypt(password, session, accountDescription.getId(), accountDescription.getLogin(), accountDescription.getMailServer());
                        accountDescription.setPassword(decryptedPassword);
                    }
                }
                catch (OXException e) {
                    if (!CryptoErrorMessage.BadPassword.equals(e)) {
                        throw e;
                    }
                    storageService.invalidateMailAccounts(session.getUserId(), session.getContextId());
                    storageMailAccount = storageService.getMailAccount(accountDescription.getId(), session.getUserId(), session.getContextId());
                    String decryptedPassword = MailPasswordUtil.decrypt(storageMailAccount.getPassword(), session, accountDescription.getId(), accountDescription.getLogin(), accountDescription.getMailServer());
                    accountDescription.setPassword(decryptedPassword);
                }
            }
            if (!tree && !ValidateAction.hasValidationReason(accountDescription, storageMailAccount, checkPassword, session)) {
                return new AJAXRequestResult(Boolean.TRUE);
            }
        }
        ValidateAction.checkNeededFields(accountDescription);
        if (ValidateAction.isUnifiedINBOXAccount(accountDescription.getMailProtocol())) {
            throw MailAccountExceptionCodes.UNIFIED_INBOX_ACCOUNT_VALIDATION_FAILED.create();
        }
        String tmp2 = requestData.getParameter("ignoreInvalidTransport");
        boolean ignoreInvalidTransport = AJAXRequestDataTools.parseBoolParameter(tmp2);
        if (tree) {
            return new AJAXRequestResult(ValidateAction.actionValidateTree(accountDescription, session, ignoreInvalidTransport, warnings)).addWarnings(warnings);
        }
        return new AJAXRequestResult(ValidateAction.actionValidateBoolean(accountDescription, session, ignoreInvalidTransport, warnings, false)).addWarnings(warnings);
    }

    private static boolean hasValidationReason(MailAccountDescription accountDescription, MailAccount storageMailAccount, boolean checkPassword, ServerSession session) throws OXException {
        String s1 = storageMailAccount.generateMailServerURL();
        String s2 = accountDescription.generateMailServerURL();
        if (null == s1 ? null != s2 : !s1.equals(s2)) {
            return true;
        }
        s1 = storageMailAccount.generateTransportServerURL();
        s2 = accountDescription.generateTransportServerURL();
        if (null == s1 ? null != s2 : !s1.equals(s2)) {
            return true;
        }
        s1 = storageMailAccount.getLogin();
        s2 = accountDescription.getLogin();
        if (null == s1 ? null != s2 : !s1.equals(s2)) {
            return true;
        }
        if (checkPassword) {
            s1 = MailPasswordUtil.decrypt(storageMailAccount.getPassword(), session, accountDescription.getId(), accountDescription.getLogin(), accountDescription.getMailServer());
            s2 = accountDescription.getPassword();
            if (null == s1 ? null != s2 : !s1.equals(s2)) {
                return true;
            }
        }
        if (null != (s2 = accountDescription.getTransportLogin()) && !s2.equals(s1 = storageMailAccount.getTransportLogin())) {
            return true;
        }
        s2 = accountDescription.getTransportPassword();
        return null != s2 && null != (s1 = storageMailAccount.getTransportPassword()) && !s2.equals(s1 = MailPasswordUtil.decrypt(s1, session, accountDescription.getId(), accountDescription.getLogin(), accountDescription.getMailServer()));
    }

    private static Object actionValidateTree(MailAccountDescription accountDescription, ServerSession session, boolean ignoreInvalidTransport, List<OXException> warnings) throws JSONException, OXException {
        if (!ValidateAction.actionValidateBoolean(accountDescription, session, ignoreInvalidTransport, warnings, false).booleanValue()) {
            return null;
        }
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = ValidateAction.getMailAccess(accountDescription, session, warnings);
        if (null == mailAccess) {
            return JSONObject.NULL;
        }
        return ValidateAction.actionValidateTree0(mailAccess, session);
    }

    public static Boolean actionValidateBoolean(MailAccountDescription accountDescription, ServerSession session, boolean ignoreInvalidTransport, List<OXException> warnings, boolean errorOnDenied) throws OXException {
        if (0 == accountDescription.getId()) {
            return Boolean.TRUE;
        }
        boolean validated = ValidateAction.checkMailServerURL(accountDescription, session, warnings, errorOnDenied);
        if (!validated) {
            ValidateAction.checkForCommunicationProblem(warnings, false, accountDescription);
            return Boolean.FALSE;
        }
        if (ignoreInvalidTransport) {
            return Boolean.TRUE;
        }
        if (!ValidateAction.isEmpty(accountDescription.getTransportServer()) && !(validated = ValidateAction.checkTransportServerURL(accountDescription, session, warnings, errorOnDenied))) {
            ValidateAction.checkForCommunicationProblem(warnings, true, accountDescription);
            return Boolean.FALSE;
        }
        return validated;
    }

    static void checkForCommunicationProblem(List<OXException> warnings, boolean transport, MailAccountDescription accountDescription) {
        OXException warning;
        if (null != warnings && !warnings.isEmpty() && ValidateAction.indicatesCommunicationProblem((warning = warnings.get(0)).getCause())) {
            OXException newWarning;
            if (transport) {
                String login = accountDescription.getTransportLogin();
                if (!ValidateAction.seemsValid(login)) {
                    login = accountDescription.getLogin();
                }
                newWarning = MailAccountExceptionCodes.VALIDATE_FAILED_TRANSPORT.create(accountDescription.getTransportServer(), login);
            } else {
                newWarning = MailAccountExceptionCodes.VALIDATE_FAILED_MAIL.create(accountDescription.getMailServer(), accountDescription.getLogin());
            }
            newWarning.setCategory(Category.CATEGORY_WARNING);
            warnings.clear();
            warnings.add(newWarning);
        }
    }

    private static boolean indicatesCommunicationProblem(Throwable cause) {
        if (MessagingException.class.isInstance(cause)) {
            Exception ne = ((MessagingException)cause).getNextException();
            return ValidateAction.indicatesCommunicationProblem(ne);
        }
        return ConnectionException.class.isInstance(cause) || SocketException.class.isInstance(cause);
    }

    static boolean checkMailServerURL(MailAccountDescription accountDescription, ServerSession session, List<OXException> warnings, boolean errorOnDenied) throws OXException {
        if (MailAccountUtils.isDenied(accountDescription.getMailServer(), accountDescription.getMailPort())) {
            OXException oxe = MailAccountExceptionCodes.VALIDATE_FAILED_MAIL.create(accountDescription.getMailServer(), accountDescription.getLogin());
            if (errorOnDenied) {
                throw oxe;
            }
            warnings.add(oxe);
            return false;
        }
        try {
            ValidateAction.fillMailServerCredentials(accountDescription, session, false);
        }
        catch (OXException e) {
            if (!CryptoErrorMessage.BadPassword.equals(e)) {
                throw e;
            }
            ValidateAction.fillMailServerCredentials(accountDescription, session, true);
        }
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = ValidateAction.getMailAccess(accountDescription, session, warnings);
        if (null == mailAccess) {
            return false;
        }
        boolean success = mailAccess.ping();
        Collection<OXException> currentWarnings = mailAccess.getWarnings();
        if (null != currentWarnings) {
            warnings.addAll(currentWarnings);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean checkTransportServerURL(MailAccountDescription accountDescription, ServerSession session, List<OXException> warnings, boolean errorOnDenied) throws OXException {
        URI uri;
        if (ValidateAction.isEmpty(accountDescription.getTransportServer())) {
            return true;
        }
        if (MailAccountUtils.isDenied(accountDescription.getTransportServer(), accountDescription.getTransportPort())) {
            String login = accountDescription.getTransportLogin();
            if (!ValidateAction.seemsValid(login)) {
                login = accountDescription.getLogin();
            }
            OXException oxe = MailAccountExceptionCodes.VALIDATE_FAILED_TRANSPORT.create(accountDescription.getTransportServer(), login);
            if (errorOnDenied) {
                throw oxe;
            }
            warnings.add(oxe);
            return false;
        }
        String transportServerURL = accountDescription.generateTransportServerURL();
        TransportProvider transportProvider = TransportProviderRegistry.getTransportProviderByURL(transportServerURL);
        if (null == transportProvider) {
            LOG.debug("Validating mail account failed. No transport provider found for URL: {}", (Object)transportServerURL);
            return false;
        }
        MailTransport mailTransport = transportProvider.createNewMailTransport(session);
        TransportConfig transportConfig = mailTransport.getTransportConfig();
        try {
            ValidateAction.fillTransportServerCredentials(accountDescription, session, false);
        }
        catch (OXException e) {
            if (!CryptoErrorMessage.BadPassword.equals(e)) {
                throw e;
            }
            ValidateAction.fillTransportServerCredentials(accountDescription, session, true);
        }
        String login = accountDescription.getTransportLogin();
        String password = accountDescription.getTransportPassword();
        if (!ValidateAction.seemsValid(login)) {
            login = accountDescription.getLogin();
        }
        if (!ValidateAction.seemsValid(password)) {
            password = accountDescription.getPassword();
        }
        transportConfig.setLogin(login);
        transportConfig.setPassword(password);
        try {
            uri = URIParser.parse(transportServerURL, URIDefaults.SMTP);
        }
        catch (URISyntaxException e) {
            throw MailExceptionCode.URI_PARSE_FAILED.create(e, transportServerURL);
        }
        transportConfig.setServer(URITools.getHost(uri));
        transportConfig.setPort(uri.getPort());
        transportConfig.setSecure(accountDescription.isTransportSecure());
        boolean validated = true;
        boolean close = false;
        try {
            mailTransport.ping();
            close = true;
        }
        catch (OXException e) {
            Throwable cause;
            LOG.debug("Validating transport account failed.", (Throwable)e);
            for (cause = e.getCause(); null != cause && cause instanceof OXException; cause = cause.getCause()) {
            }
            if (null != cause) {
                warnings.add(MailAccountExceptionCodes.VALIDATE_FAILED_TRANSPORT.create(cause, transportConfig.getServer(), transportConfig.getLogin()));
            } else {
                e.setCategory(Category.CATEGORY_WARNING);
                warnings.add(e);
            }
            validated = false;
        }
        finally {
            if (close) {
                mailTransport.close();
            }
        }
        return validated;
    }

    private static void fillMailServerCredentials(MailAccountDescription accountDescription, ServerSession session, boolean invalidate) throws OXException {
        int accountId = accountDescription.getId();
        String login = accountDescription.getLogin();
        String password = accountDescription.getPassword();
        if (accountId >= 0 && (ValidateAction.isEmpty(login) || ValidateAction.isEmpty(password))) {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            MailAccount mailAccount = storageService.getMailAccount(accountDescription.getId(), session.getUserId(), session.getContextId());
            if (invalidate) {
                storageService.invalidateMailAccounts(session.getUserId(), session.getContextId());
            }
            accountDescription.setLogin(mailAccount.getLogin());
            String encPassword = mailAccount.getPassword();
            accountDescription.setPassword(MailPasswordUtil.decrypt(encPassword, session, accountId, accountDescription.getLogin(), accountDescription.getMailServer()));
        }
        ValidateAction.checkNeededFields(accountDescription);
    }

    private static void fillTransportServerCredentials(MailAccountDescription accountDescription, ServerSession session, boolean invalidate) throws OXException {
        int accountId = accountDescription.getId();
        String login = accountDescription.getTransportLogin();
        String password = accountDescription.getTransportPassword();
        if (accountId >= 0 && (ValidateAction.isEmpty(login) || ValidateAction.isEmpty(password))) {
            String encPassword;
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            MailAccount mailAccount = storageService.getMailAccount(accountId, session.getUserId(), session.getContextId());
            if (invalidate) {
                storageService.invalidateMailAccounts(session.getUserId(), session.getContextId());
            }
            if (ValidateAction.isEmpty(login) && ValidateAction.isEmpty(login = mailAccount.getTransportLogin()) && ValidateAction.isEmpty(login = accountDescription.getLogin())) {
                login = mailAccount.getLogin();
            }
            accountDescription.setTransportLogin(login);
            if (ValidateAction.isEmpty(password) && ValidateAction.isEmpty(password = MailPasswordUtil.decrypt(encPassword = mailAccount.getTransportPassword(), session, accountId = mailAccount.getId(), login, mailAccount.getTransportServer())) && ValidateAction.isEmpty(password = accountDescription.getPassword())) {
                encPassword = mailAccount.getPassword();
                password = MailPasswordUtil.decrypt(encPassword, session, accountId, login, mailAccount.getTransportServer());
            }
            accountDescription.setTransportPassword(password);
        }
    }

    private static boolean seemsValid(String str) {
        if (ValidateAction.isEmpty(str)) {
            return false;
        }
        return !"null".equalsIgnoreCase(str);
    }
}

