/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.Tools;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MailAccountJsonUtility {
    private MailAccountJsonUtility() {
    }

    public static List<Attribute> getColumns(String colString) {
        LinkedList<Attribute> attributes = null;
        if (Strings.isNotEmpty((String)colString)) {
            if ("all".equalsIgnoreCase(colString)) {
                return Arrays.asList(Attribute.values());
            }
            attributes = new LinkedList<Attribute>();
            for (String col : Strings.splitByComma((String)colString)) {
                Attribute attr;
                if (!Strings.isNotEmpty((String)col)) continue;
                int id = MailAccountJsonUtility.parseInt(col);
                Attribute attribute = attr = id > 0 ? Attribute.getById(id) : null;
                if (null == attr) continue;
                attributes.add(attr);
            }
            return attributes;
        }
        return Arrays.asList(Attribute.values());
    }

    private static int parseInt(String col) {
        return Tools.getUnsignedInteger(col);
    }

    public static void checkNeededFields(MailAccountDescription accountDescription) throws OXException {
        if (Strings.isEmpty((String)accountDescription.getMailServer())) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("mail_url");
        }
        if (Strings.isEmpty((String)accountDescription.getLogin())) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("login");
        }
        if (Strings.isEmpty((String)accountDescription.getPassword())) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("password");
        }
    }
}

