/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.TransportAuth;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.net.URITools;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.idn.IDNA;

public class TransportAccountDescription {
    private int id = -1;
    private String transportLogin;
    private String name;
    private String transportPassword;
    private String personal;
    private String primaryAddress;
    private String replyTo;
    private TransportAuth transportAuth;
    private int transportPort = 25;
    private String transportProtocol = "smtp";
    private boolean transportSecure;
    private String transportServer;
    private boolean transportStartTls;
    private String transportUrl;
    private Map<String, String> transportProperties = new HashMap<String, String>(4);

    public TransportAccountDescription() {
        this.transportAuth = TransportAuth.MAIL;
    }

    public void parseTransportServerURL(String transportServerURL) throws OXException {
        if (null == transportServerURL) {
            this.setTransportServer((String)null);
            return;
        }
        try {
            this.setTransportServer(URIParser.parse(IDNA.toASCII((String)transportServerURL), URIDefaults.SMTP));
        }
        catch (URISyntaxException e) {
            throw MailAccountExceptionCodes.INVALID_HOST_NAME.create(e, transportServerURL);
        }
    }

    public String generateTransportServerURL() throws OXException {
        if (null != this.transportUrl) {
            return this.transportUrl;
        }
        if (Strings.isEmpty((String)this.transportServer)) {
            return null;
        }
        String protocol = this.transportSecure ? this.transportProtocol + 's' : this.transportProtocol;
        try {
            this.transportUrl = URITools.generateURI(protocol, IDNA.toASCII((String)this.transportServer), this.transportPort).toString();
            return this.transportUrl;
        }
        catch (URISyntaxException e) {
            StringBuilder sb = new StringBuilder(32);
            sb.append(this.transportProtocol);
            if (this.transportSecure) {
                sb.append('s');
            }
            throw MailAccountExceptionCodes.INVALID_HOST_NAME.create(e, sb.append("://").append(this.transportServer).append(':').append(this.transportPort).toString());
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getPersonal() {
        return this.personal;
    }

    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryAddress(String primaryAddress) {
        this.primaryAddress = primaryAddress;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public TransportAuth getTransportAuth() {
        return this.transportAuth;
    }

    public String getTransportLogin() {
        return this.transportLogin;
    }

    public void setTransportLogin(String login) {
        this.transportLogin = login;
    }

    public String getTransportPassword() {
        return this.transportPassword;
    }

    public void setTransportPassword(String password) {
        this.transportPassword = password;
    }

    public int getTransportPort() {
        return this.transportPort;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public String getTransportServer() {
        return this.transportServer;
    }

    public void setTransportServer(String transportServer) {
        this.transportServer = transportServer;
    }

    public void setTransportServer(URI transportServer) {
        if (null == transportServer) {
            this.setTransportServer("");
        } else {
            String protocol = transportServer.getScheme();
            if (protocol.endsWith("s")) {
                this.setTransportSecure(true);
                this.setTransportProtocol(protocol.substring(0, protocol.length() - 1));
            } else {
                this.setTransportSecure(false);
                this.setTransportProtocol(protocol);
            }
            this.setTransportServer(URITools.getHost(transportServer));
            this.setTransportPort(transportServer.getPort());
        }
    }

    public void setTransportAuth(TransportAuth transportAuth) {
        this.transportAuth = transportAuth;
    }

    public void setTransportPort(int transportPort) {
        this.transportUrl = null;
        this.transportPort = TransportAccountDescription.checkTransportPort(transportPort);
    }

    private static int checkTransportPort(int port) {
        if (URIDefaults.IMAP.getPort() == port) {
            return URIDefaults.SMTP.getPort();
        }
        if (URIDefaults.IMAP.getSSLPort() == port) {
            return URIDefaults.SMTP.getSSLPort();
        }
        return port;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportUrl = null;
        this.transportProtocol = transportProtocol;
    }

    public void setTransportSecure(boolean transportSecure) {
        this.transportUrl = null;
        this.transportSecure = transportSecure;
    }

    public void setTransportStartTls(boolean transportStartTls) {
        this.transportStartTls = transportStartTls;
    }

    public boolean isTransportStartTls() {
        return this.transportStartTls;
    }

    public Map<String, String> getTransportProperties() {
        if (this.transportProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(this.transportProperties);
    }

    public void setTransportProperties(Map<String, String> transportProperties) {
        this.transportProperties = null == transportProperties ? new HashMap<String, String>(4) : (transportProperties.isEmpty() ? new HashMap<String, String>(4) : new HashMap<String, String>(transportProperties));
    }

    public void addTransportProperty(String name, String value) {
        if (this.transportProperties.isEmpty()) {
            this.transportProperties = new HashMap<String, String>(4);
        }
        this.transportProperties.put(name, value);
    }
}

