/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.java.Charsets;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DefaultFolderNamesProvider;
import com.openexchange.server.services.ServerServiceRegistry;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StorageUtility {
    private static final Logger LOG = LoggerFactory.getLogger(StorageUtility.class);
    public static final int INDEX_DRAFTS = 0;
    public static final int INDEX_SENT = 1;
    public static final int INDEX_SPAM = 2;
    public static final int INDEX_TRASH = 3;
    public static final int INDEX_CONFIRMED_SPAM = 4;
    public static final int INDEX_CONFIRMED_HAM = 5;
    public static final int INDEX_INBOX = 6;
    public static final int MAIL_PARAM_HARD_DELETE = 1;
    public static final int UNLIMITED_QUOTA = -1;
    public static final Message[] EMPTY_MSGS = new Message[0];
    private static final Pattern PATTERN_PARSE_HEADER = Pattern.compile("(\\S+):\\s(.*)((?:\r?\n(?:\\s(?:.+)))*|(?:$))");
    private static final String SWITCH_DEFAULT_FOLDER = "Switching to default value %s";
    private static final long DEFAULT = -1L;
    private static final int RADIX = 10;

    private StorageUtility() {
    }

    public static long getMaxRunningMillis() {
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null == service) {
            return 60000L;
        }
        return service.getIntProperty("com.openexchange.requestwatcher.maxRequestAge", 60000);
    }

    public static String getAllAddresses(InternetAddress[] internetAddrs) {
        if (internetAddrs == null || internetAddrs.length == 0) {
            return "";
        }
        StringBuilder addressBuilder = new StringBuilder(32 * internetAddrs.length);
        addressBuilder.append(internetAddrs[0].toUnicodeString());
        for (int i = 1; i < internetAddrs.length; ++i) {
            addressBuilder.append(',').append(internetAddrs[i].toUnicodeString());
        }
        return addressBuilder.toString();
    }

    public static Map<HeaderName, String> parseHeaders(byte[] headers) {
        try {
            return StorageUtility.parseHeaders(Charsets.toAsciiString((byte[])headers));
        }
        catch (UnsupportedCharsetException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static Map<HeaderName, String> parseHeaders(String headers) {
        Matcher m = PATTERN_PARSE_HEADER.matcher(MimeMessageUtility.unfold(headers));
        HashMap<HeaderName, String> retval = new HashMap<HeaderName, String>();
        StringBuilder valBuilder = new StringBuilder(256);
        while (m.find()) {
            valBuilder.append(m.group(2));
            if (m.group(3) != null) {
                valBuilder.append(MimeMessageUtility.unfold(m.group(3)));
            }
            retval.put(HeaderName.valueOf(m.group(1)), valBuilder.toString());
            valBuilder.setLength(0);
        }
        return retval;
    }

    public static String[] getDefaultFolderNames(int accountId, UserSettingMail usm) throws OXException {
        return StorageUtility.getDefaultFolderNames(accountId, usm, usm.isSpamEnabled());
    }

    public static String[] getDefaultFolderNames(int accountId, UserSettingMail usm, boolean isSpamEnabled) throws OXException {
        return new DefaultFolderNamesProvider(accountId, usm.getUserId(), usm.getCid()).getDefaultFolderNames(usm.getStdTrashName(), usm.getStdSentName(), usm.getStdDraftsName(), usm.getStdSpamName(), usm.getConfirmedSpam(), usm.getConfirmedHam(), isSpamEnabled);
    }

    @Deprecated
    public static String[] getDefaultFolderNames(String trash, String sent, String drafts, String spam, String confirmedSpam, String confirmedHam, boolean isSpamEnabled) throws MailConfigException {
        OXException e;
        String[] names = new String[isSpamEnabled ? 6 : 4];
        if (drafts == null || drafts.length() == 0) {
            e = MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(MailStrings.DRAFTS);
            LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, MailStrings.DRAFTS), (Throwable)e);
            names[0] = MailStrings.DRAFTS;
        } else {
            names[0] = drafts;
        }
        if (sent == null || sent.length() == 0) {
            e = MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(MailStrings.SENT);
            LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, MailStrings.SENT), (Throwable)e);
            names[1] = MailStrings.SENT;
        } else {
            names[1] = sent;
        }
        if (spam == null || spam.length() == 0) {
            e = MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(MailStrings.SPAM);
            LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, MailStrings.SPAM), (Throwable)e);
            names[2] = MailStrings.SPAM;
        } else {
            names[2] = spam;
        }
        if (trash == null || trash.length() == 0) {
            e = MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(MailStrings.TRASH);
            LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, MailStrings.TRASH), (Throwable)e);
            names[3] = MailStrings.TRASH;
        } else {
            names[3] = trash;
        }
        if (isSpamEnabled) {
            if (confirmedSpam == null || confirmedSpam.length() == 0) {
                e = MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(MailStrings.CONFIRMED_SPAM);
                LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, MailStrings.CONFIRMED_SPAM), (Throwable)e);
                names[4] = MailStrings.CONFIRMED_SPAM;
            } else {
                names[4] = confirmedSpam;
            }
            if (confirmedHam == null || confirmedHam.length() == 0) {
                e = MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(MailStrings.CONFIRMED_HAM);
                LOG.warn(String.format(SWITCH_DEFAULT_FOLDER, MailStrings.CONFIRMED_HAM), (Throwable)e);
                names[5] = MailStrings.CONFIRMED_HAM;
            } else {
                names[5] = confirmedHam;
            }
        }
        return names;
    }

    public static MailFields prepareMailFieldsForSearch(MailField[] mailFields, MailSortField sortField) {
        MailFields usedFields = new MailFields(mailFields);
        usedFields.add(MailField.toField(sortField.getListField()));
        usedFields.add(MailField.RECEIVED_DATE);
        return usedFields;
    }

    public static long parseUnsignedLong(String s) {
        int digit;
        if (s == null) {
            return -1L;
        }
        int max = s.length();
        if (max <= 0) {
            return -1L;
        }
        if (s.charAt(0) == '-') {
            return -1L;
        }
        long result = 0L;
        int i = 0;
        long limit = -9223372036854775807L;
        long multmin = -922337203685477580L;
        if (i < max) {
            if ((digit = StorageUtility.digit(s.charAt(i++))) < 0) {
                return -1L;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = StorageUtility.digit(s.charAt(i++))) < 0) {
                return -1L;
            }
            if (result < -922337203685477580L) {
                return -1L;
            }
            if ((result *= 10L) < -9223372036854775807L + (long)digit) {
                return -1L;
            }
            result -= (long)digit;
        }
        return -result;
    }

    private static int digit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }
}

