/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtility {
    private static final Logger LOG = LoggerFactory.getLogger(AddressUtility.class);

    public static Set<InternetAddress> getAddresses(MailMessage mail, ServerSession session) throws OXException {
        if (mail == null) {
            return Collections.emptySet();
        }
        HashSet<InternetAddress> addrs = new HashSet<InternetAddress>();
        addrs.addAll(Arrays.asList(mail.getFrom()));
        addrs.addAll(Arrays.asList(mail.getTo()));
        addrs.addAll(Arrays.asList(mail.getCc()));
        addrs.addAll(Arrays.asList(mail.getBcc()));
        try {
            String[] aliases;
            if (session == null) {
                return addrs;
            }
            HashSet<QuotedInternetAddress> knownAddresses = new HashSet<QuotedInternetAddress>(4);
            UserSettingMail usm = session.getUserSettingMail();
            if (usm.getSendAddr() != null && usm.getSendAddr().length() > 0) {
                knownAddresses.add(new QuotedInternetAddress(usm.getSendAddr()));
            }
            User user = UserStorage.getInstance().getUser(session.getUserId(), session.getContextId());
            knownAddresses.add(new QuotedInternetAddress(user.getMail()));
            for (String alias : aliases = user.getAliases()) {
                knownAddresses.add(new QuotedInternetAddress(alias));
            }
            addrs.removeAll(knownAddresses);
        }
        catch (AddressException e) {
            LOG.warn("Collected contacts could not be stripped by user's email aliases", (Throwable)e);
        }
        return addrs;
    }
}

