/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.text;

import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.rtf.RTFEditorKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Rtf2HtmlConverter {
    private static final Logger LOG = LoggerFactory.getLogger(Rtf2HtmlConverter.class);

    private Rtf2HtmlConverter() {
    }

    public static String convertRTFToHTML(String rtfContent) {
        HTMLStateMachine hsm = new HTMLStateMachine();
        String htmlBody = Rtf2HtmlConverter.convertRTFStringToHTML(rtfContent, hsm);
        StringBuilder docBuilder = new StringBuilder(htmlBody.length() + 26).append("<html><body>");
        docBuilder.append(HtmlProcessing.formatHrefLinks(htmlBody));
        return docBuilder.append("</body></html>").toString();
    }

    public static String convertRTFStringToHTML(String rtfString) {
        HTMLStateMachine hsm = new HTMLStateMachine();
        RTFEditorKit rtfeditorkit = new RTFEditorKit();
        DefaultStyledDocument defaultstyleddocument = new DefaultStyledDocument();
        Rtf2HtmlConverter.readString(rtfString, defaultstyleddocument, rtfeditorkit);
        return Rtf2HtmlConverter.scanDocument(defaultstyleddocument, hsm);
    }

    private static String convertRTFStringToHTML(String s2, HTMLStateMachine hsm) {
        String s = s2;
        RTFEditorKit rtfeditorkit = new RTFEditorKit();
        DefaultStyledDocument defaultstyleddocument = new DefaultStyledDocument();
        Rtf2HtmlConverter.readString(s, defaultstyleddocument, rtfeditorkit);
        s = Rtf2HtmlConverter.scanDocument(defaultstyleddocument, hsm);
        return s;
    }

    private static void readString(String s, Document document, RTFEditorKit rtfeditorkit) {
        try {
            rtfeditorkit.read((InputStream)new UnsynchronizedByteArrayInputStream(Charsets.toAsciiBytes((String)s)), document, 0);
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            return;
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return;
        }
    }

    private static String scanDocument(Document document, HTMLStateMachine hsm) {
        try {
            StringBuilder sb = new StringBuilder(document.getLength());
            Element element = document.getDefaultRootElement();
            Rtf2HtmlConverter.recurseElements(element, document, sb, hsm);
            hsm.closeTags(sb);
            return sb.toString();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return "";
        }
    }

    private static void recurseElements(Element element, Document document, StringBuilder sb, HTMLStateMachine hsm) {
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element1 = element.getElement(i);
            Rtf2HtmlConverter.scanAttributes(element1, document, sb, hsm);
            Rtf2HtmlConverter.recurseElements(element1, document, sb, hsm);
        }
    }

    private static void scanAttributes(Element element, Document document, StringBuilder sb, HTMLStateMachine hsm) {
        try {
            int i = element.getStartOffset();
            int j = element.getEndOffset();
            String s = document.getText(i, j - i);
            AttributeSet attributeset = element.getAttributes();
            hsm.updateState(attributeset, sb, element);
            String s1 = element.getName();
            if (s1.equalsIgnoreCase("content")) {
                s = s.replaceAll("\\t", Strings.quoteReplacement((String)hsm.getSpaceTab(8)));
                s = s.replaceAll("\\n", "<br />\n");
                s = hsm.performFirstLineIndent(s);
                sb.append(s);
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return;
        }
    }

    private static final class HTMLStateMachine {
        private static final String[] alignNames = new String[]{"left", "center", "right"};
        private final boolean acceptFonts;
        private String fontName = "";
        private Color color = null;
        private int size = -1;
        private int alignment = -1;
        private boolean bold = false;
        private boolean italic = false;
        private boolean underline = false;
        private double firstLineIndent = 0.0;
        private double oldLeftIndent = 0.0;
        private double oldRightIndent = 0.0;
        private double leftIndent = 0.0;
        private double rightIndent = 0.0;
        private boolean firstLine = false;

        HTMLStateMachine() {
            this.acceptFonts = true;
        }

        public void updateState(AttributeSet attributeset, StringBuilder sb, Element element) {
            String s = element.getName();
            if (s.equalsIgnoreCase("paragraph")) {
                this.firstLine = true;
            }
            this.leftIndent = this.updateDouble(attributeset, this.leftIndent, StyleConstants.LeftIndent);
            this.rightIndent = this.updateDouble(attributeset, this.rightIndent, StyleConstants.RightIndent);
            if (this.leftIndent != this.oldLeftIndent || this.rightIndent != this.oldRightIndent) {
                this.closeIndentTable(sb, this.oldLeftIndent, this.oldRightIndent);
            }
            this.bold = this.updateBoolean(attributeset, StyleConstants.Bold, "b", this.bold, sb);
            this.italic = this.updateBoolean(attributeset, StyleConstants.Italic, "i", this.italic, sb);
            this.underline = this.updateBoolean(attributeset, StyleConstants.Underline, "u", this.underline, sb);
            this.size = this.updateFontSize(attributeset, this.size, sb);
            this.color = this.updateFontColor(attributeset, this.color, sb);
            if (this.acceptFonts) {
                this.fontName = this.updateFontName(attributeset, this.fontName, sb);
            }
            this.alignment = this.updateAlignment(attributeset, this.alignment, sb);
            this.firstLineIndent = this.updateDouble(attributeset, this.firstLineIndent, StyleConstants.FirstLineIndent);
            if (this.leftIndent != this.oldLeftIndent || this.rightIndent != this.oldRightIndent) {
                this.openIndentTable(sb, this.leftIndent, this.rightIndent);
                this.oldLeftIndent = this.leftIndent;
                this.oldRightIndent = this.rightIndent;
            }
        }

        private void openIndentTable(StringBuilder sb, double d, double d1) {
            if (d != 0.0 || d1 != 0.0) {
                this.closeSubsetTags(sb);
                sb.append("<table><tr>");
                String s = this.getSpaceTab((int)(d / 4.0));
                if (s.length() > 0) {
                    sb.append("<td>").append(s).append("</td>");
                }
                sb.append("<td>");
            }
        }

        private void closeIndentTable(StringBuilder sb, double d, double d1) {
            if (d != 0.0 || d1 != 0.0) {
                this.closeSubsetTags(sb);
                sb.append("</td>");
                String s = this.getSpaceTab((int)(d1 / 4.0));
                if (s.length() > 0) {
                    sb.append("<td>").append(s).append("</td>");
                }
                sb.append("</tr></table>");
            }
        }

        void closeTags(StringBuilder sb) {
            this.closeSubsetTags(sb);
            this.closeTag(this.alignment, -1, "div", sb);
            this.alignment = -1;
            this.closeIndentTable(sb, this.oldLeftIndent, this.oldRightIndent);
        }

        private void closeSubsetTags(StringBuilder sb) {
            this.closeTag(this.bold, "b", sb);
            this.closeTag(this.italic, "i", sb);
            this.closeTag(this.underline, "u", sb);
            this.closeTag(this.color, "font", sb);
            this.closeTag(this.fontName, "font", sb);
            this.closeTag(this.size, -1, "font", sb);
            this.bold = false;
            this.italic = false;
            this.underline = false;
            this.color = null;
            this.fontName = "";
            this.size = -1;
        }

        private void closeTag(boolean flag, String s, StringBuilder sb) {
            if (flag) {
                sb.append("</").append(s).append('>');
            }
        }

        private void closeTag(Color color1, String s, StringBuilder sb) {
            if (color1 != null) {
                sb.append("</").append(s).append('>');
            }
        }

        private void closeTag(String s, String s1, StringBuilder sb) {
            if (s.length() > 0) {
                sb.append("</").append(s1).append('>');
            }
        }

        private void closeTag(int i, int j, String s, StringBuilder sb) {
            if (i > j) {
                sb.append("</").append(s).append('>');
            }
        }

        private int updateAlignment(AttributeSet attributeset, int k, StringBuilder sb) {
            int i = k;
            Object obj = attributeset.getAttribute(StyleConstants.Alignment);
            if (obj == null) {
                return i;
            }
            int j = (Integer)obj;
            if (j == 3) {
                j = 0;
            }
            if (j != i && j >= 0 && j <= 2) {
                if (i > -1) {
                    sb.append("</div>");
                }
                sb.append("<div align=\"").append(alignNames[j]).append("\">");
                i = j;
            }
            return i;
        }

        private Color updateFontColor(AttributeSet attributeset, Color color3, StringBuilder sb) {
            Color color1 = color3;
            Object obj = attributeset.getAttribute(StyleConstants.Foreground);
            if (obj == null) {
                return color1;
            }
            Color color2 = (Color)obj;
            if (color2 != color1) {
                if (color1 != null) {
                    sb.append("</font>");
                }
                sb.append("<font color=\"#").append(this.makeColorString(color2)).append("\">");
            }
            color1 = color2;
            return color1;
        }

        private String updateFontName(AttributeSet attributeset, String s2, StringBuilder sb) {
            String s = s2;
            Object obj = attributeset.getAttribute(StyleConstants.FontFamily);
            if (obj == null) {
                return s;
            }
            String s1 = (String)obj;
            if (!s1.equals(s)) {
                if (!"".equals(s)) {
                    sb.append("</font>");
                }
                sb.append("<font face=\"").append(s1).append("\">");
            }
            s = s1;
            return s;
        }

        private double updateDouble(AttributeSet attributeset, double d2, Object obj) {
            double d = d2;
            Object obj1 = attributeset.getAttribute(obj);
            if (obj1 != null) {
                d = ((Float)obj1).floatValue();
            }
            return d;
        }

        private int updateFontSize(AttributeSet attributeset, int k, StringBuilder sb) {
            int i = k;
            Object obj = attributeset.getAttribute(StyleConstants.FontSize);
            if (obj == null) {
                return i;
            }
            int j = (Integer)obj;
            if (j != i) {
                if (i != -1) {
                    sb.append("</font>");
                }
                sb.append("<font size=\"").append(j >> 2).append("\">");
            }
            i = j;
            return i;
        }

        private boolean updateBoolean(AttributeSet attributeset, Object obj, String s, boolean flag2, StringBuilder sb) {
            boolean flag = flag2;
            Object obj1 = attributeset.getAttribute(obj);
            if (obj1 != null) {
                boolean flag1 = (Boolean)obj1;
                if (flag1 != flag) {
                    if (flag1) {
                        sb.append('<').append(s).append('>');
                    } else {
                        sb.append("</").append(s).append('>');
                    }
                }
                flag = flag1;
            }
            return flag;
        }

        private String makeColorString(Color color1) {
            String s = Long.toString(color1.getRGB() & 0xFFFFFF, 16);
            if (s.length() < 6) {
                StringBuilder sb = new StringBuilder();
                for (int i = s.length(); i < 6; ++i) {
                    sb.append('0');
                }
                sb.append(s);
                s = sb.toString();
            }
            return s;
        }

        public String performFirstLineIndent(String s2) {
            String s = s2;
            if (this.firstLine) {
                if (this.firstLineIndent != 0.0) {
                    int i = (int)(this.firstLineIndent / 4.0);
                    s = this.getSpaceTab(i) + s;
                }
                this.firstLine = false;
            }
            return s;
        }

        public String getSpaceTab(int i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                sb.append("&nbsp;");
            }
            return sb.toString();
        }
    }
}

