/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.BooleanTerm;
import com.openexchange.mail.search.CatenatingTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import java.util.Set;
import javax.mail.FetchProfile;
import javax.mail.Message;
import javax.mail.search.OrTerm;

public final class ORTerm
extends CatenatingTerm {
    private static final long serialVersionUID = 2984060879603969678L;

    protected ORTerm() {
    }

    public ORTerm(SearchTerm<?> firstTerm, SearchTerm<?> secondTerm) {
        super(firstTerm, secondTerm);
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        this.terms[0].addMailField(col);
        this.terms[1].addMailField(col);
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        SearchTerm t1 = this.terms[0];
        SearchTerm t2 = this.terms[1];
        if (t1 instanceof BooleanTerm) {
            return t2.getJavaMailSearchTerm();
        }
        if (t2 instanceof BooleanTerm) {
            return t1.getJavaMailSearchTerm();
        }
        return new OrTerm(t1.getJavaMailSearchTerm(), t2.getJavaMailSearchTerm());
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        SearchTerm t1 = this.terms[0];
        SearchTerm t2 = this.terms[1];
        if (t1 instanceof BooleanTerm) {
            return t2.getNonWildcardJavaMailSearchTerm();
        }
        if (t2 instanceof BooleanTerm) {
            return t1.getNonWildcardJavaMailSearchTerm();
        }
        return new OrTerm(t1.getNonWildcardJavaMailSearchTerm(), t2.getNonWildcardJavaMailSearchTerm());
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
        this.terms[0].contributeTo(fetchProfile);
        this.terms[1].contributeTo(fetchProfile);
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        return this.terms[0].matches(msg) || this.terms[1].matches(msg);
    }

    @Override
    public boolean matches(MailMessage mailMessage) throws OXException {
        return this.terms[0].matches(mailMessage) || this.terms[1].matches(mailMessage);
    }

    @Override
    public SearchTerm<?> filter(Set<Class<? extends SearchTerm>> filterSet) {
        if (filterSet.contains(this.getClass())) {
            return BooleanTerm.FALSE;
        }
        ORTerm orTerm = new ORTerm();
        if (filterSet.contains(this.terms[0].getClass())) {
            orTerm.setFirstTerm(BooleanTerm.FALSE);
        } else {
            orTerm.setFirstTerm(this.terms[1].filter(filterSet));
        }
        if (filterSet.contains(this.terms[1].getClass())) {
            orTerm.setSecondTerm(BooleanTerm.FALSE);
        } else {
            orTerm.setSecondTerm(this.terms[1].filter(filterSet));
        }
        return orTerm;
    }

    @Override
    public boolean isAscii() {
        return this.terms[0].isAscii() && this.terms[1].isAscii();
    }

    @Override
    public boolean containsWildcard() {
        return this.terms[0].containsWildcard() || this.terms[1].containsWildcard();
    }
}

