/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import com.sun.mail.imap.IMAPFolder;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.mail.FetchProfile;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.slf4j.LoggerFactory;

public final class HeaderTerm
extends SearchTerm<String[]> {
    private static final long serialVersionUID = -167353933722555256L;
    private final String[] hdr;

    public HeaderTerm(String headerName, String headerValue) {
        this.hdr = new String[]{headerName, headerValue};
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String[] getPattern() {
        return this.hdr;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.HEADERS);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        String val = mailMessage.getHeader(this.hdr[0], ", ");
        if (val == null) {
            return this.hdr[1] == null;
        }
        if (this.containsWildcard()) {
            return HeaderTerm.toRegex(this.hdr[1]).matcher(val).find();
        }
        return Strings.asciiLowerCase((String)val).contains(Strings.asciiLowerCase((String)this.hdr[1]));
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        String[] val;
        try {
            val = msg.getHeader(this.hdr[0]);
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(HeaderTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
        if (val == null || val.length == 0) {
            return this.hdr[1] == null;
        }
        if (this.containsWildcard()) {
            Pattern p = HeaderTerm.toRegex(this.hdr[1]);
            boolean found = false;
            for (int i = 0; i < val.length && !found; ++i) {
                found = p.matcher(val[i]).find();
            }
            return found;
        }
        boolean found = false;
        for (int i = 0; i < val.length && !found; ++i) {
            found = Strings.asciiLowerCase((String)val[i]).contains(Strings.asciiLowerCase((String)this.hdr[1]));
        }
        return found;
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new javax.mail.search.HeaderTerm(this.hdr[0], this.hdr[1]);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new javax.mail.search.HeaderTerm(this.hdr[0], HeaderTerm.getNonWildcardPart(this.hdr[1]));
    }

    @Override
    public boolean isAscii() {
        return HeaderTerm.isAscii(this.hdr[1]);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.hdr || null == this.hdr[1] ? false : this.hdr[1].indexOf(42) >= 0 || this.hdr[1].indexOf(63) >= 0;
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
        if (!fetchProfile.contains((FetchProfile.Item)IMAPFolder.FetchProfileItem.HEADERS)) {
            fetchProfile.add((FetchProfile.Item)IMAPFolder.FetchProfileItem.HEADERS);
        }
    }
}

