/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.processing;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.html.HtmlService;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.image.ImageLocation;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.conversion.InlineImageDataSource;
import com.openexchange.mail.dataobjects.CompositeMailMessage;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeSmilFixer;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.dataobjects.NestedMessageMailPart;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.processing.AbstractMimeProcessing;
import com.openexchange.mail.mime.processing.LocaleAndTimeZone;
import com.openexchange.mail.mime.processing.MimeProcessingUtility;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.InlineContentHandler;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.UnifiedInboxUID;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.regex.MatcherReplacer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeReply
extends AbstractMimeProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(MimeReply.class);
    private static final String PREFIX_RE = "Re: ";
    private static final Pattern PAT_META_CT = Pattern.compile("<meta[^>]*?http-equiv=\"?content-type\"?[^>]*?>", 2);
    private static final String MULTIPART = "multipart/";
    private static final String TEXT = "text/";
    private static final String TEXT_HTM = "text/htm";
    private static final Pattern PATTERN_BODY_TAG = Pattern.compile("<body[^>]*?>", 2);
    private static final Pattern PATTERN_BLOCKQUOTE_TAG = Pattern.compile("<blockquote[^>]*?>", 2);
    private static final Pattern PATTERN_TEXT_CITE = Pattern.compile("^", 8);
    private static final Pattern PATTERN_HTML_START = Pattern.compile("<html[^>]*?>", 2);
    private static final Pattern PATTERN_HTML_END = Pattern.compile("</html>", 2);
    private static final String BLOCKQUOTE_START = "<blockquote type=\"cite\" style=\"position: relative; margin-left: 0px; padding-left: 10px; border-left: solid 1px blue;\">\n";
    private static final String BLOCKQUOTE_END = "</blockquote>\n<br>&nbsp;";
    private static final Pattern PATTERN_CONTENT = Pattern.compile("(<[a-zA-Z]+[^>]*?>)?\\p{L}+");

    private MimeReply() {
    }

    public static MailMessage getReplyMail(MailMessage originalMail, boolean replyAll, Session session, int accountId) throws OXException {
        return MimeReply.getReplyMail(originalMail, replyAll, session, accountId, null, false);
    }

    public static MailMessage getReplyMail(MailMessage originalMail, boolean replyAll, Session session, int accountId, boolean setFrom) throws OXException {
        return MimeReply.getReplyMail(originalMail, replyAll, session, accountId, null, setFrom);
    }

    public static MailMessage getReplyMail(MailMessage originalMail, boolean replyAll, Session session, int accountId, UserSettingMail usm) throws OXException {
        return MimeReply.getReplyMail(originalMail, replyAll, session, accountId, usm, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailMessage getReplyMail(MailMessage originalMail, boolean replyAll, Session session, int accountId, UserSettingMail usm, boolean setFrom) throws OXException {
        boolean preferToAsRecipient = false;
        String originalMailFolder = originalMail.getFolder();
        MailPath msgref = null;
        if (originalMail.getMailId() != null && originalMailFolder != null) {
            msgref = new MailPath(accountId, originalMailFolder, originalMail.getMailId());
            String[] arr = (String[])MailSessionCache.getInstance(session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
            if (arr == null) {
                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
                try {
                    mailAccess = MailAccess.getInstance(session, accountId);
                    mailAccess.connect();
                    IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
                    preferToAsRecipient = originalMailFolder.equals(folderStorage.getSentFolder()) || originalMailFolder.equals(folderStorage.getDraftsFolder());
                }
                finally {
                    if (null != mailAccess) {
                        mailAccess.close(false);
                    }
                }
            } else {
                preferToAsRecipient = originalMailFolder.equals(arr[1]) || originalMailFolder.equals(arr[0]);
            }
        }
        return MimeReply.getReplyMail(originalMail, msgref, replyAll, preferToAsRecipient, session, accountId, MimeDefaultSession.getDefaultSession(), usm, setFrom);
    }

    private static String replaceMetaEquiv(String html, ContentType contentType) {
        Matcher m = PAT_META_CT.matcher(html);
        MatcherReplacer mr = new MatcherReplacer(m, html);
        StringBuilder replaceBuffer = new StringBuilder(html.length());
        if (m.find()) {
            replaceBuffer.append("<meta http-equiv=\"Content-Type\" content=\"").append(Strings.toLowerCase((CharSequence)contentType.getBaseType()));
            replaceBuffer.append("; charset=").append(contentType.getCharsetParameter()).append("\" />");
            String replacement = replaceBuffer.toString();
            replaceBuffer.setLength(0);
            mr.appendLiteralReplacement(replaceBuffer, replacement);
        }
        mr.appendTail(replaceBuffer);
        return replaceBuffer.toString();
    }

    private static MailMessage getReplyMail(MailMessage originalMsg, MailPath msgref, boolean replyAll, boolean preferToAsRecipient, Session session, int accountId, javax.mail.Session mailSession, UserSettingMail userSettingMail, boolean setFrom) throws OXException {
        try {
            String cs;
            InternetAddress[] recipientAddrs;
            originalMsg.setAccountId(accountId);
            ContentType contentType = originalMsg.getContentType();
            MailMessage origMsg = contentType.startsWith("multipart/related") && "application/smil".equals(Strings.asciiLowerCase((String)contentType.getParameter("type"))) ? MimeSmilFixer.getInstance().process(originalMsg) : ManagedMimeMessage.clone(originalMsg);
            Context ctx = ContextStorage.getStorageContext(session.getContextId());
            UserSettingMail usm = userSettingMail == null ? UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx) : userSettingMail;
            MimeMessage replyMsg = new MimeMessage(MimeDefaultSession.getDefaultSession());
            String subjectHdrValue = MimeMessageUtility.checkNonAscii(origMsg.getHeader(MessageHeaders.HDR_SUBJECT, null));
            String rawSubject = subjectHdrValue == null ? "" : MimeMessageUtility.unfold(subjectHdrValue);
            String decodedSubject = MimeMessageUtility.decodeMultiEncodedHeader(rawSubject);
            String newSubject = decodedSubject.regionMatches(true, 0, PREFIX_RE, 0, 4) ? decodedSubject : PREFIX_RE + decodedSubject;
            replyMsg.setSubject(newSubject, MailProperties.getInstance().getDefaultMimeCharset());
            InternetAddress from = null;
            if (setFrom && null != (from = MimeProcessingUtility.determinePossibleFrom(false, origMsg, accountId, session, ctx))) {
                replyMsg.setFrom((Address)from);
            }
            if (preferToAsRecipient) {
                String hdrVal = origMsg.getHeader(MessageHeaders.HDR_TO, ",");
                recipientAddrs = null == hdrVal ? new InternetAddress[]{} : MimeMessageUtility.parseAddressList(hdrVal, true);
            } else {
                boolean fromAdded;
                LinkedHashSet<InternetAddress> tmpSet = new LinkedHashSet<InternetAddress>(4);
                String[] replyTo = origMsg.getHeader(MessageHeaders.HDR_REPLY_TO);
                if (MimeMessageUtility.isEmptyHeader(replyTo)) {
                    User[] users;
                    String owner;
                    String string = owner = null == msgref ? null : MimeProcessingUtility.getFolderOwnerIfShared(msgref.getFolder(), msgref.getAccountId(), session);
                    if (null != owner && null != (users = UserStorage.getInstance().searchUserByMailLogin(owner, ctx)) && users.length > 0) {
                        QuotedInternetAddress onBehalfOf = new QuotedInternetAddress(users[0].getMail(), false);
                        replyMsg.setFrom((Address)onBehalfOf);
                        QuotedInternetAddress sender = new QuotedInternetAddress(usm.getSendAddr(), false);
                        replyMsg.setSender((Address)sender);
                    }
                    tmpSet.addAll(Arrays.asList(origMsg.getFrom()));
                    fromAdded = true;
                } else {
                    tmpSet.addAll(Arrays.asList(MimeMessageConverter.getAddressHeader(MimeMessageUtility.unfold(replyTo[0]))));
                    fromAdded = false;
                }
                if (replyAll && !fromAdded) {
                    tmpSet.addAll(Arrays.asList(origMsg.getFrom()));
                }
                recipientAddrs = tmpSet.toArray(new InternetAddress[tmpSet.size()]);
            }
            if (replyAll) {
                HashSet<InternetAddress> filter = new HashSet<InternetAddress>();
                if (null != from) {
                    filter.add(from);
                }
                if (accountId == 0) {
                    MimeReply.addUserAddresses(filter, mailSession, session, ctx);
                } else {
                    ServerServiceRegistry registry = ServerServiceRegistry.getInstance();
                    UnifiedInboxManagement management = registry.getService(UnifiedInboxManagement.class);
                    if (null != management && accountId == management.getUnifiedINBOXAccountID(session)) {
                        int realAccountId;
                        try {
                            UnifiedInboxUID uid = new UnifiedInboxUID(origMsg.getMailId());
                            realAccountId = uid.getAccountId();
                        }
                        catch (OXException e) {
                            FullnameArgument fa = UnifiedInboxUID.parsePossibleNestedFullName(origMsg.getFolder());
                            int n = realAccountId = null == fa ? 0 : fa.getAccountId();
                        }
                        if (realAccountId == 0) {
                            MimeReply.addUserAddresses(filter, mailSession, session, ctx);
                        } else {
                            MailAccountStorageService mass = registry.getService(MailAccountStorageService.class);
                            if (null == mass) {
                                MimeReply.addUserAddresses(filter, mailSession, session, ctx);
                            } else {
                                filter.add(new QuotedInternetAddress(mass.getMailAccount(realAccountId, session.getUserId(), session.getContextId()).getPrimaryAddress(), false));
                            }
                        }
                    } else {
                        MailAccountStorageService mass = registry.getService(MailAccountStorageService.class);
                        if (null == mass) {
                            MimeReply.addUserAddresses(filter, mailSession, session, ctx);
                        } else {
                            filter.add(new QuotedInternetAddress(mass.getMailAccount(accountId, session.getUserId(), session.getContextId()).getPrimaryAddress(), false));
                        }
                    }
                }
                boolean replyallcc = usm.isReplyAllCc();
                Set<InternetAddress> filteredAddrs = MimeReply.filter(filter, recipientAddrs);
                String hdrVal = origMsg.getHeader(MessageHeaders.HDR_TO, ",");
                InternetAddress[] toAddrs = null;
                if (hdrVal != null) {
                    toAddrs = MimeMessageUtility.parseAddressList(hdrVal, true);
                    filteredAddrs.addAll(MimeReply.filter(filter, toAddrs));
                }
                if (!filteredAddrs.isEmpty()) {
                    if (replyallcc) {
                        replyMsg.addRecipients(Message.RecipientType.TO, (Address[])recipientAddrs);
                        filteredAddrs.removeAll(Arrays.asList(recipientAddrs));
                        replyMsg.addRecipients(Message.RecipientType.CC, (Address[])filteredAddrs.toArray(new InternetAddress[filteredAddrs.size()]));
                    } else {
                        replyMsg.addRecipients(Message.RecipientType.TO, (Address[])filteredAddrs.toArray(new InternetAddress[filteredAddrs.size()]));
                    }
                } else if (toAddrs != null) {
                    HashSet<InternetAddress> tmpSet = new HashSet<InternetAddress>(Arrays.asList(recipientAddrs));
                    tmpSet.removeAll(Arrays.asList(toAddrs));
                    if (tmpSet.isEmpty()) {
                        replyMsg.addRecipients(Message.RecipientType.TO, (Address[])recipientAddrs);
                    }
                }
                filteredAddrs.clear();
                hdrVal = origMsg.getHeader(MessageHeaders.HDR_CC, ",");
                if (hdrVal != null) {
                    filteredAddrs.addAll(MimeReply.filter(filter, MimeMessageUtility.parseAddressList(MimeMessageUtility.unfold(hdrVal), true)));
                }
                if (!filteredAddrs.isEmpty()) {
                    replyMsg.addRecipients(Message.RecipientType.CC, (Address[])filteredAddrs.toArray(new InternetAddress[filteredAddrs.size()]));
                }
                filteredAddrs.clear();
                hdrVal = origMsg.getHeader(MessageHeaders.HDR_BCC, ",");
                if (hdrVal != null) {
                    filteredAddrs.addAll(MimeReply.filter(filter, MimeMessageUtility.parseAddressList(MimeMessageUtility.unfold(hdrVal), true)));
                }
                if (!filteredAddrs.isEmpty()) {
                    replyMsg.addRecipients(Message.RecipientType.BCC, (Address[])filteredAddrs.toArray(new InternetAddress[filteredAddrs.size()]));
                }
            } else {
                replyMsg.addRecipients(Message.RecipientType.TO, (Address[])recipientAddrs);
            }
            if (usm.getAttachOriginalMessage() > 0) {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart textPart = new MimeBodyPart();
                MessageUtility.setText("", MailProperties.getInstance().getDefaultMimeCharset(), "plain", (Part)textPart);
                textPart.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
                textPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, "text/plain; charset=#CS#".replaceFirst("#CS#", MailProperties.getInstance().getDefaultMimeCharset()));
                multipart.addBodyPart((BodyPart)textPart);
                MessageUtility.setContent((Multipart)multipart, (Part)replyMsg);
                replyMsg.saveChanges();
                replyMsg.removeHeader(MessageHeaders.HDR_MESSAGE_ID);
                CompositeMailMessage compositeMail = new CompositeMailMessage(MimeMessageConverter.convertMessage(replyMsg));
                MailMessage nested = originalMsg instanceof MimeMailMessage ? MimeMessageConverter.convertMessage(((MimeMailMessage)originalMsg).getMimeMessage()) : MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), MimeMessageUtility.getStreamFromMailPart(originalMsg)));
                nested.setMsgref(originalMsg.getMailPath());
                compositeMail.addAdditionalParts(new NestedMessageMailPart(nested));
                return compositeMail;
            }
            if (usm.isIgnoreOriginalMailTextOnReply()) {
                MessageUtility.setText("", MailProperties.getInstance().getDefaultMimeCharset(), (Part)replyMsg);
                replyMsg.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
                ContentType newContentType = new ContentType().setPrimaryType("text").setSubType("plain").setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
                newContentType.setParameter("nature", "virtual");
                replyMsg.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(newContentType.toString()));
                MailMessage replyMail = MimeMessageConverter.convertMessage(replyMsg);
                if (null != msgref) {
                    replyMail.setMsgref(msgref);
                }
                return replyMail;
            }
            ContentType retvalContentType = new ContentType();
            LinkedList<String> list = new LinkedList<String>();
            User user = UserStorage.getInstance().getUser(session.getUserId(), ctx);
            Locale locale = user.getLocale();
            LocaleAndTimeZone ltz = new LocaleAndTimeZone(locale, user.getTimeZone());
            MimeReply.generateReplyText(origMsg, retvalContentType, StringHelper.valueOf(locale), ltz, usm, mailSession, session, accountId, list);
            StringBuilder replyTextBuilder = new StringBuilder(16384);
            for (int i = list.size() - 1; i >= 0; --i) {
                replyTextBuilder.append((String)list.get(i));
            }
            if (retvalContentType.getPrimaryType() == null) {
                retvalContentType.setContentType("text/plain");
            }
            if ((cs = retvalContentType.getCharsetParameter()) == null || "US-ASCII".equalsIgnoreCase(cs) || !CharsetDetector.isValid((String)cs) || MessageUtility.isSpecialCharset(cs)) {
                retvalContentType.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
            }
            if (replyTextBuilder.length() <= 0) {
                retvalContentType.setParameter("nature", "virtual");
                String replyPrefix = MimeReply.generatePrefixText("On #DATE# at #TIME# #SENDER# wrote:", ltz, origMsg);
                boolean isHtml = retvalContentType.startsWith(TEXT_HTM);
                replyPrefix = isHtml ? HtmlProcessing.htmlFormat(new StringBuilder(replyPrefix.length() + 1).append(replyPrefix).append('\n').append('\n').toString()) : new StringBuilder(replyPrefix.length() + 1).append(replyPrefix).append('\n').append('\n').toString();
                replyTextBuilder.append(replyPrefix);
            }
            String replyText = replyTextBuilder.toString();
            if (retvalContentType.startsWith(TEXT_HTM)) {
                retvalContentType.setCharsetParameter("UTF-8");
                replyText = MimeReply.replaceMetaEquiv(replyText, retvalContentType);
            }
            MessageUtility.setText(replyText, retvalContentType.getCharsetParameter(), retvalContentType.getSubType(), (Part)replyMsg);
            replyMsg.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
            replyMsg.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(retvalContentType.toString()));
            replyMsg.saveChanges();
            replyMsg.removeHeader(MessageHeaders.HDR_MESSAGE_ID);
            MimeMessageFiller.setReplyHeaders(origMsg, replyMsg);
            MailMessage replyMail = MimeMessageConverter.convertMessage(replyMsg);
            if (null != msgref) {
                replyMail.setMsgref(msgref);
            }
            return replyMail;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static void addUserAddresses(Set<InternetAddress> filter, javax.mail.Session mailSession, Session session, Context ctx) throws OXException {
        String alternates;
        if (InternetAddress.getLocalAddress((javax.mail.Session)mailSession) != null) {
            filter.add(InternetAddress.getLocalAddress((javax.mail.Session)mailSession));
        }
        if ((alternates = mailSession.getProperty("mail.alternates")) != null) {
            filter.addAll(Arrays.asList(MimeMessageUtility.parseAddressList(alternates, false)));
        }
        MimeProcessingUtility.addUserAliases(filter, session, ctx);
    }

    private static void appendInlineContent(MailMessage originalMail, CompositeMailMessage replyMail, List<String> cids) throws OXException {
        InlineContentHandler handler = new InlineContentHandler(cids);
        new MailMessageParser().parseMailMessage(originalMail, handler);
        Map<String, MailPart> inlineContents = handler.getInlineContents();
        for (String cid : cids) {
            MailPart part = inlineContents.get(cid);
            if (null == part) continue;
            replyMail.addAdditionalParts(part);
        }
    }

    private static Set<InternetAddress> filter(Set<InternetAddress> filter, InternetAddress[] addrs) {
        if (addrs == null) {
            return new HashSet<InternetAddress>(0);
        }
        HashSet<InternetAddress> set = new HashSet<InternetAddress>(Arrays.asList(addrs));
        set.removeAll(filter);
        filter.addAll(set);
        return set;
    }

    static boolean generateReplyText(MailMessage msg, ContentType retvalContentType, StringHelper strHelper, LocaleAndTimeZone ltz, UserSettingMail usm, javax.mail.Session mailSession, Session session, int accountId, List<String> replyTexts) throws OXException, MessagingException, IOException {
        StringBuilder textBuilder = new StringBuilder(8192);
        ContentType contentType = msg.getContentType();
        boolean found = false;
        if (contentType.startsWith(MULTIPART)) {
            ParameterContainer pc = new ParameterContainer(retvalContentType, textBuilder, strHelper, usm, mailSession, session, msg, ltz, replyTexts);
            found |= MimeReply.gatherAllTextContents(msg, contentType, accountId, pc);
        } else if (contentType.startsWith(TEXT) && !MimeProcessingUtility.isSpecial(contentType.getBaseType())) {
            String text;
            if (retvalContentType.getPrimaryType() == null) {
                text = MimeProcessingUtility.handleInlineTextPart(msg, contentType, usm.isDisplayHtmlInlineContent());
                retvalContentType.setContentType(contentType);
                textBuilder.append(text);
            } else {
                text = MimeProcessingUtility.handleInlineTextPart(msg, contentType, usm.isDisplayHtmlInlineContent());
                MimeProcessingUtility.appendRightVersion(retvalContentType, contentType, text, textBuilder);
            }
            found = true;
        }
        if (found && !usm.isDropReplyForwardPrefix()) {
            String replyTextBody;
            boolean prependReplyPrefx;
            boolean isHtml = retvalContentType.startsWith(TEXT_HTM);
            String replyPrefix = MimeReply.generatePrefixText("On #DATE# at #TIME# #SENDER# wrote:", ltz, msg);
            char nextLine = '\n';
            replyPrefix = isHtml ? HtmlProcessing.htmlFormat(new StringBuilder(replyPrefix.length() + 1).append(replyPrefix).append(nextLine).append(nextLine).toString()) : new StringBuilder(replyPrefix.length() + 1).append(replyPrefix).append(nextLine).append(nextLine).toString();
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean bl = prependReplyPrefx = null == service ? false : service.getBoolProperty("com.openexchange.mail.prependReplyPrefx", false);
            if (prependReplyPrefx) {
                replyTextBody = isHtml ? MimeReply.citeHtml(textBuilder.toString()) : MimeReply.citeText(textBuilder.toString());
                textBuilder.setLength(0);
                if (isHtml) {
                    textBuilder.append("<br>");
                } else {
                    textBuilder.append('\n');
                }
                textBuilder.append(replyPrefix);
                textBuilder.append(replyTextBody);
            } else {
                if (isHtml) {
                    textBuilder.insert(MimeReply.getBodyTagEndPos(textBuilder), replyPrefix);
                    replyTextBody = MimeReply.citeHtml(textBuilder.toString());
                } else {
                    textBuilder.insert(0, replyPrefix);
                    textBuilder.insert(replyPrefix.length(), '\n');
                    replyTextBody = MimeReply.citeText(textBuilder.toString());
                }
                textBuilder.setLength(0);
                textBuilder.append(replyTextBody);
                if (isHtml) {
                    textBuilder.insert(MimeReply.getBlockquoteTagStartPos(textBuilder), "<br>");
                } else {
                    textBuilder.insert(0, '\n');
                }
            }
        }
        replyTexts.add(textBuilder.toString());
        return found;
    }

    private static int getBodyTagEndPos(CharSequence textBuilder) {
        Matcher m = PATTERN_BODY_TAG.matcher(textBuilder);
        return m.find() ? m.end() : 0;
    }

    private static int getBlockquoteTagStartPos(CharSequence textBuilder) {
        Matcher m = PATTERN_BLOCKQUOTE_TAG.matcher(textBuilder);
        return m.find() ? m.start() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean gatherAllTextContents(MailPart multipartPart, ContentType mpContentType, int accountId, ParameterContainer pc) throws OXException, MessagingException, IOException {
        int count = multipartPart.getEnclosedCount();
        ContentType partContentType = new ContentType();
        boolean htmlPreferred = pc.usm.isDisplayHtmlInlineContent();
        boolean found = false;
        if (htmlPreferred && count >= 2 && mpContentType.startsWithAny("multipart/alternative", "multipart/related")) {
            found = MimeReply.getTextContent(true, false, multipartPart, count, partContentType, accountId, pc);
            if (!found) {
                found = MimeReply.getTextContent(false, false, multipartPart, count, partContentType, accountId, pc);
            }
        } else {
            found = MimeReply.getTextContent(false, !htmlPreferred && mpContentType.startsWithAny("multipart/alternative", "multipart/related"), multipartPart, count, partContentType, accountId, pc);
            if (!found) {
                found = MimeReply.getTextContent(false, false, multipartPart, count, partContentType, accountId, pc);
            }
        }
        for (int i = count - 1; i >= 0; --i) {
            MailPart part = multipartPart.getEnclosedMailPart(i);
            if ("attachment".equals(Strings.asciiLowerCase((String)part.getContentDisposition().getDisposition()))) continue;
            partContentType.setContentType(part.getContentType());
            if (partContentType.startsWith("message/rfc822")) {
                MailMessage enclosedMsg = (MailMessage)part.getContent();
                found |= MimeReply.generateReplyText(enclosedMsg, pc.retvalContentType, pc.strHelper, pc.ltz, pc.usm, pc.mailSession, pc.session, accountId, pc.replyTexts);
                continue;
            }
            if (!MimeProcessingUtility.fileNameEndsWith(".eml", part, partContentType)) continue;
            InputStream is = MimeMessageUtility.getStreamFromMailPart(part);
            try {
                MailMessage attachedMsg = MimeMessageConverter.convertMessage(is);
                found |= MimeReply.generateReplyText(attachedMsg, pc.retvalContentType, pc.strHelper, pc.ltz, pc.usm, pc.mailSession, pc.session, accountId, pc.replyTexts);
                continue;
            }
            finally {
                Streams.close((Closeable)is);
            }
        }
        return found;
    }

    private static boolean getTextContent(boolean preferHTML, boolean avoidHTML, MailPart multipartPart, int count, ContentType partContentType, int accountId, ParameterContainer pc) throws OXException, MessagingException, IOException {
        MailPart nextPart;
        String text;
        String charset;
        boolean first;
        MailPart part;
        int i;
        boolean found = false;
        if (preferHTML) {
            for (i = 0; !found && i < count; ++i) {
                part = multipartPart.getEnclosedMailPart(i);
                partContentType.setContentType(part.getContentType());
                if (partContentType.startsWith(TEXT_HTM) && MimeProcessingUtility.isInline(part, partContentType) && !MimeProcessingUtility.isSpecial(partContentType.getBaseType())) {
                    first = true;
                    if (pc.retvalContentType.getPrimaryType() == null) {
                        pc.retvalContentType.setContentType(partContentType);
                        charset = MessageUtility.checkCharset(part, partContentType);
                        pc.retvalContentType.setCharsetParameter(charset);
                        text = MimeProcessingUtility.readContent(part, charset);
                        pc.textBuilder.append(text);
                    } else {
                        first = false;
                        charset = MessageUtility.checkCharset(part, partContentType);
                        partContentType.setCharsetParameter(charset);
                        text = MimeProcessingUtility.handleInlineTextPart(part, partContentType, pc.usm.isDisplayHtmlInlineContent());
                        MimeProcessingUtility.appendRightVersion(pc.retvalContentType, partContentType, text, pc.textBuilder);
                    }
                    if (first && multipartPart.getContentType().startsWith("multipart/mixed")) {
                        for (int j = i + 1; j < count; ++j) {
                            nextPart = multipartPart.getEnclosedMailPart(j);
                            ContentType nextContentType = nextPart.getContentType();
                            if (nextContentType.startsWith(TEXT_HTM) && MimeProcessingUtility.isInline(nextPart, nextContentType) && !MimeProcessingUtility.isSpecial(nextContentType.getBaseType())) {
                                String charset2 = MessageUtility.checkCharset(nextPart, partContentType);
                                String text2 = MimeProcessingUtility.readContent(nextPart, charset2);
                                pc.textBuilder.append(text2);
                                continue;
                            }
                            if (!nextContentType.startsWith("image/") || !MimeProcessingUtility.isInline(nextPart, nextContentType)) continue;
                            String fileName = nextPart.getFileName();
                            InlineImageDataSource imgSource = InlineImageDataSource.getInstance();
                            if (null == fileName) {
                                String ext = MimeType2ExtMap.getFileExtension(nextContentType.getBaseType());
                                fileName = "image" + j + '.' + ext;
                            }
                            ImageLocation imageLocation = new ImageLocation.Builder(fileName).folder(MailFolderUtility.prepareFullname(accountId, pc.origMail.getFolder())).id(pc.origMail.getMailId()).build();
                            String imageURL = imgSource.generateUrl(imageLocation, pc.session);
                            String imgTag = "<img src=\"" + imageURL + "&scaleType=contain&width=800\" alt=\"\" style=\"display: block\" id=\"" + fileName + "\">";
                            pc.textBuilder.append(imgTag);
                        }
                        return true;
                    }
                    found = true;
                    continue;
                }
                if (!partContentType.startsWith(MULTIPART)) continue;
                found |= MimeReply.gatherAllTextContents(part, partContentType, accountId, pc);
            }
            if (found) {
                return true;
            }
        }
        found = false;
        for (i = 0; i < count; ++i) {
            part = multipartPart.getEnclosedMailPart(i);
            partContentType.setContentType(part.getContentType());
            if (!(!partContentType.startsWith(TEXT) || avoidHTML && partContentType.startsWith(TEXT_HTM) || !MimeProcessingUtility.isInline(part, partContentType) || MimeProcessingUtility.isSpecial(partContentType.getBaseType()))) {
                first = true;
                if (pc.retvalContentType.getPrimaryType() == null) {
                    String htmlContent;
                    String text3 = MimeProcessingUtility.handleInlineTextPart(part, partContentType, pc.usm.isDisplayHtmlInlineContent());
                    if (Strings.isEmpty((String)text3) && null != (htmlContent = MimeReply.getHtmlContent(multipartPart, count))) {
                        HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                        text3 = null == htmlService ? "" : htmlService.html2text(htmlContent, true);
                    }
                    pc.retvalContentType.setContentType(partContentType);
                    String charset3 = MessageUtility.checkCharset(part, partContentType);
                    pc.retvalContentType.setCharsetParameter(charset3);
                    pc.textBuilder.append(text3);
                } else {
                    first = false;
                    charset = MessageUtility.checkCharset(part, partContentType);
                    partContentType.setCharsetParameter(charset);
                    text = MimeProcessingUtility.handleInlineTextPart(part, partContentType, pc.usm.isDisplayHtmlInlineContent());
                    MimeProcessingUtility.appendRightVersion(pc.retvalContentType, partContentType, text, pc.textBuilder);
                }
                if (first && multipartPart.getContentType().startsWith("multipart/mixed")) {
                    for (int j = i + 1; j < count; ++j) {
                        nextPart = multipartPart.getEnclosedMailPart(j);
                        ContentType nextContentType = nextPart.getContentType();
                        if (!(!nextContentType.startsWith(TEXT) || avoidHTML && nextContentType.startsWith(TEXT_HTM) || !MimeProcessingUtility.isInline(nextPart, nextContentType) || MimeProcessingUtility.isSpecial(nextContentType.getBaseType()))) {
                            String text4 = MimeProcessingUtility.handleInlineTextPart(nextPart, nextContentType, pc.usm.isDisplayHtmlInlineContent());
                            pc.textBuilder.append(text4);
                            continue;
                        }
                        if (!nextContentType.startsWith(MULTIPART)) continue;
                        MimeReply.gatherAllTextContents(nextPart, nextContentType, accountId, pc);
                    }
                    return true;
                }
                found = true;
                continue;
            }
            if (!partContentType.startsWith(MULTIPART) || found && multipartPart.getContentType().startsWith("multipart/alternative")) continue;
            found |= MimeReply.gatherAllTextContents(part, partContentType, accountId, pc);
        }
        return found;
    }

    private static String getHtmlContent(MailPart multipartPart, int count) throws OXException, IOException {
        boolean found = false;
        for (int i = 0; !found && i < count; ++i) {
            MailPart part = multipartPart.getEnclosedMailPart(i);
            ContentType partContentType = part.getContentType();
            if (!partContentType.startsWith(TEXT_HTM) || !MimeProcessingUtility.isInline(part, partContentType) || MimeProcessingUtility.isSpecial(partContentType.getBaseType())) continue;
            String charset = MessageUtility.checkCharset(part, partContentType);
            return MimeProcessingUtility.readContent(part, charset);
        }
        return null;
    }

    private static String citeText(String textContent) {
        return PATTERN_TEXT_CITE.matcher(textContent).replaceAll("> ");
    }

    private static String citeHtml(String htmlContent) {
        Matcher m = PATTERN_HTML_START.matcher(htmlContent);
        MatcherReplacer mr = new MatcherReplacer(m, htmlContent);
        StringBuilder sb = new StringBuilder(htmlContent.length());
        if (m.find()) {
            mr.appendLiteralReplacement(sb, BLOCKQUOTE_START);
        } else {
            sb.append(BLOCKQUOTE_START);
        }
        mr.appendTail(sb);
        String s = sb.toString();
        m = PATTERN_HTML_END.matcher(s);
        mr.resetTo(m, s);
        sb.setLength(0);
        if (m.find()) {
            mr.appendLiteralReplacement(sb, BLOCKQUOTE_END);
            int matcherEnd = m.end();
            if (matcherEnd < s.length()) {
                String tail = s.substring(matcherEnd);
                if (!Strings.isEmpty((String)tail) && MimeReply.hasContent(tail)) {
                    sb.append(BLOCKQUOTE_START);
                    sb.append(tail);
                    sb.append(BLOCKQUOTE_END);
                } else {
                    mr.appendTail(sb);
                }
            } else {
                mr.appendTail(sb);
            }
        } else {
            mr.appendTail(sb);
            sb.append(BLOCKQUOTE_END);
        }
        return sb.toString();
    }

    private static boolean hasContent(String html) {
        return PATTERN_CONTENT.matcher(html).find();
    }

    private static final class ParameterContainer {
        final ContentType retvalContentType;
        final StringBuilder textBuilder;
        final StringHelper strHelper;
        final UserSettingMail usm;
        final javax.mail.Session mailSession;
        final Session session;
        final MailMessage origMail;
        final LocaleAndTimeZone ltz;
        final List<String> replyTexts;

        ParameterContainer(ContentType retvalContentType, StringBuilder textBuilder, StringHelper strHelper, UserSettingMail usm, javax.mail.Session mailSession, Session session, MailMessage origMail, LocaleAndTimeZone ltz, List<String> replyTexts) {
            this.origMail = origMail;
            this.session = session;
            this.retvalContentType = retvalContentType;
            this.textBuilder = textBuilder;
            this.strHelper = strHelper;
            this.usm = usm;
            this.mailSession = mailSession;
            this.ltz = ltz;
            this.replyTexts = replyTexts;
        }
    }
}

