/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.datasource;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class FileHolderDataSource
implements DataSource {
    private final ThresholdFileHolder fh;
    private final String contentType;

    public FileHolderDataSource(ThresholdFileHolder fh, String contentType) {
        this.fh = fh;
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.fh.getStream();
        }
        catch (OXException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(e);
        }
    }

    public String getName() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        ThresholdFileHolder tmp = this.fh;
        if (null != tmp) {
            try {
                tmp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

