/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.converters;

import com.openexchange.java.Streams;
import com.openexchange.mail.mime.MimeCleanUp;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedFileInputStream;

public class FileBackedMimeBodyPart
extends MimeBodyPart
implements MimeCleanUp {
    private File tempFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream in, File tempFile) throws IOException {
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(tempFile);
            int len = 8192;
            byte[] buf = new byte[len];
            while ((read = in.read(buf, 0, len)) > 0) {
                out.write(buf, 0, read);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            throw throwable;
        }
        Streams.close((Closeable)out);
    }

    public FileBackedMimeBodyPart(File tempFile) throws MessagingException, IOException {
        super((InputStream)new SharedFileInputStream(tempFile));
        this.tempFile = tempFile;
    }

    public FileBackedMimeBodyPart(SharedInputStream sharedIn) throws MessagingException {
        super((InputStream)sharedIn);
        this.tempFile = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cleanUp();
    }

    public File getTempFile() {
        return this.tempFile;
    }

    @Override
    public final synchronized void cleanUp() {
        File tempFile = this.tempFile;
        if (null != tempFile) {
            tempFile.delete();
            this.tempFile = null;
        }
    }
}

