/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.loginhandler;

import com.openexchange.dataretention.DataRetentionService;
import com.openexchange.dataretention.RetentionData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginResult;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.Date;

public final class MailLoginHandler
implements LoginHandlerService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLogin(LoginResult login) throws OXException {
        DataRetentionService retentionService = ServerServiceRegistry.getInstance().getService(DataRetentionService.class);
        Context ctx = login.getContext();
        Session session = login.getSession();
        if (null != retentionService && UserConfigurationStorage.getInstance().getUserConfiguration(session.getUserId(), ctx).hasWebMail()) {
            MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
            try {
                RetentionData retentionData = retentionService.newInstance();
                retentionData.setStartTime(new Date(System.currentTimeMillis()));
                mailAccess = MailAccess.getInstance(session);
                retentionData.setIdentifier(mailAccess.getMailConfig().getLogin());
                retentionData.setIPAddress(session.getLocalIp());
                retentionData.setLogin(session.getLogin());
                retentionService.storeOnAccess(retentionData);
            }
            finally {
                MailAccess.closeInstance(mailAccess);
            }
        }
    }

    @Override
    public void handleLogout(LoginResult logout) throws OXException {
        Session session = logout.getSession();
        MailAccess.getMailAccessCache().clearUserEntries(session);
    }
}

