/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.DefaultFileStorageGuestPermission;
import com.openexchange.file.storage.DefaultFileStoragePermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.groupware.notify.hostname.internal.HostDataImpl;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.json.parser.DefaultAttachmentHandler;
import com.openexchange.mail.json.parser.LinkedAttachment;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareLink;
import com.openexchange.share.ShareService;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.ShareTargetPath;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.ShareRecipient;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tx.TransactionAware;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.mail.internet.InternetAddress;

public final class ShareLinkAttachmentHandler
extends DefaultAttachmentHandler
implements TransactionAware {
    private final IDBasedFolderAccess folderAccess;
    private final IDBasedFileAccess fileAccess;

    public ShareLinkAttachmentHandler(Session session, TransportProvider transportProvider, String protocol, String hostName) throws OXException {
        super(session, transportProvider, protocol, hostName);
        this.fileAccess = ServerServiceRegistry.getServize(IDBasedFileAccessFactory.class).createAccess(session);
        this.folderAccess = ServerServiceRegistry.getServize(IDBasedFolderAccessFactory.class).createAccess(session);
    }

    public void startTransaction() throws OXException {
        this.fileAccess.startTransaction();
        this.folderAccess.startTransaction();
    }

    public void commit() throws OXException {
        this.fileAccess.commit();
        this.folderAccess.commit();
    }

    public void rollback() throws OXException {
        this.fileAccess.rollback();
        this.folderAccess.rollback();
    }

    public void finish() throws OXException {
        this.fileAccess.finish();
        this.folderAccess.finish();
    }

    @Override
    protected List<LinkedAttachment> publishAttachments(ComposedMailMessage source, List<OXException> warnings) throws OXException {
        String folderID = this.createFolder(source, this.getPassword(), this.getExpiratioDate());
        List<String> savedAttachments = this.saveAttachments(folderID, this.attachments);
        ShareTarget folderTarget = new ShareTarget(FileStorageContentType.getInstance().getModule(), folderID);
        ShareLink folderLink = ServerServiceRegistry.getServize(ShareService.class).getLink(this.session, folderTarget);
        if (ShareLinkAttachmentHandler.useDownloadLinks()) {
            ArrayList<LinkedAttachment> linkedAttachments = new ArrayList<LinkedAttachment>(this.attachments.size());
            for (int i = 0; i < this.attachments.size(); ++i) {
                ShareTarget fileTarget = new ShareTarget(folderTarget.getModule(), folderTarget.getFolder(), savedAttachments.get(i));
                linkedAttachments.add(new LinkedShareAttachment(((MailPart)this.attachments.get(i)).getFileName(), folderLink.getGuest(), this.getHostData(), fileTarget, "dl=1"));
            }
            return linkedAttachments;
        }
        LinkedShareAttachment linkedAttachment = new LinkedShareAttachment(null, folderLink.getGuest(), this.getHostData(), folderTarget, null);
        return Collections.singletonList(linkedAttachment);
    }

    private String createFolder(ComposedMailMessage mail, String password, Date expiry) throws OXException {
        String parentFolderID;
        String paramterName = MailSessionParameterNames.getParamPublishingInfostoreFolderID();
        Object parameter = this.session.getParameter(paramterName);
        if (null != parameter) {
            parentFolderID = String.valueOf(parameter);
        } else {
            parentFolderID = this.discoverEMailAttachmentsFolderID();
            this.session.setParameter(paramterName, (Object)parentFolderID);
        }
        DefaultFileStorageFolder folder = this.prepareFolder(mail, parentFolderID, password, expiry);
        int counter = 1;
        while (true) {
            try {
                return this.folderAccess.createFolder((FileStorageFolder)folder);
            }
            catch (OXException e) {
                if (e.equalsCode(1014, "FLD") || e.equalsCode(12, "FLD")) {
                    folder.setName(FileStorageUtility.enhance((String)folder.getName(), (int)counter++));
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private String discoverEMailAttachmentsFolderID() throws OXException {
        FileStorageAccount defaultAccount;
        FolderID placeholderID;
        FileStorageFolder personalFolder;
        FileStorageFolder[] subfolders;
        String name = TransportProperties.getInstance().getPublishingInfostoreFolder();
        if ("i18n-defined".equals(name)) {
            name = "E-Mail attachments";
        }
        if (null != (subfolders = this.folderAccess.getSubfolders((personalFolder = this.folderAccess.getPersonalFolder((placeholderID = new FolderID((defaultAccount = this.getDefaultAccount()).getFileStorageService().getId(), defaultAccount.getId(), "0")).toString())).getId(), true)) && 0 < subfolders.length) {
            for (FileStorageFolder subfolder : subfolders) {
                if (!name.equals(subfolder.getName())) continue;
                if (null != subfolder.getOwnPermission() && 8 > subfolder.getOwnPermission().getFolderPermission()) {
                    throw FileStorageExceptionCodes.NO_CREATE_ACCESS.create(new Object[]{subfolder.getName()});
                }
                return subfolder.getId();
            }
        }
        DefaultFileStorageFolder folder = new DefaultFileStorageFolder();
        folder.setName(name);
        DefaultFileStoragePermission permission = DefaultFileStoragePermission.newInstance();
        permission.setEntity(this.session.getUserId());
        folder.setPermissions(Collections.singletonList(permission));
        folder.setParentId(personalFolder.getId());
        return this.folderAccess.createFolder((FileStorageFolder)folder);
    }

    private List<String> saveAttachments(String folderID, List<MailPart> attachments2) throws OXException {
        ArrayList<String> createdFiles = new ArrayList<String>(attachments2.size());
        for (MailPart attachment : attachments2) {
            createdFiles.add(this.saveAttachment(this.fileAccess, folderID, attachment));
        }
        return createdFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveAttachment(IDBasedFileAccess fileAccess, String folderID, MailPart attachment) throws OXException {
        File file = this.prepareMetadata(attachment, folderID);
        InputStream inputStream = null;
        try {
            inputStream = attachment.getInputStream();
            String string = fileAccess.saveDocument(file, inputStream, -1L);
            return string;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    private DefaultFileStorageFolder prepareFolder(ComposedMailMessage mail, String parent, String password, Date expiry) {
        DefaultFileStorageFolder folder = new DefaultFileStorageFolder();
        folder.setParentId(parent);
        folder.setName(mail.getSubject());
        ArrayList<Object> permissions = new ArrayList<Object>(2);
        DefaultFileStoragePermission userPermission = DefaultFileStoragePermission.newInstance();
        userPermission.setMaxPermissions();
        userPermission.setEntity(this.session.getUserId());
        permissions.add(userPermission);
        DefaultFileStorageGuestPermission guestPermission = new DefaultFileStorageGuestPermission(ShareLinkAttachmentHandler.prepareRecipient(password, expiry));
        guestPermission.setAllPermissions(2, 4, 0, 0);
        permissions.add(guestPermission);
        folder.setPermissions(permissions);
        return folder;
    }

    private File prepareMetadata(MailPart attachment, String folderID) {
        String name = attachment.getFileName();
        if (Strings.isEmpty((String)name)) {
            name = "attachment";
        }
        DefaultFile file = new DefaultFile();
        file.setId(FileStorageFileAccess.NEW);
        file.setFolderId(folderID);
        file.setFileName(name);
        file.setFileMIMEType(attachment.getContentType().getBaseType());
        file.setTitle(name);
        file.setFileSize(attachment.getSize());
        return file;
    }

    private static ShareRecipient prepareRecipient(String password, Date expiryDate) {
        int bits = Permissions.createPermissionBits(2, 4, 0, 0, false);
        return new AnonymousRecipient(bits, password, expiryDate);
    }

    private FileStorageAccount getDefaultAccount() throws OXException {
        FileStorageAccountManagerLookupService lookupService = ServerServiceRegistry.getInstance().getService(FileStorageAccountManagerLookupService.class);
        if (null == lookupService) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{FileStorageAccountManagerLookupService.class.getName()});
        }
        FileStorageAccountManager accountManager = lookupService.getAccountManagerFor("com.openexchange.infostore");
        return accountManager.getAccount("infostore", this.session);
    }

    private HostData getHostData() {
        String prefix = ServerServiceRegistry.getServize(DispatcherPrefixService.class).getPrefix();
        String route = Tools.extractRoute(null);
        return new HostDataImpl("https".equalsIgnoreCase(this.protocol), this.hostName, -1, null, route, prefix);
    }

    private static boolean useDownloadLinks() {
        return true;
    }

    private static boolean isEncodeRecipients() {
        return true;
    }

    private static final class LinkedShareAttachment
    implements LinkedAttachment {
        private final GuestInfo guest;
        private final ShareTarget sourceTarget;
        private final HostData hostData;
        private final String name;
        private final String queryString;

        public LinkedShareAttachment(String name, GuestInfo guest, HostData hostData, ShareTarget sourceTarget, String queryString) {
            this.name = name;
            this.guest = guest;
            this.hostData = hostData;
            this.sourceTarget = sourceTarget;
            this.queryString = queryString;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLink(InternetAddress recipient) {
            ShareTargetPath targetPath;
            if (ShareLinkAttachmentHandler.isEncodeRecipients()) {
                HashMap<String, String> additionals = new HashMap<String, String>(1);
                additionals.put("recipient", recipient.getAddress());
                targetPath = new ShareTargetPath(this.sourceTarget.getModule(), this.sourceTarget.getFolder(), this.sourceTarget.getItem(), additionals);
            } else {
                targetPath = new ShareTargetPath(this.sourceTarget.getModule(), this.sourceTarget.getFolder(), this.sourceTarget.getItem());
            }
            String url = this.guest.generateLink(this.hostData, targetPath);
            if (Strings.isNotEmpty((String)this.queryString)) {
                url = url + '?' + this.queryString;
            }
            return url;
        }
    }
}

