/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share.settings;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.jslob.ConfigTreeEquivalent;
import com.openexchange.mail.json.compose.share.ShareComposeHandler;
import com.openexchange.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShareComposeSetting<V>
implements PreferencesItemService,
ConfigTreeEquivalent {
    static final Logger LOG = LoggerFactory.getLogger(AbstractShareComposeSetting.class);
    protected final String nameInPath;
    protected final ShareComposeHandler shareComposeHandler;

    protected AbstractShareComposeSetting(String nameInPath, ShareComposeHandler shareComposeHandler) {
        this.nameInPath = nameInPath;
        this.shareComposeHandler = shareComposeHandler;
    }

    protected abstract V getSettingValue(Session var1, Context var2, User var3, UserConfiguration var4) throws OXException;

    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "compose", "shareAttachments", this.nameInPath};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                Object value = AbstractShareComposeSetting.this.getSettingValue(session, ctx, user, userConfig);
                setting.setSingleValue(value);
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return true;
            }
        };
    }

    public String getConfigTreePath() {
        return "modules/mail/compose/shareAttachments/" + this.nameInPath;
    }

    public String getJslobPath() {
        return "io.ox/mail//compose/shareAttachments/" + this.nameInPath;
    }
}

