/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share.osgi;

import com.openexchange.capabilities.CapabilityChecker;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.capabilities.CapabilitySet;
import com.openexchange.capabilities.DependentCapabilityChecker;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.i18n.TranslatorFactory;
import com.openexchange.jslob.ConfigTreeEquivalent;
import com.openexchange.mail.json.compose.ComposeHandler;
import com.openexchange.mail.json.compose.Utilities;
import com.openexchange.mail.json.compose.share.DefaultAttachmentStorage;
import com.openexchange.mail.json.compose.share.MessageGenerators;
import com.openexchange.mail.json.compose.share.ShareComposeHandler;
import com.openexchange.mail.json.compose.share.internal.AttachmentStorageRegistry;
import com.openexchange.mail.json.compose.share.internal.AttachmentStorageRegistryImpl;
import com.openexchange.mail.json.compose.share.internal.EnabledCheckerRegistry;
import com.openexchange.mail.json.compose.share.internal.EnabledCheckerRegistryImpl;
import com.openexchange.mail.json.compose.share.internal.MessageGeneratorRegistry;
import com.openexchange.mail.json.compose.share.internal.MessageGeneratorRegistryImpl;
import com.openexchange.mail.json.compose.share.internal.ShareLinkGeneratorRegistry;
import com.openexchange.mail.json.compose.share.internal.ShareLinkGeneratorRegistryImpl;
import com.openexchange.mail.json.compose.share.settings.AbstractShareComposeSetting;
import com.openexchange.mail.json.compose.share.settings.EnabledShareComposeSetting;
import com.openexchange.mail.json.compose.share.settings.ForceAutoDeleteShareComposeSetting;
import com.openexchange.mail.json.compose.share.settings.NameShareComposeSetting;
import com.openexchange.mail.json.compose.share.settings.RequiredExpirationShareComposeSetting;
import com.openexchange.mail.json.compose.share.settings.ThresholdShareComposeSetting;
import com.openexchange.mail.json.compose.share.spi.AttachmentStorage;
import com.openexchange.mail.json.compose.share.spi.EnabledChecker;
import com.openexchange.mail.json.compose.share.spi.MessageGenerator;
import com.openexchange.mail.json.compose.share.spi.ShareLinkGenerator;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.osgi.RankingAwareNearRegistryServiceTracker;
import com.openexchange.osgi.ServiceListing;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.templating.TemplateService;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ShareComposeActivator
extends HousekeepingActivator {
    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class, TimerService.class};
    }

    protected void startBundle() throws Exception {
        RankingAwareNearRegistryServiceTracker shareLinkGeneratorTracker = new RankingAwareNearRegistryServiceTracker(this.context, ShareLinkGenerator.class);
        this.rememberTracker((ServiceTracker)shareLinkGeneratorTracker);
        RankingAwareNearRegistryServiceTracker messageGeneratorTracker = new RankingAwareNearRegistryServiceTracker(this.context, MessageGenerator.class);
        this.rememberTracker((ServiceTracker)messageGeneratorTracker);
        RankingAwareNearRegistryServiceTracker attachmentStorageTracker = new RankingAwareNearRegistryServiceTracker(this.context, AttachmentStorage.class);
        this.rememberTracker((ServiceTracker)attachmentStorageTracker);
        RankingAwareNearRegistryServiceTracker enabledCheckerTracker = new RankingAwareNearRegistryServiceTracker(this.context, EnabledChecker.class);
        this.rememberTracker((ServiceTracker)enabledCheckerTracker);
        final BundleContext context = this.context;
        this.track(CapabilityService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<CapabilityService, CapabilityService>(){
            private volatile ServiceRegistration<CapabilityChecker> serviceRegistration;

            public CapabilityService addingService(ServiceReference<CapabilityService> reference) {
                CapabilityService service = (CapabilityService)context.getService(reference);
                String sCapability = "share_mail_attachments";
                Hashtable<String, String> properties = new Hashtable<String, String>(2);
                ((Dictionary)properties).put("capabilities", "share_mail_attachments");
                DependentCapabilityChecker capabilityChecker = new DependentCapabilityChecker(){

                    public boolean isEnabled(String capability, Session ses, CapabilitySet capabilitySet) throws OXException {
                        if ("share_mail_attachments".equals(capability)) {
                            ServerSession session = ServerSessionAdapter.valueOf(ses);
                            if (session.isAnonymous() || !session.getUserPermissionBits().hasWebMail()) {
                                return false;
                            }
                            if (!Utilities.getBoolFromProperty("com.openexchange.mail.compose.share.enabled", true, session)) {
                                return false;
                            }
                            return Utilities.hasCapabilities(capabilitySet, "drive", "share_links");
                        }
                        return true;
                    }
                };
                this.serviceRegistration = context.registerService(CapabilityChecker.class, (Object)capabilityChecker, properties);
                service.declareCapability("share_mail_attachments");
                return service;
            }

            public void modifiedService(ServiceReference<CapabilityService> reference, CapabilityService service) {
            }

            public void removedService(ServiceReference<CapabilityService> reference, CapabilityService service) {
                ServiceRegistration<CapabilityChecker> serviceRegistration = this.serviceRegistration;
                if (null != serviceRegistration) {
                    this.serviceRegistration = null;
                    serviceRegistration.unregister();
                }
                context.ungetService(reference);
            }
        });
        Object tracker = new ServiceTrackerCustomizer<TranslatorFactory, TranslatorFactory>(){

            public void removedService(ServiceReference<TranslatorFactory> reference, TranslatorFactory factory) {
                MessageGenerators.setTranslatorFactory(null);
                context.ungetService(reference);
            }

            public void modifiedService(ServiceReference<TranslatorFactory> reference, TranslatorFactory factory) {
            }

            public TranslatorFactory addingService(ServiceReference<TranslatorFactory> reference) {
                TranslatorFactory factory = (TranslatorFactory)context.getService(reference);
                MessageGenerators.setTranslatorFactory(factory);
                return factory;
            }
        };
        this.track(TranslatorFactory.class, (ServiceTrackerCustomizer)tracker);
        tracker = new ServiceTrackerCustomizer<TemplateService, TemplateService>(){

            public void removedService(ServiceReference<TemplateService> reference, TemplateService templateService) {
                MessageGenerators.setTemplateService(null);
                context.ungetService(reference);
            }

            public void modifiedService(ServiceReference<TemplateService> reference, TemplateService templateService) {
            }

            public TemplateService addingService(ServiceReference<TemplateService> reference) {
                TemplateService templateService = (TemplateService)context.getService(reference);
                MessageGenerators.setTemplateService(templateService);
                return templateService;
            }
        };
        this.track(TemplateService.class, (ServiceTrackerCustomizer)tracker);
        this.openTrackers();
        DefaultAttachmentStorage.startInstance((ConfigurationService)this.getService(ConfigurationService.class), (TimerService)this.getService(TimerService.class));
        ShareLinkGeneratorRegistryImpl shareLinkGeneratorRegistry = new ShareLinkGeneratorRegistryImpl((ServiceListing<ShareLinkGenerator>)shareLinkGeneratorTracker);
        this.registerService(ShareLinkGeneratorRegistry.class, shareLinkGeneratorRegistry);
        MessageGeneratorRegistryImpl messageGeneratorRegistry = new MessageGeneratorRegistryImpl((ServiceListing<MessageGenerator>)messageGeneratorTracker);
        this.registerService(MessageGeneratorRegistry.class, messageGeneratorRegistry);
        AttachmentStorageRegistryImpl attachmentStorageRegistry = new AttachmentStorageRegistryImpl((ServiceListing<AttachmentStorage>)attachmentStorageTracker);
        this.registerService(AttachmentStorageRegistry.class, attachmentStorageRegistry);
        EnabledCheckerRegistryImpl enabledCheckerRegistry = new EnabledCheckerRegistryImpl((ServiceListing<EnabledChecker>)enabledCheckerTracker);
        this.registerService(EnabledCheckerRegistry.class, enabledCheckerRegistry);
        ShareComposeHandler handler = new ShareComposeHandler();
        this.registerService(ComposeHandler.class, handler);
        this.registerSetting(new EnabledShareComposeSetting(handler));
        this.registerSetting(new NameShareComposeSetting(handler));
        this.registerSetting(new RequiredExpirationShareComposeSetting(handler));
        this.registerSetting(new ForceAutoDeleteShareComposeSetting(handler));
        this.registerSetting(new ThresholdShareComposeSetting(handler));
    }

    private <V> void registerSetting(AbstractShareComposeSetting<V> setting) {
        this.registerService(PreferencesItemService.class, setting, null);
        this.registerService(ConfigTreeEquivalent.class, setting, null);
    }

    protected void stopBundle() throws Exception {
        ServerServiceRegistry.getInstance().removeService(AttachmentStorageRegistry.class);
        ServerServiceRegistry.getInstance().removeService(MessageGeneratorRegistry.class);
        ServerServiceRegistry.getInstance().removeService(ShareLinkGeneratorRegistry.class);
        DefaultAttachmentStorage.shutDown();
        super.stopBundle();
    }
}

