/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share;

import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.mail.json.compose.share.Item;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.MailPasswordUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareReference {
    private static final Key KEY = MailPasswordUtil.generateSecretKey(Charsets.toAsciiBytes((String)"jsonkeyp"));
    private final int contextId;
    private final int userId;
    private final Item folder;
    private final List<Item> items;
    private final String shareToken;
    private final Date expiration;
    private final String password;
    private static final int USED = "X-Open-Xchange-Share-Reference".length() + 2;

    public static ShareReference parseFromReferenceString(String referenceString) {
        if (Strings.isEmpty((String)referenceString)) {
            return null;
        }
        try {
            JSONObject jReference = new JSONObject(MailPasswordUtil.decrypt(referenceString, KEY));
            JSONArray jItems = jReference.getJSONArray("items");
            int length = jItems.length();
            ArrayList<Item> items = new ArrayList<Item>(length);
            for (int i = 0; i < length; ++i) {
                items.add(ShareReference.parseItemFrom(jItems.getJSONObject(i)));
            }
            Date expiration = null;
            if (jReference.hasAndNotNull("expiration")) {
                expiration = new Date(jReference.getLong("expiration"));
            }
            return new ShareReference(jReference.getString("shareToken"), items, ShareReference.parseItemFrom(jReference.getJSONObject("folder")), expiration, jReference.optString("password", null), jReference.getInt("userId"), jReference.getInt("contextId"));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid reference string", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String generateStringForMime(ShareReference shareReference) {
        if (null == shareReference) {
            return null;
        }
        String str = shareReference.generateReferenceString();
        String splitted = ShareReference.split4Mime(str);
        String folded = MimeMessageUtility.fold(USED, splitted);
        return folded;
    }

    public static ShareReference parseFromMime(String fromMime) {
        if (null == fromMime) {
            return null;
        }
        String unfolded = MimeMessageUtility.unfold(fromMime);
        String unsplitted = ShareReference.unsplit(unfolded);
        return ShareReference.parseFromReferenceString(unsplitted);
    }

    private static Item parseItemFrom(JSONObject jItem) throws JSONException {
        if (null == jItem) {
            return null;
        }
        return new Item(jItem.getString("id"), jItem.getString("name"));
    }

    ShareReference(String shareToken, List<Item> items, Item folder, Date expiration, String password, int userId, int contextId) {
        this.shareToken = shareToken;
        this.items = items;
        this.folder = folder;
        this.expiration = expiration;
        this.password = password;
        this.userId = userId;
        this.contextId = contextId;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getUserId() {
        return this.userId;
    }

    public Item getFolder() {
        return this.folder;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public String getShareToken() {
        return this.shareToken;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public String getPassword() {
        return this.password;
    }

    public String generateReferenceString() {
        try {
            JSONObject jReference = new JSONObject(8);
            jReference.put("shareToken", (Object)this.shareToken);
            jReference.put("contextId", this.contextId);
            jReference.put("userId", this.userId);
            jReference.put("folder", (Object)new JSONObject(2).put("id", (Object)this.folder.getId()).put("name", (Object)this.folder.getName()));
            JSONArray jItems = new JSONArray(this.items.size());
            for (Item item : this.items) {
                jItems.put((Object)new JSONObject(2).put("id", (Object)item.getId()).put("name", (Object)item.getName()));
            }
            jReference.put("items", (Object)jItems);
            if (null != this.expiration) {
                jReference.put("expiration", this.expiration.getTime());
            }
            if (null != this.password) {
                jReference.put("password", (Object)this.password);
            }
            return MailPasswordUtil.encrypt(jReference.toString(), KEY);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[contextId=").append(this.contextId).append(", userId=").append(this.userId);
        if (this.folder != null) {
            sb.append(", folder=").append(this.folder);
        }
        if (this.items != null) {
            sb.append(", items=").append(this.items);
        }
        if (this.shareToken != null) {
            sb.append(", shareToken=").append(this.shareToken);
        }
        if (this.expiration != null) {
            sb.append(", expiration=").append(this.expiration);
        }
        if (this.password != null) {
            sb.append(", password=").append(this.password);
        }
        sb.append(']');
        return sb.toString();
    }

    private static String compress(String str) throws IOException {
        ByteArrayOutputStream byteSink = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(byteSink);
        gzip.write(str.getBytes(Charsets.UTF_8));
        gzip.flush();
        gzip.close();
        return Base64.encodeBase64String((byte[])byteSink.toByteArray());
    }

    private static String decompress(String str) throws UnsupportedEncodingException, IOException {
        int read;
        byte[] data = Base64.decodeBase64((String)str);
        InputStreamReader reader = new InputStreamReader((InputStream)new GZIPInputStream(new ByteArrayInputStream(data)), "UTF-8");
        StringBuilder outStr = new StringBuilder(str.length());
        char[] cbuf = new char[2048];
        while ((read = ((Reader)reader).read(cbuf, 0, 2048)) > 0) {
            outStr.append(cbuf, 0, read);
        }
        return outStr.toString();
    }

    private static String unsplit(String s) {
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        int k = length;
        while (k-- > 0) {
            char c = s.charAt(i);
            if (' ' != c) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String split4Mime(String s) {
        int chunkSize = 76;
        int length = s.length();
        if (length <= chunkSize) {
            return s;
        }
        StringBuilder sb = new StringBuilder(length + 16);
        boolean first = true;
        int i = 0;
        while (i < length) {
            if (first) {
                first = false;
                int cs = chunkSize - USED;
                sb.append(s.substring(i, Math.min(length, i + cs)));
                i += cs;
                continue;
            }
            sb.append(' ');
            sb.append(s.substring(i, Math.min(length, i + chunkSize)));
            i += chunkSize;
        }
        return sb.toString();
    }

    public static class Builder {
        private final int contextId;
        private final int userId;
        private Item folder;
        private List<Item> items;
        private String shareToken;
        private Date expiration;
        private String password;

        public Builder(int userId, int contextId) {
            this.userId = userId;
            this.contextId = contextId;
        }

        public Builder folder(Item folder) {
            this.folder = folder;
            return this;
        }

        public Builder items(List<Item> items) {
            this.items = items;
            return this;
        }

        public Builder shareToken(String shareToken) {
            this.shareToken = shareToken;
            return this;
        }

        public Builder expiration(Date expiration) {
            this.expiration = expiration;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public ShareReference build() {
            return new ShareReference(this.shareToken, this.items, this.folder, this.expiration, this.password, this.userId, this.contextId);
        }
    }
}

