/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.ISO8601Utils;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.DelegatingComposedMailMessage;
import com.openexchange.mail.json.compose.AbstractComposeHandler;
import com.openexchange.mail.json.compose.ComposeDraftResult;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.mail.json.compose.ComposeTransportResult;
import com.openexchange.mail.json.compose.DefaultComposeDraftResult;
import com.openexchange.mail.json.compose.DefaultComposeTransportResult;
import com.openexchange.mail.json.compose.Utilities;
import com.openexchange.mail.json.compose.share.Recipient;
import com.openexchange.mail.json.compose.share.ShareComposeLink;
import com.openexchange.mail.json.compose.share.ShareComposeMessageInfo;
import com.openexchange.mail.json.compose.share.ShareDraftComposeContext;
import com.openexchange.mail.json.compose.share.ShareReference;
import com.openexchange.mail.json.compose.share.ShareTransportComposeContext;
import com.openexchange.mail.json.compose.share.StoredAttachmentsControl;
import com.openexchange.mail.json.compose.share.internal.AttachmentStorageRegistry;
import com.openexchange.mail.json.compose.share.internal.EnabledCheckerRegistry;
import com.openexchange.mail.json.compose.share.internal.MessageGeneratorRegistry;
import com.openexchange.mail.json.compose.share.internal.ShareComposeLinkGenerator;
import com.openexchange.mail.json.compose.share.spi.AttachmentStorage;
import com.openexchange.mail.json.compose.share.spi.EnabledChecker;
import com.openexchange.mail.json.compose.share.spi.MessageGenerator;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareLink;
import com.openexchange.share.ShareService;
import com.openexchange.share.ShareTarget;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;
import org.json.JSONObject;

public class ShareComposeHandler
extends AbstractComposeHandler<ShareTransportComposeContext, ShareDraftComposeContext> {
    private JSONObject optShareAttachmentOptions(ComposeRequest composeRequest) {
        return composeRequest.getJsonMail().optJSONObject("share_attachments");
    }

    private boolean isCreateShare(ComposeRequest composeRequest) {
        JSONObject jShareAttachmentOptions = this.optShareAttachmentOptions(composeRequest);
        return null != jShareAttachmentOptions && jShareAttachmentOptions.optBoolean("enable", false);
    }

    private boolean isAutoDelete(ComposeRequest request) {
        JSONObject jShareAttachmentOptions = this.optShareAttachmentOptions(request);
        return null != jShareAttachmentOptions && jShareAttachmentOptions.optBoolean("autodelete", false);
    }

    private String getPassword(ComposeRequest request) {
        JSONObject jShareAttachmentOptions = this.optShareAttachmentOptions(request);
        return null == jShareAttachmentOptions ? null : jShareAttachmentOptions.optString("password", null);
    }

    protected Date getExpirationDate(ComposeRequest request) throws OXException {
        JSONObject jShareAttachmentOptions = this.optShareAttachmentOptions(request);
        if (null == jShareAttachmentOptions) {
            return null;
        }
        long millis = jShareAttachmentOptions.optLong("expiry_date");
        if (millis > 0L) {
            int offset = TimeZoneUtils.getTimeZone(request.getSession().getUser().getTimeZone()).getOffset(millis);
            return new Date(millis - (long)offset);
        }
        String sDate = jShareAttachmentOptions.optString("expiry_date");
        if (Strings.isEmpty((String)sDate)) {
            return null;
        }
        try {
            return ISO8601Utils.parse((String)sDate);
        }
        catch (IllegalArgumentException iso8601ParsingFailed) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(iso8601ParsingFailed, "expiry_date", sDate);
        }
    }

    public boolean isEnabled(Session session) throws OXException {
        if (!Utilities.getBoolFromProperty("com.openexchange.mail.compose.share.enabled", true, session)) {
            return false;
        }
        EnabledCheckerRegistry checkerRegistry = ServerServiceRegistry.getServize(EnabledCheckerRegistry.class);
        EnabledChecker checker = checkerRegistry.getEnabledCheckerFor(session);
        return checker.isEnabled(session);
    }

    @Override
    public String getId() {
        return "share";
    }

    @Override
    public boolean applicableFor(ComposeRequest composeRequest) throws OXException {
        if (!this.isCreateShare(composeRequest)) {
            return false;
        }
        ServerSession session = composeRequest.getSession();
        boolean applicable = this.isEnabled(session);
        if (!applicable) {
            throw MailExceptionCode.SHARING_NOT_POSSIBLE.create(Autoboxing.I((int)session.getUserId()), Autoboxing.I((int)session.getContextId()));
        }
        return applicable;
    }

    @Override
    protected ShareDraftComposeContext createDraftComposeContext(ComposeRequest composeRequest) throws OXException {
        return new ShareDraftComposeContext(composeRequest);
    }

    @Override
    protected ShareTransportComposeContext createTransportComposeContext(ComposeRequest composeRequest) throws OXException {
        return new ShareTransportComposeContext(composeRequest);
    }

    @Override
    protected ComposeDraftResult doCreateDraftResult(ComposeRequest composeRequest, ShareDraftComposeContext context) throws OXException {
        ComposedMailMessage composeMessage = this.createRegularComposeMessage(context);
        return new DefaultComposeDraftResult(composeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ComposeTransportResult doCreateTransportResult(ComposeRequest composeRequest, ShareTransportComposeContext context) throws OXException {
        if (!context.hasAnyPart()) {
            ComposedMailMessage composeMessage = this.createRegularComposeMessage(context);
            DelegatingComposedMailMessage transportMessage = new DelegatingComposedMailMessage(composeMessage);
            transportMessage.setAppendToSentFolder(false);
            return new DefaultComposeTransportResult(Collections.singletonList(transportMessage), composeMessage);
        }
        ServerSession session = composeRequest.getSession();
        ComposedMailMessage source = context.getSourceMessage();
        HashSet<InternetAddress> addresses = new HashSet<InternetAddress>();
        addresses.addAll(Arrays.asList(source.getTo()));
        addresses.addAll(Arrays.asList(source.getCc()));
        addresses.addAll(Arrays.asList(source.getBcc()));
        UserService userService = ServerServiceRegistry.getServize(UserService.class);
        if (null == userService) {
            throw ServiceExceptionCode.absentService(UserService.class);
        }
        Context ctx = composeRequest.getContext();
        LinkedHashSet<Recipient> recipients = new LinkedHashSet<Recipient>(addresses.size());
        for (InternetAddress address : addresses) {
            User user = this.resolveToUser(address, ctx, userService);
            String personal = address.getPersonal();
            String sAddress = address.getAddress();
            recipients.add(null == user ? Recipient.createExternalRecipient(personal, sAddress) : Recipient.createInternalRecipient(personal, sAddress, user));
        }
        String password = this.getPassword(composeRequest);
        Date expirationDate = this.getExpirationDate(composeRequest);
        if (null == expirationDate && Utilities.getBoolFromProperty("com.openexchange.mail.compose.share.requiredExpiration", false, session)) {
            throw MailExceptionCode.EXPIRATION_DATE_MISSING.create(Autoboxing.I((int)session.getUserId()), Autoboxing.I((int)session.getContextId()));
        }
        boolean autoDelete = null == expirationDate ? false : Utilities.getBoolFromProperty("com.openexchange.mail.compose.share.forceAutoDelete", false, session) || this.isAutoDelete(composeRequest);
        AttachmentStorageRegistry storageRegistry = ServerServiceRegistry.getServize(AttachmentStorageRegistry.class);
        if (null == storageRegistry) {
            throw ServiceExceptionCode.absentService(AttachmentStorageRegistry.class);
        }
        AttachmentStorage attachmentStorage = storageRegistry.getAttachmentStorageFor(composeRequest);
        StoredAttachmentsControl attachmentsControl = null;
        boolean rollback = true;
        try {
            attachmentsControl = attachmentStorage.storeAttachments(source, password, expirationDate, autoDelete, context);
            ShareTarget folderTarget = attachmentsControl.getFolderTarget();
            ShareService shareService = ServerServiceRegistry.getServize(ShareService.class);
            if (null == shareService) {
                throw ServiceExceptionCode.absentService(ShareService.class);
            }
            ShareLink folderLink = shareService.getLink((Session)session, folderTarget);
            String shareToken = folderLink.getGuest().getBaseToken();
            ShareReference shareReference = new ShareReference.Builder(session.getUserId(), session.getContextId()).expiration(expirationDate).password(password).folder(attachmentsControl.getFolder()).items(attachmentsControl.getAttachments()).shareToken(shareToken).build();
            LinkedHashMap<ShareComposeLink, LinkedHashSet<Recipient>> links = new LinkedHashMap<ShareComposeLink, LinkedHashSet<Recipient>>(recipients.size());
            GuestInfo guest = folderLink.getGuest();
            for (Recipient recipient : recipients) {
                ShareComposeLink linkedAttachment = ShareComposeLinkGenerator.getInstance().createShareLink(recipient, folderTarget, guest, null, composeRequest);
                LinkedHashSet<Recipient> associatedRecipients = (LinkedHashSet<Recipient>)links.get(linkedAttachment);
                if (null == associatedRecipients) {
                    associatedRecipients = new LinkedHashSet<Recipient>(recipients.size());
                    links.put(linkedAttachment, associatedRecipients);
                }
                associatedRecipients.add(recipient);
            }
            ShareComposeLink personalLink = ShareComposeLinkGenerator.getInstance().createPersonalShareLink(folderTarget, null, composeRequest);
            LinkedList<ComposedMailMessage> transportMessages = new LinkedList<ComposedMailMessage>();
            MessageGeneratorRegistry generatorRegistry = ServerServiceRegistry.getServize(MessageGeneratorRegistry.class);
            if (null == generatorRegistry) {
                throw ServiceExceptionCode.absentService(MessageGeneratorRegistry.class);
            }
            MessageGenerator messageGenerator = generatorRegistry.getMessageGeneratorFor(composeRequest);
            for (Map.Entry entry : links.entrySet()) {
                ShareComposeMessageInfo messageInfo = new ShareComposeMessageInfo((ShareComposeLink)entry.getKey(), new ArrayList<Recipient>((Collection)entry.getValue()), password, expirationDate, source, context, composeRequest);
                List<ComposedMailMessage> generatedTransportMessages = messageGenerator.generateTransportMessagesFor(messageInfo, shareReference);
                for (ComposedMailMessage generatedTransportMessage : generatedTransportMessages) {
                    generatedTransportMessage.setAppendToSentFolder(false);
                    transportMessages.add(generatedTransportMessage);
                }
            }
            String sendAddr = session.getUserSettingMail().getSendAddr();
            User user = composeRequest.getUser();
            Recipient userRecipient = Recipient.createInternalRecipient(user.getDisplayName(), sendAddr, user);
            ComposedMailMessage sentMessage = messageGenerator.generateSentMessageFor(new ShareComposeMessageInfo(personalLink, Collections.singletonList(userRecipient), password, expirationDate, source, context, composeRequest), shareReference);
            attachmentsControl.commit();
            rollback = false;
            DefaultComposeTransportResult defaultComposeTransportResult = new DefaultComposeTransportResult(transportMessages, sentMessage);
            return defaultComposeTransportResult;
        }
        finally {
            if (null != attachmentsControl) {
                if (rollback) {
                    attachmentsControl.rollback();
                }
                attachmentsControl.finish();
            }
        }
    }

    private User resolveToUser(InternetAddress address, Context ctx, UserService userService) throws OXException {
        User user;
        try {
            user = userService.searchUser(IDNA.toIDN((String)address.getAddress()), ctx);
        }
        catch (OXException e) {
            if (!LdapExceptionCode.NO_USER_BY_MAIL.equals(e)) {
                throw e;
            }
            user = null;
        }
        return user;
    }
}

