/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share;

import com.openexchange.groupware.ldap.User;

public class Recipient {
    private final String personal;
    private final String address;
    private final int hash;
    private final User user;

    public static Recipient createInternalRecipient(String personal, String address, User user) {
        return new Recipient(personal, address, user);
    }

    public static Recipient createExternalRecipient(String personal, String address) {
        return new Recipient(personal, address, null);
    }

    private Recipient(String personal, String address, User user) {
        int result;
        this.personal = personal;
        this.address = address;
        this.user = user;
        int prime = 31;
        this.hash = result = prime * 1 + (address == null ? 0 : address.hashCode());
    }

    public String getPersonal() {
        return this.personal;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isUser() {
        return null != this.user;
    }

    public User getUser() {
        return this.user;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Recipient)) {
            return false;
        }
        Recipient other = (Recipient)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }
}

