/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.modules.Module;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.java.Strings;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.mail.json.compose.share.Recipient;
import com.openexchange.mail.json.compose.share.ShareComposeLink;
import com.openexchange.mail.json.compose.share.internal.ShareComposeLinkImpl;
import com.openexchange.mail.json.compose.share.spi.ShareLinkGenerator;
import com.openexchange.session.Session;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.Links;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.ShareTargetPath;
import com.openexchange.tools.session.ServerSession;
import java.util.Collections;
import java.util.Map;

public class DefaultShareLinkGenerator
implements ShareLinkGenerator {
    private static final DefaultShareLinkGenerator INSTANCE = new DefaultShareLinkGenerator();

    public static DefaultShareLinkGenerator getInstance() {
        return INSTANCE;
    }

    protected DefaultShareLinkGenerator() {
    }

    protected Map<String, String> getAdditionals(Recipient recipient, GuestInfo guest, ShareTarget sourceTarget, Session session) throws OXException {
        return Collections.emptyMap();
    }

    @Override
    public boolean applicableFor(ComposeRequest composeRequest) {
        return true;
    }

    @Override
    public ShareComposeLink generateShareLink(Recipient recipient, GuestInfo guest, ShareTarget sourceTarget, HostData hostData, String queryString, Session session) throws OXException {
        Map<String, String> additionals = this.getAdditionals(recipient, guest, sourceTarget, session);
        ShareTargetPath targetPath = null == additionals || additionals.isEmpty() ? new ShareTargetPath(sourceTarget.getModule(), sourceTarget.getFolder(), sourceTarget.getItem()) : new ShareTargetPath(sourceTarget.getModule(), sourceTarget.getFolder(), sourceTarget.getItem(), additionals);
        String url = guest.generateLink(hostData, targetPath);
        if (!Strings.isEmpty((String)queryString)) {
            url = url + '?' + queryString;
        }
        return new ShareComposeLinkImpl(null, url, "link-created");
    }

    @Override
    public ShareComposeLink generatePersonalShareLink(ShareTarget shareTarget, HostData hostData, String queryString, ServerSession session) {
        String module = Module.getForFolderConstant(shareTarget.getModule()).getName();
        String url = Links.generateInternalLink((String)module, (String)shareTarget.getFolder(), (String)shareTarget.getItem(), (HostData)hostData);
        if (!Strings.isEmpty((String)queryString)) {
            url = url + '?' + queryString;
        }
        return new ShareComposeLinkImpl(null, url, "link-created");
    }
}

