/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.abort;

import com.openexchange.exception.OXException;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.DelegatingComposedMailMessage;
import com.openexchange.mail.json.compose.AbstractComposeHandler;
import com.openexchange.mail.json.compose.ComposeDraftResult;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.mail.json.compose.ComposeTransportResult;
import com.openexchange.mail.json.compose.DefaultComposeDraftResult;
import com.openexchange.mail.json.compose.DefaultComposeTransportResult;
import com.openexchange.mail.json.compose.abort.AbortComposeContext;
import java.util.Collections;

public class AbortComposeHandler
extends AbstractComposeHandler<AbortComposeContext, AbortComposeContext> {
    private static final AbortComposeHandler INSTANCE = new AbortComposeHandler();

    public static AbortComposeHandler getInstance() {
        return INSTANCE;
    }

    private AbortComposeHandler() {
    }

    @Override
    public String getId() {
        return "abort";
    }

    @Override
    protected AbortComposeContext createDraftComposeContext(ComposeRequest request) throws OXException {
        return new AbortComposeContext(request);
    }

    @Override
    protected AbortComposeContext createTransportComposeContext(ComposeRequest request) throws OXException {
        return new AbortComposeContext(request);
    }

    @Override
    protected ComposeDraftResult doCreateDraftResult(ComposeRequest request, AbortComposeContext context) throws OXException {
        ComposedMailMessage composeMessage = this.createRegularComposeMessage(context);
        return new DefaultComposeDraftResult(composeMessage);
    }

    @Override
    protected ComposeTransportResult doCreateTransportResult(ComposeRequest request, AbortComposeContext context) throws OXException {
        ComposedMailMessage composeMessage = this.createRegularComposeMessage(context);
        DelegatingComposedMailMessage transportMessage = new DelegatingComposedMailMessage(composeMessage);
        transportMessage.setAppendToSentFolder(false);
        return new DefaultComposeTransportResult(Collections.singletonList(transportMessage), composeMessage);
    }

    @Override
    public boolean applicableFor(ComposeRequest composeRequest) throws OXException {
        return true;
    }
}

