/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose;

import com.openexchange.capabilities.CapabilityService;
import com.openexchange.capabilities.CapabilitySet;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.json.compose.ComposeContext;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.strings.TimeSpanParser;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Utilities {

    private static final Logger LOG = LoggerFactory.getLogger(Utilities.class);

    private static ConfigurationService getConfigurationService() throws OXException {
        ConfigurationService configService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null == configService) {
            throw ServiceExceptionCode.absentService(ConfigurationService.class);
        }
        return configService;
    }

    private static ConfigViewFactory getConfigViewFactory() throws OXException {
        ConfigViewFactory viewFactory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
        if (null == viewFactory) {
            throw ServiceExceptionCode.absentService(ConfigViewFactory.class);
        }
        return viewFactory;
    }

    private static CapabilityService getCapabilityService() throws OXException {
        CapabilityService capabilityService = ServerServiceRegistry.getInstance().getService(CapabilityService.class);
        if (null == capabilityService) {
            throw ServiceExceptionCode.absentService(ConfigViewFactory.class);
        }
        return capabilityService;
    }

    public static boolean hasCapabilities(Session session, String ... capabilities) throws OXException {
        if (null == capabilities || 0 == capabilities.length) {
            return false;
        }
        CapabilitySet capabilitySet = Utilities.getCapabilityService().getCapabilities(session);
        for (String capability : capabilities) {
            if (!Strings.isEmpty((String)capability) && capabilitySet.contains(capability)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasCapabilities(CapabilitySet capabilitySet, String ... capabilities) {
        if (null == capabilities || 0 == capabilities.length) {
            return false;
        }
        for (String capability : capabilities) {
            if (!Strings.isEmpty((String)capability) && capabilitySet.contains(capability)) continue;
            return false;
        }
        return true;
    }

    public static long parseTimespanProperty(String propertyName, long defaultValue, long minimumValue, boolean allowDisabling, ConfigurationService configService) throws OXException {
        long timespan;
        String value = (null == configService ? Utilities.getConfigurationService() : configService).getProperty(propertyName);
        if (Strings.isEmpty((String)value)) {
            return defaultValue;
        }
        try {
            timespan = TimeSpanParser.parseTimespan((String)value);
        }
        catch (IllegalArgumentException e) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create(e, propertyName);
        }
        if (allowDisabling && 0L >= timespan) {
            return 0L;
        }
        if (0L < minimumValue && minimumValue > timespan) {
            LOG.warn("Ignoring too low value of \"{}\" for \"{}\", falling back to defaults.", (Object)value, (Object)propertyName);
            return defaultValue;
        }
        return timespan;
    }

    public static String getValueFromProperty(String propertyName, String defaultValue, Session session) throws OXException {
        Validate.notNull((Object)session, (String)"session must not be null");
        ConfigViewFactory viewFactory = Utilities.getConfigViewFactory();
        ConfigView view = viewFactory.getView(session.getUserId(), session.getContextId());
        ComposedConfigProperty property = view.property(propertyName, String.class);
        if (null == property || !property.isDefined()) {
            return defaultValue;
        }
        String value = (String)property.get();
        return Strings.isEmpty((String)value) ? defaultValue : value;
    }

    public static String getValueFromProperty(String propertyName, String defaultValue, int userId, int contextId) throws OXException {
        ConfigViewFactory viewFactory = Utilities.getConfigViewFactory();
        ConfigView view = viewFactory.getView(userId, contextId);
        ComposedConfigProperty property = view.property(propertyName, String.class);
        if (null == property || !property.isDefined()) {
            return defaultValue;
        }
        String value = (String)property.get();
        return Strings.isEmpty((String)value) ? defaultValue : value;
    }

    public static Integer getIntFromProperty(String propertyName, Integer defaultValue, Session session) throws OXException {
        Validate.notNull((Object)session, (String)"session must not be null");
        ConfigViewFactory viewFactory = Utilities.getConfigViewFactory();
        ConfigView view = viewFactory.getView(session.getUserId(), session.getContextId());
        ComposedConfigProperty property = view.property(propertyName, String.class);
        if (null == property || !property.isDefined()) {
            return defaultValue;
        }
        try {
            String value = (String)property.get();
            return Strings.isEmpty((String)value) ? defaultValue : Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Integer getIntFromProperty(String propertyName, Integer defaultValue, int userId, int contextId) throws OXException {
        ConfigViewFactory viewFactory = Utilities.getConfigViewFactory();
        ConfigView view = viewFactory.getView(userId, contextId);
        ComposedConfigProperty property = view.property(propertyName, String.class);
        if (null == property || !property.isDefined()) {
            return defaultValue;
        }
        try {
            String value = (String)property.get();
            return Strings.isEmpty((String)value) ? defaultValue : Integer.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Long getLongFromProperty(String propertyName, Long defaultValue, Session session) throws OXException {
        Validate.notNull((Object)session, (String)"session must not be null");
        ConfigViewFactory viewFactory = Utilities.getConfigViewFactory();
        ConfigView view = viewFactory.getView(session.getUserId(), session.getContextId());
        ComposedConfigProperty property = view.property(propertyName, String.class);
        if (null == property || !property.isDefined()) {
            return defaultValue;
        }
        try {
            String value = (String)property.get();
            return Strings.isEmpty((String)value) ? defaultValue : Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Long getLongFromProperty(String propertyName, Long defaultValue, int userId, int contextId) throws OXException {
        ConfigViewFactory viewFactory = Utilities.getConfigViewFactory();
        ConfigView view = viewFactory.getView(userId, contextId);
        ComposedConfigProperty property = view.property(propertyName, String.class);
        if (null == property || !property.isDefined()) {
            return defaultValue;
        }
        try {
            String value = (String)property.get();
            return Strings.isEmpty((String)value) ? defaultValue : Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean getBoolFromProperty(String propertyName, boolean defaultValue, Session session) throws OXException {
        Validate.notNull((Object)session, (String)"session must not be null");
        ConfigViewFactory viewFactory = Utilities.getConfigViewFactory();
        ConfigView view = viewFactory.getView(session.getUserId(), session.getContextId());
        ComposedConfigProperty property = view.property(propertyName, String.class);
        if (null == property || !property.isDefined()) {
            return defaultValue;
        }
        String value = (String)property.get();
        if (Strings.isEmpty((String)value)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(value = value.trim()) ? true : ("false".equalsIgnoreCase(value) ? false : defaultValue);
    }

    public static boolean getBoolFromProperty(String propertyName, boolean defaultValue, int userId, int contextId) throws OXException {
        ConfigViewFactory viewFactory = Utilities.getConfigViewFactory();
        ConfigView view = viewFactory.getView(userId, contextId);
        ComposedConfigProperty property = view.property(propertyName, String.class);
        if (null == property || !property.isDefined()) {
            return defaultValue;
        }
        String value = (String)property.get();
        if (Strings.isEmpty((String)value)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(value = value.trim()) ? true : ("false".equalsIgnoreCase(value) ? false : defaultValue);
    }

    public static ComposedMailMessage copyOfSourceMessage(ComposeContext composeContext) throws OXException {
        ServerSession session = composeContext.getSession();
        ComposedMailMessage composedMail = composeContext.getProvider().getNewComposedMailMessage(session, session.getContext());
        ComposedMailMessage source = composeContext.getSourceMessage();
        if (source.containsFlags()) {
            composedMail.setFlags(source.getFlags());
        }
        if (source.containsThreadLevel()) {
            composedMail.setThreadLevel(source.getThreadLevel());
        }
        if (source.containsUserFlags()) {
            composedMail.addUserFlags(source.getUserFlags());
        }
        if (source.containsUserFlags()) {
            composedMail.addUserFlags(source.getUserFlags());
        }
        if (source.containsHeaders()) {
            composedMail.addHeaders(source.getHeaders());
        }
        if (source.containsFrom()) {
            composedMail.addFrom(source.getFrom());
        }
        if (source.containsTo()) {
            composedMail.addTo(source.getTo());
        }
        if (source.containsCc()) {
            composedMail.addCc(source.getCc());
        }
        if (source.containsBcc()) {
            composedMail.addBcc(source.getBcc());
        }
        if (source.containsReplyTo()) {
            composedMail.addReplyTo(source.getReplyTo());
        }
        if (source.containsDispositionNotification()) {
            composedMail.setDispositionNotification(source.getDispositionNotification());
        }
        if (source.containsDispositionNotification()) {
            composedMail.setDispositionNotification(source.getDispositionNotification());
        }
        if (source.containsPriority()) {
            composedMail.setPriority(source.getPriority());
        }
        if (source.containsColorLabel()) {
            composedMail.setColorLabel(source.getColorLabel());
        }
        if (source.containsAppendVCard()) {
            composedMail.setAppendVCard(source.isAppendVCard());
        }
        if (source.containsMsgref()) {
            composedMail.setMsgref(source.getMsgref());
        }
        if (source.containsSubject()) {
            composedMail.setSubject(source.getSubject());
        }
        if (source.containsSize()) {
            composedMail.setSize(source.getSize());
        }
        if (source.containsSentDate()) {
            composedMail.setSentDate(source.getSentDate());
        }
        if (source.containsReceivedDate()) {
            composedMail.setReceivedDate(source.getReceivedDate());
        }
        if (source.containsContentType()) {
            composedMail.setContentType(source.getContentType());
        }
        return composedMail;
    }
}

