/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.quotachecker.MailUploadQuotaChecker;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.json.compose.AbstractComposeContext;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.tools.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuotaAwareComposeContext
extends AbstractComposeContext {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractQuotaAwareComposeContext.class);
    protected final boolean doAction;
    protected final long uploadQuota;
    protected final long uploadQuotaPerFile;
    protected long consumed;

    protected AbstractQuotaAwareComposeContext(ComposeRequest request) throws OXException {
        super(request);
        MailUploadQuotaChecker checker = new MailUploadQuotaChecker(request.getSession().getUserSettingMail());
        this.uploadQuota = checker.getQuotaMax();
        this.uploadQuotaPerFile = checker.getFileQuotaMax();
        this.doAction = this.uploadQuotaPerFile > 0L || this.uploadQuota > 0L;
    }

    protected AbstractQuotaAwareComposeContext(int accountId, ServerSession session) throws OXException {
        super(accountId, session);
        MailUploadQuotaChecker checker = new MailUploadQuotaChecker(session.getUserSettingMail());
        this.uploadQuota = checker.getQuotaMax();
        this.uploadQuotaPerFile = checker.getFileQuotaMax();
        this.doAction = this.uploadQuotaPerFile > 0L || this.uploadQuota > 0L;
    }

    @Override
    protected void onPartAdd(MailPart part, ComposedMailPart info) throws OXException {
        if (this.doAction) {
            long size = part.getSize();
            if (size <= 0L) {
                LOG.debug("Missing size: {}", (Object)size, (Object)new Throwable());
            }
            if (this.uploadQuotaPerFile > 0L && size > this.uploadQuotaPerFile) {
                this.onFileUploadQuotaExceeded(this.uploadQuotaPerFile, size, part);
                return;
            }
            this.consumed += size;
            if (this.uploadQuota > 0L && this.consumed > this.uploadQuota) {
                this.onTotalUploadQuotaExceeded(this.uploadQuota, this.consumed);
                return;
            }
        }
    }

    protected abstract void onFileUploadQuotaExceeded(long var1, long var3, MailPart var5) throws OXException;

    protected abstract void onTotalUploadQuotaExceeded(long var1, long var3) throws OXException;
}

