/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose;

import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.DataSource;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.html.HtmlService;
import com.openexchange.java.HTMLDetector;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.DataMailPart;
import com.openexchange.mail.dataobjects.compose.ReferencedMailPart;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.json.compose.ComposeContext;
import com.openexchange.mail.json.compose.ComposeDraftResult;
import com.openexchange.mail.json.compose.ComposeHandler;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.mail.json.compose.ComposeTransportResult;
import com.openexchange.mail.json.parser.MessageParser;
import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.MultipleMailPartHandler;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComposeHandler<T extends ComposeContext, D extends ComposeContext>
implements ComposeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComposeHandler.class);
    private static final String CONTENT = MailJSONField.CONTENT.getKey();
    private static final String CONTENT_TYPE = MailJSONField.CONTENT_TYPE.getKey();
    private static final String ATTACHMENTS = MailJSONField.ATTACHMENTS.getKey();
    private static final String MSGREF = MailJSONField.MSGREF.getKey();
    private static final String CID = MailJSONField.CID.getKey();
    private static final String ATTACHMENT_FILE_NAME = MailJSONField.ATTACHMENT_FILE_NAME.getKey();
    private static final String DATASOURCES = MailJSONField.DATASOURCES.getKey();
    private static final String INFOSTORE_IDS = MailJSONField.INFOSTORE_IDS.getKey();
    private static final Pattern PATTERN_ID_ATTRIBUTE = Pattern.compile("id=\"((?:\\\\\\\"|[^\"])+?)\"");
    private static final String CT_ALTERNATIVE = "alternative";

    protected AbstractComposeHandler() {
    }

    @Override
    public ComposeDraftResult createDraftResult(ComposeRequest request) throws OXException {
        D context = this.createDraftComposeContext(request);
        try {
            this.prepare(request, (ComposeContext)context);
            ComposeDraftResult composeDraftResult = this.doCreateDraftResult(request, context);
            return composeDraftResult;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        finally {
            context.dispose();
        }
    }

    @Override
    public ComposeTransportResult createTransportResult(ComposeRequest request) throws OXException {
        T context = this.createTransportComposeContext(request);
        try {
            this.prepare(request, (ComposeContext)context);
            ComposeTransportResult composeTransportResult = this.doCreateTransportResult(request, context);
            return composeTransportResult;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        finally {
            context.dispose();
        }
    }

    protected abstract D createDraftComposeContext(ComposeRequest var1) throws OXException;

    protected abstract T createTransportComposeContext(ComposeRequest var1) throws OXException;

    protected abstract ComposeDraftResult doCreateDraftResult(ComposeRequest var1, D var2) throws OXException;

    protected abstract ComposeTransportResult doCreateTransportResult(ComposeRequest var1, T var2) throws OXException;

    protected <C extends ComposeContext> ComposedMailMessage createRegularComposeMessage(C context) {
        ComposedMailMessage sourceMessage = context.getSourceMessage();
        sourceMessage.setBodyPart(context.getTextPart());
        for (MailPart part : context.getAllParts()) {
            sourceMessage.addEnclosedPart(part);
        }
        return sourceMessage;
    }

    protected <C extends ComposeContext> void prepare(ComposeRequest request, C context) throws OXException, JSONException {
        ComposedMailMessage sourceMessage = this.newComposedMailMessage(context);
        this.parseBasics(sourceMessage, request, false);
        JSONArray attachmentArray = request.getJsonMail().optJSONArray(ATTACHMENTS);
        if (null != attachmentArray) {
            JSONObject jTextBody = attachmentArray.getJSONObject(0);
            String sContent = jTextBody.getString(CONTENT);
            TextBodyMailPart part = context.getProvider().getNewTextBodyPart(sContent);
            String tmp = jTextBody.optString(CONTENT_TYPE, null);
            String contentType = null == tmp ? (HTMLDetector.containsHTMLTags((String)sContent, (boolean)true) ? "text/html" : "text/plain") : AbstractComposeHandler.parseContentType(tmp);
            part.setContentType(contentType);
            if (contentType.startsWith("text/plain") && jTextBody.optBoolean("raw", false)) {
                part.setPlainText(sContent);
            }
            sourceMessage.setContentType(part.getContentType());
            context.setTextPart(part);
            if (attachmentArray.length() > 1) {
                Set<String> contentIds = AbstractComposeHandler.extractContentIds(sContent);
                this.parseAttachments(sourceMessage, attachmentArray, contentIds, context);
            }
        } else {
            TextBodyMailPart part = context.getProvider().getNewTextBodyPart("");
            part.setContentType("text/plain; charset=us-ascii");
            sourceMessage.setContentType(part.getContentType());
            context.setTextPart(part);
        }
        UploadEvent uploadEvent = request.getUploadEvent();
        if (null != uploadEvent) {
            for (UploadFile uf : uploadEvent.getUploadFiles()) {
                if (uf == null) continue;
                context.addUploadPart(context.getProvider().getNewFilePart(uf));
            }
        }
        if (request.getJsonMail().hasAndNotNull(DATASOURCES)) {
            this.parseDataSources(request.getJsonMail().getJSONArray(DATASOURCES), context);
        }
        if (request.getJsonMail().hasAndNotNull(INFOSTORE_IDS)) {
            this.parseDriveParts(request.getJsonMail().getJSONArray(INFOSTORE_IDS), context);
        }
    }

    protected void parseDriveParts(JSONArray jDriveIds, ComposeContext context) throws OXException, JSONException {
        int length = jDriveIds.length();
        if (length > 0) {
            int max = MailProperties.getInstance().getMaxDriveAttachments();
            if (max > 0 && length > max) {
                throw MailExceptionCode.MAX_DRIVE_ATTACHMENTS_EXCEEDED.create(Integer.toString(max));
            }
            for (int i = 0; i < length; ++i) {
                context.addDrivePart(context.getProvider().getNewDocumentPart(jDriveIds.getString(i), context.getSession()));
            }
        }
    }

    protected void parseDataSources(JSONArray jDataSources, ComposeContext context) throws OXException, JSONException {
        int length = jDataSources.length();
        if (length > 0) {
            int max = MailProperties.getInstance().getMaxDriveAttachments();
            if (max > 0 && length > max) {
                throw MailExceptionCode.MAX_DRIVE_ATTACHMENTS_EXCEEDED.create(Integer.toString(max));
            }
            ConversionService conversionService = ServerServiceRegistry.getInstance().getService(ConversionService.class);
            if (conversionService == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ConversionService.class.getName()});
            }
            HashSet<Class> types = new HashSet<Class>(4);
            for (int i = 0; i < length; ++i) {
                Data data;
                JSONObject jDataSource = jDataSources.getJSONObject(i);
                if (!jDataSource.hasAndNotNull("identifier")) {
                    throw MailExceptionCode.MISSING_PARAM.create("identifier");
                }
                DataSource dataSource = conversionService.getDataSource(jDataSource.getString("identifier"));
                if (dataSource == null) {
                    throw DataExceptionCodes.UNKNOWN_DATA_SOURCE.create(new Object[]{jDataSource.getString("identifier")});
                }
                types.clear();
                types.addAll(Arrays.asList(dataSource.getTypes()));
                if (types.contains(InputStream.class)) {
                    data = dataSource.getData(InputStream.class, this.parseDataSourceArguments(jDataSource), (Session)context.getSession());
                } else if (types.contains(byte[].class)) {
                    data = dataSource.getData(byte[].class, this.parseDataSourceArguments(jDataSource), (Session)context.getSession());
                } else {
                    throw MailExceptionCode.UNSUPPORTED_DATASOURCE.create();
                }
                DataMailPart dataMailPart = context.getProvider().getNewDataPart(data.getData(), data.getDataProperties().toMap(), context.getSession());
                context.addDataPart(dataMailPart);
            }
        }
    }

    protected DataArguments parseDataSourceArguments(JSONObject jDataSource) throws JSONException {
        if (!jDataSource.hasAndNotNull("args")) {
            return DataArguments.EMPTY_ARGS;
        }
        Object args = jDataSource.get("args");
        if (args instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)args;
            int len = jsonArray.length();
            DataArguments dataArguments = new DataArguments(len);
            for (int i = 0; i < len; ++i) {
                JSONObject elem = jsonArray.getJSONObject(i);
                if (elem.length() == 1) {
                    String key = (String)elem.keys().next();
                    dataArguments.put(key, elem.getString(key));
                    continue;
                }
                LOG.warn("Corrupt data argument in JSON object: {}", (Object)elem);
            }
            return dataArguments;
        }
        JSONObject argsObject = (JSONObject)args;
        int len = argsObject.length();
        DataArguments dataArguments = new DataArguments(len);
        for (Map.Entry entry : argsObject.entrySet()) {
            dataArguments.put((String)entry.getKey(), entry.getValue().toString());
        }
        return dataArguments;
    }

    protected void parseAttachments(ComposedMailMessage composeMessage, JSONArray jAttachments, Set<String> contentIds, ComposeContext context) throws OXException, JSONException {
        MailPath parentMsgRef = composeMessage.getMsgref();
        Map<String, ReferencedMailPart> referencedParts = this.loadReferencedParts(jAttachments, contentIds, parentMsgRef, context);
        int len = jAttachments.length();
        for (int i = 1; i < len; ++i) {
            JSONObject jAttachment = jAttachments.getJSONObject(i);
            String seqId = jAttachment.optString(MailListField.ID.getKey(), null);
            if (null == seqId && jAttachment.hasAndNotNull(CONTENT)) {
                this.handleDataPart(jAttachment, context);
                continue;
            }
            this.handleReferencedPart(parentMsgRef, seqId, referencedParts, jAttachment, context);
        }
    }

    protected void handleReferencedPart(MailPath parentMsgRef, String seqId, Map<String, ReferencedMailPart> referencedParts, JSONObject jAttachment, ComposeContext context) throws OXException, JSONException {
        ReferencedMailPart referencedPart;
        boolean isMail;
        MailPath msgref;
        if (jAttachment.hasAndNotNull(MSGREF)) {
            msgref = new MailPath(jAttachment.get(MSGREF).toString());
            msgref = AbstractComposeHandler.prepareMsgRef((Session)context.getSession(), msgref);
            isMail = true;
        } else {
            msgref = parentMsgRef;
            isMail = false;
        }
        if (isMail) {
            MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> access = context.getConnectedMailAccess(msgref.getAccountId());
            MailMessage referencedMail = access.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false);
            if (null == referencedMail) {
                throw MailExceptionCode.REFERENCED_MAIL_NOT_FOUND.create(msgref.getMailID(), msgref.getFolder());
            }
            referencedMail.setAccountId(access.getAccountId());
            referencedPart = context.getProvider().getNewReferencedMail(referencedMail, context.getSession());
        } else {
            ReferencedMailPart referencedMailPart = referencedPart = null == seqId ? null : referencedParts.get(seqId);
        }
        if (null != referencedPart) {
            referencedPart.setMsgref(msgref);
            context.addReferencedPart(referencedPart);
        }
    }

    protected void handleDataPart(JSONObject jAttachment, ComposeContext context) throws OXException, JSONException {
        byte[] content;
        String contentType = AbstractComposeHandler.parseContentType(jAttachment.getString(CONTENT_TYPE));
        String charsetName = "UTF-8";
        try {
            HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
            if ("text/plain".equals(contentType)) {
                content = jAttachment.optBoolean("raw", false) ? jAttachment.getString(CONTENT).getBytes(charsetName) : htmlService.html2text(jAttachment.getString(CONTENT), true).getBytes(charsetName);
            } else {
                String conformHTML = htmlService.getConformHTML(jAttachment.getString(CONTENT), "ISO-8859-1");
                content = conformHTML.getBytes(charsetName);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        DataProperties properties = new DataProperties();
        properties.put("com.openexchange.conversion.content-type", contentType);
        properties.put("com.openexchange.conversion.size", String.valueOf(content.length));
        properties.put("com.openexchange.conversion.charset", charsetName);
        String fileName = jAttachment.optString(ATTACHMENT_FILE_NAME, null);
        if (!Strings.isEmpty((String)fileName)) {
            properties.put("com.openexchange.conversion.name", fileName);
        }
        SimpleData data = new SimpleData((Object)content, properties);
        DataMailPart dataMailPart = context.getProvider().getNewDataPart(data.getData(), data.getDataProperties().toMap(), context.getSession());
        context.addDataPart(dataMailPart);
    }

    protected Map<String, ReferencedMailPart> loadReferencedParts(JSONArray jAttachments, Set<String> contentIds, MailPath parentMsgRef, ComposeContext context) throws OXException, JSONException {
        if (null == parentMsgRef) {
            return Collections.emptyMap();
        }
        int len = jAttachments.length();
        HashMap<String, String> groupedSeqIDs = new HashMap<String, String>(len);
        for (int i = 1; i < len; ++i) {
            String seqId;
            JSONObject jAttachment = jAttachments.getJSONObject(i);
            String string = seqId = jAttachment.hasAndNotNull(MailListField.ID.getKey()) ? jAttachment.getString(MailListField.ID.getKey()) : null;
            if (seqId == null || jAttachment.hasAndNotNull(MSGREF)) continue;
            Object cid = jAttachment.opt(CID);
            groupedSeqIDs.put(seqId, null == cid ? "" : cid.toString());
        }
        if (groupedSeqIDs.isEmpty()) {
            return Collections.emptyMap();
        }
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = null;
        try {
            mailAccess = context.getConnectedMailAccess(parentMsgRef.getAccountId());
            return this.loadMultipleRefs(groupedSeqIDs, parentMsgRef, contentIds, mailAccess, context);
        }
        catch (OXException oe) {
            if (null == mailAccess || !MimeMessageUtility.shouldRetry(oe)) {
                throw oe;
            }
            mailAccess = context.reconnectMailAccess(mailAccess.getAccountId());
            return this.loadMultipleRefs(groupedSeqIDs, parentMsgRef, contentIds, mailAccess, context);
        }
    }

    protected Map<String, ReferencedMailPart> loadMultipleRefs(Map<String, String> groupedSeqIDs, MailPath parentMsgRef, Set<String> contentIds, MailAccess<?, ?> access, ComposeContext context) throws OXException {
        MailMessage referencedMail = access.getMessageStorage().getMessage(parentMsgRef.getFolder(), parentMsgRef.getMailID(), false);
        if (null == referencedMail) {
            throw MailExceptionCode.REFERENCED_MAIL_NOT_FOUND.create(parentMsgRef.getMailID(), parentMsgRef.getFolder());
        }
        referencedMail.setAccountId(access.getAccountId());
        MultipleMailPartHandler handler = new MultipleMailPartHandler(groupedSeqIDs.keySet(), false);
        new MailMessageParser().parseMailMessage(referencedMail, handler);
        HashMap<String, ReferencedMailPart> loadedParts = new HashMap<String, ReferencedMailPart>(groupedSeqIDs.size());
        for (Map.Entry<String, MailPart> e : handler.getMailParts().entrySet()) {
            String seqId = e.getKey();
            loadedParts.put(seqId, context.getProvider().getNewReferencedPart(e.getValue(), context.getSession()));
            groupedSeqIDs.remove(seqId);
        }
        if (!groupedSeqIDs.isEmpty()) {
            for (String seqId : groupedSeqIDs.keySet()) {
                if (contentIds.contains(seqId)) continue;
                throw MailExceptionCode.ATTACHMENT_NOT_FOUND.create(seqId, Long.valueOf(referencedMail.getMailId()), referencedMail.getFolder());
            }
        }
        return loadedParts;
    }

    protected ComposedMailMessage newComposedMailMessage(ComposeContext composeContext) throws OXException {
        ServerSession session = composeContext.getSession();
        ComposedMailMessage composedMail = composeContext.getProvider().getNewComposedMailMessage(session, session.getContext());
        composedMail.setAccountId(composeContext.getAccountId());
        composeContext.setSourceMessage(composedMail);
        return composedMail;
    }

    protected void parseBasics(ComposedMailMessage composedMail, ComposeRequest composeRequest, boolean forTransport) throws OXException, JSONException {
        try {
            int offset;
            String fromKey;
            JSONObject jMail = composeRequest.getJsonMail();
            if (jMail.hasAndNotNull(MailJSONField.FLAGS.getKey())) {
                composedMail.setFlags(jMail.getInt(MailJSONField.FLAGS.getKey()));
            }
            if (jMail.hasAndNotNull(MailJSONField.THREAD_LEVEL.getKey())) {
                composedMail.setThreadLevel(jMail.getInt(MailJSONField.THREAD_LEVEL.getKey()));
            }
            if (jMail.hasAndNotNull(MailJSONField.USER.getKey())) {
                JSONArray arr = jMail.getJSONArray(MailJSONField.USER.getKey());
                int length = arr.length();
                ArrayList<String> l = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    l.add(arr.getString(i));
                }
                composedMail.addUserFlags(l.toArray(new String[l.size()]));
            }
            if (jMail.hasAndNotNull(MailJSONField.HEADERS.getKey())) {
                JSONObject jHeaders = jMail.getJSONObject(MailJSONField.HEADERS.getKey());
                int size = jHeaders.length();
                HeaderCollection headers = new HeaderCollection(size);
                Iterator iter = jHeaders.keys();
                int i = size;
                while (i-- > 0) {
                    String key = (String)iter.next();
                    if (!MimeMessageFiller.isCustomOrReplyHeader(key) || key.equalsIgnoreCase("x-original-headers")) continue;
                    headers.setHeader(key, jHeaders.getString(key));
                }
                composedMail.addHeaders(headers);
            }
            if (jMail.hasAndNotNull(fromKey = MailJSONField.FROM.getKey())) {
                try {
                    int endPos;
                    String value = jMail.getString(fromKey);
                    if ('[' == value.charAt(0) && (endPos = value.indexOf(93, 1)) < value.length()) {
                        value = new StringBuilder(32).append("\"[").append(value.substring(1, endPos)).append("]\"").append(value.substring(endPos + 1)).toString();
                    }
                    composedMail.addFrom(MimeMessageUtility.parseAddressList(value, true, true));
                }
                catch (AddressException e) {
                    composedMail.addFrom(MessageParser.parseAddressKey(fromKey, jMail, forTransport));
                }
            } else if (forTransport) {
                throw MailExceptionCode.MISSING_FIELD.create(fromKey);
            }
            composedMail.addTo(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_TO.getKey(), jMail, forTransport));
            composedMail.addCc(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_CC.getKey(), jMail, forTransport));
            composedMail.addBcc(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_BCC.getKey(), jMail, forTransport));
            InternetAddress[] addrs = MessageParser.parseAddressKey("reply_to", jMail, false);
            if (null != addrs && addrs.length > 0) {
                composedMail.setHeader("Reply-To", addrs[0].toString());
            }
            if (jMail.hasAndNotNull(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey())) {
                String dispVal = jMail.getString(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey());
                if ("true".equalsIgnoreCase(dispVal)) {
                    InternetAddress[] from = composedMail.getFrom();
                    composedMail.setDispositionNotification(from.length > 0 ? from[0] : null);
                } else {
                    InternetAddress ia = AbstractComposeHandler.getEmailAddress(dispVal);
                    if (ia == null) {
                        composedMail.setDispositionNotification(null);
                    } else {
                        composedMail.setDispositionNotification(ia);
                    }
                }
            }
            if (jMail.hasAndNotNull(MailJSONField.PRIORITY.getKey())) {
                composedMail.setPriority(jMail.getInt(MailJSONField.PRIORITY.getKey()));
            }
            if (jMail.hasAndNotNull(MailJSONField.COLOR_LABEL.getKey())) {
                composedMail.setColorLabel(jMail.getInt(MailJSONField.COLOR_LABEL.getKey()));
            }
            if (jMail.hasAndNotNull(MailJSONField.VCARD.getKey())) {
                composedMail.setAppendVCard(jMail.getInt(MailJSONField.VCARD.getKey()) > 0);
            }
            if (jMail.hasAndNotNull(MSGREF)) {
                composedMail.setMsgref(new MailPath(jMail.getString(MSGREF)));
            }
            if (jMail.hasAndNotNull(MailJSONField.SUBJECT.getKey())) {
                composedMail.setSubject(jMail.getString(MailJSONField.SUBJECT.getKey()));
            }
            if (jMail.hasAndNotNull(MailJSONField.SIZE.getKey())) {
                composedMail.setSize(jMail.getInt(MailJSONField.SIZE.getKey()));
            }
            TimeZone timeZone = TimeZoneUtils.getTimeZone(composeRequest.getSession().getUser().getTimeZone());
            if (jMail.hasAndNotNull(MailJSONField.SENT_DATE.getKey())) {
                Date date = new Date(jMail.getLong(MailJSONField.SENT_DATE.getKey()));
                offset = timeZone.getOffset(date.getTime());
                composedMail.setSentDate(new Date(jMail.getLong(MailJSONField.SENT_DATE.getKey()) - (long)offset));
            } else {
                composedMail.setSentDate(new Date());
            }
            if (jMail.hasAndNotNull(MailJSONField.RECEIVED_DATE.getKey())) {
                Date date = new Date(jMail.getLong(MailJSONField.RECEIVED_DATE.getKey()));
                offset = timeZone.getOffset(date.getTime());
                composedMail.setReceivedDate(new Date(jMail.getLong(MailJSONField.RECEIVED_DATE.getKey()) - (long)offset));
            }
            composedMail.removeHeader("x-original-headers");
            AbstractComposeHandler.prepareMsgRef((Session)composeRequest.getSession(), composedMail);
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
    }

    private static InternetAddress getEmailAddress(String addrStr) {
        if (Strings.isEmpty((String)addrStr)) {
            return null;
        }
        try {
            return new QuotedInternetAddress(addrStr, false);
        }
        catch (AddressException e) {
            return null;
        }
    }

    private static void prepareMsgRef(Session session, MailMessage mail) throws OXException {
        MailPath msgref = mail.getMsgref();
        if (null == msgref) {
            return;
        }
        mail.setMsgref(AbstractComposeHandler.prepareMsgRef(session, msgref));
    }

    private static MailPath prepareMsgRef(Session session, MailPath msgref) throws OXException {
        UnifiedInboxManagement unifiedINBOXManagement = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class);
        if (null != unifiedINBOXManagement && msgref.getAccountId() == unifiedINBOXManagement.getUnifiedINBOXAccountID(session)) {
            String nestedFullname = msgref.getFolder();
            int pos = nestedFullname.indexOf("default");
            if (-1 == pos) {
                return msgref;
            }
            int check = pos + "default".length();
            while (Character.isDigit(nestedFullname.charAt(check))) {
                ++check;
            }
            if (MailProperties.getInstance().getDefaultSeparator() != nestedFullname.charAt(check)) {
                return msgref;
            }
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(nestedFullname.substring(pos));
            return new MailPath(arg.getAccountId(), arg.getFullname(), msgref.getMailID());
        }
        return msgref;
    }

    private static Set<String> extractContentIds(String htmlContent) {
        ImageMatcher m = ImageMatcher.matcher(htmlContent);
        if (!m.find()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(4);
        do {
            String imageTag;
            Matcher tmp;
            if (!(tmp = PATTERN_ID_ATTRIBUTE.matcher(imageTag = m.group())).find()) continue;
            set.add(tmp.group(1));
        } while (m.find());
        return set;
    }

    private static String parseContentType(String ctStrArg) {
        String ctStr = Strings.toLowerCase((CharSequence)ctStrArg).trim();
        if (ctStr.indexOf(CT_ALTERNATIVE) != -1) {
            return "multipart/alternative";
        }
        if ("text/plain".equals(ctStr) || "text".equals(ctStr)) {
            return "text/plain";
        }
        return "text/html";
    }
}

