/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.parser.SearchTermParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.IMailMessageStorageExt;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.utils.ColumnCollection;
import com.openexchange.mail.search.ANDTerm;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.ORTerm;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.Collections;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

@Action(method=RequestMethod.PUT, name="search", description="Search mails", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for appointments are defined in Detailed mail data."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response or the string \"thread\" to return thread-sorted messages. If this parameter is specified and holds a column number, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, requestBody="A JSON array of JSON objects each containing the search field and its search pattern: e.g.: [{\"col\": 612, \"pattern\": \"Joe\"}, {\"col\": 614, \"pattern\": \"Tuesday\"}] Supported values for col are 603 to 607 (from, to, cc, bcc and subject) and -1 for full text search.", responseDescription="(not IMAP: with timestamp): An array with mail data. Each array element describes one mail and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class SearchAction
extends AbstractMailAction {
    public SearchAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            MailMessage[] result;
            ANDTerm searchTerm;
            int[] fromToIndices;
            String folderId = req.checkParameter("folder");
            ColumnCollection columnCollection = req.checkColumnsAndHeaders();
            int[] columns = columnCollection.getFields();
            String[] headers = columnCollection.getHeaders();
            String sort = req.getParameter("sort");
            String order = req.getParameter("order");
            if (sort != null && order == null) {
                throw MailExceptionCode.MISSING_PARAM.create("order");
            }
            String s = req.getParameter("limit");
            if (null == s) {
                int leftHandLimit = req.optInt("left_hand_limit");
                int rightHandLimit = req.optInt("right_hand_limit");
                if (leftHandLimit == -9999 || rightHandLimit == -9999) {
                    fromToIndices = null;
                } else {
                    fromToIndices = new int[]{leftHandLimit < 0 ? 0 : leftHandLimit, rightHandLimit < 0 ? 0 : rightHandLimit};
                    if (fromToIndices[0] >= fromToIndices[1]) {
                        return new AJAXRequestResult(Collections.emptyList(), "mail");
                    }
                }
            } else {
                int end;
                int start;
                try {
                    int i;
                    int pos = s.indexOf(44);
                    if (pos < 0) {
                        start = 0;
                        i = Integer.parseInt(s.trim());
                        end = i < 0 ? 0 : i;
                    } else {
                        i = Integer.parseInt(s.substring(0, pos).trim());
                        start = i < 0 ? 0 : i;
                        i = Integer.parseInt(s.substring(pos + 1).trim());
                        end = i < 0 ? 0 : i;
                    }
                }
                catch (NumberFormatException e) {
                    throw MailExceptionCode.INVALID_INT_VALUE.create(e, s);
                }
                if (start >= end) {
                    return new AJAXRequestResult(Collections.emptyList(), "mail");
                }
                fromToIndices = new int[]{start, end};
            }
            boolean ignoreSeen = req.optBool("unseen");
            boolean ignoreDeleted = !req.optBool("deleted", true);
            JSONValue searchValue = (JSONValue)req.getRequest().requireData();
            MailServletInterface mailInterface = this.getMailInterface(req);
            columns = SearchAction.prepareColumns(columns);
            if (searchValue.isArray()) {
                JSONArray ja = searchValue.toArray();
                int length = ja.length();
                if (length <= 0) {
                    return new AJAXRequestResult((Object)new JSONArray(0), "json");
                }
                int[] searchCols = new int[length];
                String[] searchPats = new String[length];
                for (int i = 0; i < length; ++i) {
                    JSONObject tmp = ja.getJSONObject(i);
                    searchCols[i] = tmp.getInt("col");
                    searchPats[i] = tmp.getString("pattern");
                }
                int orderDir = OrderDirection.ASC.getOrder();
                if (order != null) {
                    if (order.equalsIgnoreCase("asc")) {
                        orderDir = OrderDirection.ASC.getOrder();
                    } else if (order.equalsIgnoreCase("desc")) {
                        orderDir = OrderDirection.DESC.getOrder();
                    } else {
                        throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                    }
                }
                LinkedList<MailMessage> mails = new LinkedList<MailMessage>();
                SearchIterator<MailMessage> it = null;
                try {
                    if ("thread".equalsIgnoreCase(sort)) {
                        it = mailInterface.getThreadedMessages(folderId, null, MailSortField.RECEIVED_DATE.getField(), orderDir, searchCols, searchPats, true, columns);
                        int i = it.size();
                        while (i-- > 0) {
                            MailMessage mail = (MailMessage)it.next();
                            if (SearchAction.discardMail(mail, ignoreSeen, ignoreDeleted)) continue;
                            if (!mail.containsAccountId()) {
                                mail.setAccountId(mailInterface.getAccountID());
                            }
                            mails.add(mail);
                        }
                    } else {
                        MailMessage[] result2;
                        ANDTerm searchTerm2;
                        int sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
                        mailInterface.openFor(folderId);
                        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = mailInterface.getMailAccess();
                        if (ignoreDeleted || ignoreSeen) {
                            ORTerm second;
                            FlagTerm first;
                            ANDTerm main = mailInterface.createSearchTermFrom(searchCols, searchPats, true);
                            FlagTerm flagTerm = first = ignoreSeen ? new FlagTerm(32, false) : null;
                            ORTerm oRTerm = ignoreDeleted ? (ignoreSeen ? null : new ORTerm(new FlagTerm(2, false), new FlagTerm(32, false))) : (second = null);
                            searchTerm2 = null == first ? (null == second ? main : new ANDTerm(main, second)) : (null == second ? new ANDTerm(main, first) : new ANDTerm(main, new ANDTerm(first, second)));
                        } else {
                            searchTerm2 = mailInterface.createSearchTermFrom(searchCols, searchPats, true);
                        }
                        FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(folderId);
                        IndexRange indexRange = null == fromToIndices ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]);
                        MailSortField sortField = MailSortField.getField(sortCol);
                        OrderDirection orderDirection = OrderDirection.getOrderDirection(orderDir);
                        IMailMessageStorage messageStorage = mailAccess.getMessageStorage();
                        if (null != headers && 0 < headers.length) {
                            if (messageStorage instanceof IMailMessageStorageExt) {
                                IMailMessageStorageExt ext = (IMailMessageStorageExt)messageStorage;
                                result2 = ext.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm2, MailField.getFields(columns), headers);
                            } else {
                                result2 = messageStorage.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm2, MailField.getFields(columns));
                                this.enrichWithHeaders(fa.getFullname(), result2, headers, messageStorage);
                            }
                        } else {
                            result2 = messageStorage.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm2, MailField.getFields(columns));
                        }
                        for (MailMessage mm : result2) {
                            if (null == mm) continue;
                            if (!mm.containsAccountId()) {
                                mm.setAccountId(mailInterface.getAccountID());
                            }
                            mails.add(mm);
                        }
                    }
                }
                finally {
                    SearchIterators.close(it);
                }
                return new AJAXRequestResult(mails, "mail");
            }
            JSONArray searchArray = searchValue.toObject().getJSONArray("filter");
            int orderDir = OrderDirection.ASC.getOrder();
            if (order != null) {
                if (order.equalsIgnoreCase("asc")) {
                    orderDir = OrderDirection.ASC.getOrder();
                } else if (order.equalsIgnoreCase("desc")) {
                    orderDir = OrderDirection.DESC.getOrder();
                } else {
                    throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                }
            }
            int sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
            mailInterface.openFor(folderId);
            MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = mailInterface.getMailAccess();
            if (ignoreDeleted || ignoreSeen) {
                ORTerm second;
                FlagTerm first;
                ANDTerm main = mailInterface.createSearchTermFrom(SearchTermParser.parse(searchArray));
                FlagTerm flagTerm = first = ignoreSeen ? new FlagTerm(32, false) : null;
                ORTerm oRTerm = ignoreDeleted ? (ignoreSeen ? null : new ORTerm(new FlagTerm(2, false), new FlagTerm(32, false))) : (second = null);
                searchTerm = null == first ? (null == second ? main : new ANDTerm(main, second)) : (null == second ? new ANDTerm(main, first) : new ANDTerm(main, new ANDTerm(first, second)));
            } else {
                searchTerm = mailInterface.createSearchTermFrom(SearchTermParser.parse(searchArray));
            }
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(folderId);
            IndexRange indexRange = null == fromToIndices ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]);
            MailSortField sortField = MailSortField.getField(sortCol);
            OrderDirection orderDirection = OrderDirection.getOrderDirection(orderDir);
            LinkedList<MailMessage> mails = new LinkedList<MailMessage>();
            IMailMessageStorage messageStorage = mailAccess.getMessageStorage();
            if (null != headers && 0 < headers.length) {
                if (messageStorage instanceof IMailMessageStorageExt) {
                    IMailMessageStorageExt ext = (IMailMessageStorageExt)messageStorage;
                    result = ext.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm, MailField.getFields(columns), headers);
                } else {
                    result = messageStorage.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm, MailField.getFields(columns));
                    this.enrichWithHeaders(fa.getFullname(), result, headers, messageStorage);
                }
            } else {
                result = messageStorage.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm, MailField.getFields(columns));
            }
            for (MailMessage mm : result) {
                if (null == mm) continue;
                if (!mm.containsAccountId()) {
                    mm.setAccountId(mailInterface.getAccountID());
                }
                mails.add(mm);
            }
            return new AJAXRequestResult(mails, "mail");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private void enrichWithHeaders(String fullName, MailMessage[] mails, String[] headerNames, IMailMessageStorage messageStorage) throws OXException {
        int length = mails.length;
        String[] ids = new String[length];
        int i = ids.length;
        while (i-- > 0) {
            MailMessage m = mails[i];
            ids[i] = null == m ? null : m.getMailId();
        }
        MailMessage[] headers = messageStorage.getMessages(fullName, ids, MailFields.toArray(MailField.HEADERS));
        int i2 = length;
        while (i2-- > 0) {
            MailMessage header;
            MailMessage mailMessage = mails[i2];
            if (null == mailMessage || null == (header = headers[i2])) continue;
            for (String headerName : headerNames) {
                String[] values = header.getHeader(headerName);
                if (null == values) continue;
                for (String value : values) {
                    mailMessage.addHeader(headerName, value);
                }
            }
        }
    }
}

