/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataBuilder;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.Dispatchers;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.compose.share.ShareReference;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareExceptionCodes;
import com.openexchange.share.ShareService;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Collections;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="resolve_share_reference", description="Resolves specified share reference.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="A JSON object providing the share reference to resolve: {\"reference\":\"...\"}", responseDescription="Response: The JSON representation for the resolved share reference.")
public class ResolveShareReference
extends AbstractMailAction {
    public ResolveShareReference(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException, JSONException {
        ShareReference shareReference;
        ShareService shareService;
        String reference = null;
        Object data = req.getRequest().getData();
        if (data instanceof JSONObject) {
            reference = ((JSONObject)data).optString("reference", null);
        }
        if (null == reference) {
            reference = req.checkParameter("reference");
        }
        if (null == (shareService = ServerServiceRegistry.getInstance().getService(ShareService.class))) {
            throw ServiceExceptionCode.absentService(ShareService.class);
        }
        IDBasedFolderAccessFactory folderFactory = ServerServiceRegistry.getInstance().getService(IDBasedFolderAccessFactory.class);
        if (null == folderFactory) {
            throw ServiceExceptionCode.absentService(IDBasedFolderAccessFactory.class);
        }
        IDBasedFileAccessFactory fileFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class);
        if (null == fileFactory) {
            throw ServiceExceptionCode.absentService(IDBasedFileAccessFactory.class);
        }
        try {
            shareReference = ShareReference.parseFromMime(reference);
        }
        catch (Exception e) {
            throw AjaxExceptionCodes.INVALID_JSON_REQUEST_BODY.create(e, new Object[0]);
        }
        ServerSession session = req.getSession();
        String token = shareReference.getShareToken();
        if (session.getContextId() != shareReference.getContextId() || session.getUserId() != shareReference.getUserId()) {
            throw ShareExceptionCodes.UNKNOWN_SHARE.create(new Object[]{token});
        }
        GuestInfo guest = shareService.resolveGuest(token);
        if (null == guest) {
            throw ShareExceptionCodes.UNKNOWN_SHARE.create(new Object[]{token});
        }
        String folderId = shareReference.getFolder().getId();
        IDBasedFolderAccess folderAccess = folderFactory.createAccess((Session)session);
        if (!folderAccess.exists(folderId)) {
            throw FileStorageExceptionCodes.NO_SUCH_FOLDER.create();
        }
        JSONObject jReference = new JSONObject(8);
        jReference.put("shareToken", (Object)token);
        jReference.put("contextId", shareReference.getContextId());
        jReference.put("userId", shareReference.getUserId());
        IDBasedFileAccess fileAccess = fileFactory.createAccess((Session)session);
        SearchIterator searchIterator = fileAccess.getDocuments(folderId, Collections.singletonList(File.Field.ID), File.Field.FILENAME, FileStorageFileAccess.SortDirection.ASC).results();
        try {
            Dispatcher ox = this.getService(Dispatcher.class);
            AJAXRequestData originalRequestData = req.getRequest();
            JSONArray jFileObjs = new JSONArray(8);
            while (searchIterator.hasNext()) {
                String fileId = ((File)searchIterator.next()).getId();
                AJAXRequestData requestData = AJAXRequestDataBuilder.request().session(session).module("files").action("get").params("id", fileId, "folder", folderId, "timezone", "utc").format("json").build(originalRequestData);
                AJAXRequestResult requestResult = this.perform(requestData, ox, session);
                JSONObject jFileObj = (JSONObject)requestResult.getResultObject();
                jFileObjs.put((Object)jFileObj);
            }
            jReference.put("files", (Object)jFileObjs);
        }
        finally {
            SearchIterators.close((SearchIterator)searchIterator);
        }
        if (null != shareReference.getExpiration()) {
            jReference.put("expiration", shareReference.getExpiration().getTime());
        }
        if (null != shareReference.getPassword()) {
            jReference.put("password", (Object)shareReference.getPassword());
        }
        return new AJAXRequestResult((Object)jReference, "json");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AJAXRequestResult perform(AJAXRequestData requestData, Dispatcher ox, ServerSession session) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        AJAXRequestResult requestResult = null;
        Throwable exc = null;
        try {
            aJAXRequestResult = requestResult = ox.perform(requestData, null, session);
        }
        catch (OXException x) {
            try {
                exc = x;
                throw x;
                catch (RuntimeException x2) {
                    exc = x2;
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(x2, x2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Dispatchers.signalDone(requestResult, (Exception)exc);
                throw throwable;
            }
        }
        Dispatchers.signalDone(requestResult, (Exception)exc);
        return aJAXRequestResult;
    }
}

