/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.actions.FolderInfo;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.ServiceLookup;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="move_all", description="Moves all mails of a folder to another folder.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="A JSON object containing the identifers of the source and destination folders; e.g.: {\"source\": \"default0/INBOX\", \"target\": \"default0/INBOX/Trash\"}.", responseDescription="A JSON response providing information for affected folders;e.g. {\"default0/INBOX\":{\"total\":0,\"unread\":0},\"default0/INBOX/Trash\":{\"total\":82,\"unread\":8}")
public final class MoveAllAction
extends AbstractMailAction {
    public MoveAllAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            String destFolder;
            JSONObject jBody = (JSONObject)req.getRequest().requireData();
            String sourceFolder = jBody.optString("source", null);
            if (null == sourceFolder) {
                sourceFolder = jBody.getString("from");
            }
            if (null == (destFolder = jBody.optString("target", null))) {
                destFolder = jBody.getString("to");
            }
            MailServletInterface mailInterface = this.getMailInterface(req);
            mailInterface.copyAllMessages(sourceFolder, destFolder, true);
            LinkedHashMap<FullnameArgument, FolderInfo> folders2 = new LinkedHashMap<FullnameArgument, FolderInfo>(4);
            FullnameArgument first = MailFolderUtility.prepareMailFolderParam(sourceFolder);
            FullnameArgument other = MailFolderUtility.prepareMailFolderParam(destFolder);
            if (first.getAccountId() == other.getAccountId()) {
                folders2.put(first, FolderInfo.getFolderInfo(first.getFullName(), mailInterface.getMailAccess().getFolderStorage()));
                if (!folders2.containsKey(other)) {
                    folders2.put(other, FolderInfo.getFolderInfo(other.getFullName(), mailInterface.getMailAccess().getFolderStorage()));
                }
            } else {
                folders2.put(other, FolderInfo.getFolderInfo(other.getFullName(), mailInterface.getMailAccess().getFolderStorage()));
                if (!folders2.containsKey(first)) {
                    mailInterface.openFor(sourceFolder);
                    folders2.put(first, FolderInfo.getFolderInfo(first.getFullName(), mailInterface.getMailAccess().getFolderStorage()));
                }
            }
            JSONObject jResponse = new JSONObject(2);
            JSONObject jFolders = new JSONObject(folders2.size());
            for (Map.Entry infoEntry : folders2.entrySet()) {
                FullnameArgument fa = (FullnameArgument)infoEntry.getKey();
                String id = MailFolderUtility.prepareFullname(fa.getAccountId(), fa.getFullName());
                FolderInfo folderInfo = (FolderInfo)infoEntry.getValue();
                jFolders.put(id, (Object)new JSONObject(4).put("total", folderInfo.total).put("unread", folderInfo.unread));
            }
            jResponse.put("folders", (Object)jFolders);
            return new AJAXRequestResult((Object)jResponse, "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

