/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.compose.CompositionSpace;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="forward", description="Forward a mail.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested Message."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="view", optional=true, description="(available with SP6) - \"text\" forces the server to deliver a text-only version of the requested mail's body, even if content is HTML. \"html\" to allow a possible HTML mail body being transferred as it is (but white-list filter applied).NOTE: if set, the corresponding gui config setting will be ignored.")}, responseDescription="(not IMAP: with timestamp): An object containing all data of the requested mail. The fields of the object are listed in Detailed mail data. The fields id and attachment are not included.")
public final class GetForwardAction
extends AbstractMailAction {
    private static final Logger LOG = LoggerFactory.getLogger(GetForwardAction.class);

    public GetForwardAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        JSONArray paths = (JSONArray)req.getRequest().getData();
        if (null == paths) {
            return this.performGet(req);
        }
        return this.performPut(req, paths);
    }

    private AJAXRequestResult performGet(MailRequest req) throws OXException {
        try {
            ServerSession session = req.getSession();
            String folderPath = req.checkParameter("folder");
            String uid = req.checkParameter("id");
            String view = req.getParameter("view");
            String csid = req.getParameter("csid");
            UserSettingMail usmNoSave = session.getUserSettingMail().clone();
            usmNoSave.setNoSave(true);
            GetForwardAction.detectDisplayMode(true, view, usmNoSave);
            if (AJAXRequestDataTools.parseBoolParameter(req.getParameter("dropPrefix"))) {
                usmNoSave.setDropReplyForwardPrefix(true);
            }
            if (AJAXRequestDataTools.parseBoolParameter(req.getParameter("attachOriginalMessage"))) {
                usmNoSave.setAttachOriginalMessage(true);
            }
            boolean setFrom = AJAXRequestDataTools.parseBoolParameter(req.getParameter("setFrom"));
            MailServletInterface mailInterface = this.getMailInterface(req);
            MailMessage mailMessage = mailInterface.getForwardMessageForDisplay(new String[]{folderPath}, new String[]{uid}, usmNoSave, setFrom);
            if (!mailMessage.containsAccountId()) {
                mailMessage.setAccountId(mailInterface.getAccountID());
            }
            if (null != csid) {
                CompositionSpace compositionSpace = CompositionSpace.getCompositionSpace(csid, session);
                compositionSpace.addForwardFor(new MailPath(folderPath, uid));
                AJAXRequestResult result = new AJAXRequestResult((Object)mailMessage, "mail");
                result.setParameter("csid", csid);
                return result;
            }
            return new AJAXRequestResult((Object)mailMessage, "mail");
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private AJAXRequestResult performPut(MailRequest req, JSONArray paths) throws OXException {
        try {
            ServerSession session = req.getSession();
            int length = paths.length();
            if (length <= 0) {
                throw AjaxExceptionCodes.MISSING_REQUEST_BODY.create();
            }
            LinkedList<MailPath> forwardFors = new LinkedList<MailPath>();
            String[] folders2 = new String[length];
            String[] ids = new String[length];
            for (int i = 0; i < length; ++i) {
                JSONObject folderAndID = paths.getJSONObject(i);
                folders2[i] = folderAndID.getString("folder");
                ids[i] = folderAndID.getString("id");
                forwardFors.add(new MailPath(folders2[i], ids[i]));
            }
            String view = req.getParameter("view");
            String csid = req.getParameter("csid");
            UserSettingMail usmNoSave = session.getUserSettingMail().clone();
            usmNoSave.setNoSave(true);
            if (null != view) {
                if ("text".equals(view)) {
                    usmNoSave.setDisplayHtmlInlineContent(false);
                } else if ("html".equals(view)) {
                    usmNoSave.setDisplayHtmlInlineContent(true);
                    usmNoSave.setAllowHTMLImages(true);
                } else if ("noimg".equals(view)) {
                    usmNoSave.setDisplayHtmlInlineContent(true);
                    usmNoSave.setAllowHTMLImages(false);
                } else {
                    LOG.warn("Unknown value in parameter {}: {}. Using user's mail settings as fallback.", (Object)"view", (Object)view);
                }
            }
            boolean setFrom = AJAXRequestDataTools.parseBoolParameter(req.getParameter("setFrom"));
            MailServletInterface mailInterface = this.getMailInterface(req);
            MailMessage mail = mailInterface.getForwardMessageForDisplay(folders2, ids, usmNoSave, setFrom);
            if (!mail.containsAccountId()) {
                mail.setAccountId(mailInterface.getAccountID());
            }
            if (null != csid) {
                CompositionSpace compositionSpace = CompositionSpace.getCompositionSpace(csid, session);
                for (MailPath forwardFor : forwardFors) {
                    compositionSpace.addForwardFor(forwardFor);
                }
                AJAXRequestResult result = new AJAXRequestResult((Object)mail, "mail");
                result.setParameter("csid", csid);
                return result;
            }
            return new AJAXRequestResult((Object)mail, "mail");
        }
        catch (OXException e) {
            String uid = this.getUidFromException(e);
            if (MailExceptionCode.MAIL_NOT_FOUND.equals(e) && "undefined".equalsIgnoreCase(uid)) {
                throw MailExceptionCode.PROCESSING_ERROR.create(e, new Object[0]);
            }
            throw e;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

