/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.Mail;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.helper.ParamContainer;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.LastModifiedAwareAJAXActionService;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.parse.FileMetadataParserService;
import com.openexchange.html.HtmlService;
import com.openexchange.html.HtmlServices;
import com.openexchange.java.Charsets;
import com.openexchange.java.HTMLDetector;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.attachment.storage.DefaultMailAttachmentStorageRegistry;
import com.openexchange.mail.attachment.storage.MailAttachmentStorage;
import com.openexchange.mail.attachment.storage.StoreOperation;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.converters.MailConverter;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeStructureFixer;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.MimeTypes;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.MailPartHandler;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.HashUtility;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.sun.mail.util.FolderClosedIOException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.mail.MessageRemovedException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="get", description="Get a mail.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="The folder identifier."), @Parameter(name="id", description="Object ID of the mail which contains the attachment."), @Parameter(name="attachment", description="ID of the requested attachment OR"), @Parameter(name="cid", description="Value of header 'Content-ID' of the requested attachment"), @Parameter(name="save", description="1 overwrites the defined mimetype for this attachment to force the download dialog, otherwise 0."), @Parameter(name="filter", optional=true, description="1 to apply HTML white-list filter rules if and only if requested attachment is of MIME type text/htm* AND parameter save is set to 0.")}, responseDescription="The raw byte data of the document. The response type for the HTTP Request is set accordingly to the defined mimetype for this attachment, except the parameter save is set to 1.")
@DispatcherNotes(allowPublicSession=true)
public final class GetAttachmentAction
extends AbstractMailAction
implements ETagAwareAJAXActionService,
LastModifiedAwareAJAXActionService {
    private static final Logger LOG = LoggerFactory.getLogger(GetAttachmentAction.class);
    private static final long EXPIRES_MILLIS_YEAR = 1572480000000L;
    private static final String PARAMETER_FILTER = "filter";
    private static final String PARAMETER_SAVE = "save";
    private static final String PARAMETER_ID = "id";
    private static final String PARAMETER_FOLDERID = "folder";
    private static final String PARAMETER_MAILCID = "cid";
    private static final String PARAMETER_MAILATTCHMENT = "attachment";
    private static final String PARAMETER_DELIVERY = Mail.PARAMETER_DELIVERY;
    private final String lastModified = Tools.formatHeaderDate(new Date(309049200000L));

    public GetAttachmentAction(ServiceLookup services) {
        super(services);
    }

    @Override
    public boolean checkLastModified(long clientLastModified, AJAXRequestData request, ServerSession session) throws OXException {
        return clientLastModified > 0L;
    }

    @Override
    public boolean checkETag(String clientETag, AJAXRequestData request, ServerSession session) throws OXException {
        return clientETag != null && clientETag.length() != 0;
    }

    @Override
    public void setETag(String eTag, long expires, AJAXRequestResult result) throws OXException {
        result.setExpires(expires);
        result.setHeader("ETag", eTag);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        JSONObject bodyObject = (JSONObject)req.getRequest().getData();
        if (null == bodyObject) {
            return this.performGET(req);
        }
        return this.performPUT(req, bodyObject);
    }

    public AJAXRequestResult performGET(final MailRequest req) throws OXException {
        try {
            Object fileHolder;
            final String folderPath = req.checkParameter(PARAMETER_FOLDERID);
            final String uid = req.checkParameter(PARAMETER_ID);
            String sequenceId = req.getParameter(PARAMETER_MAILATTCHMENT);
            String imageContentId = req.getParameter(PARAMETER_MAILCID);
            String fileNameFromRequest = req.getParameter("save_as");
            String saveParam = req.getParameter(PARAMETER_SAVE);
            boolean saveToDisk = AJAXRequestDataTools.parseBoolParameter(saveParam) || "download".equals(Strings.toLowerCase((CharSequence)req.getParameter(PARAMETER_DELIVERY)));
            String filterParam = req.getParameter(PARAMETER_FILTER);
            boolean filter = Boolean.parseBoolean(filterParam) || "1".equals(filterParam);
            String fromStructureParam = req.getParameter("from_structure");
            boolean fromStructure = Boolean.parseBoolean(fromStructureParam) || "1".equals(fromStructureParam);
            String tmp = req.getParameter("unseen");
            boolean unseen = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
            boolean asJson = AJAXRequestDataTools.parseBoolParameter("as_json", req.getRequest());
            if (sequenceId == null && imageContentId == null) {
                throw MailExceptionCode.MISSING_PARAM.create(PARAMETER_MAILATTCHMENT + " | " + PARAMETER_MAILCID);
            }
            MailServletInterface mailInterface = this.getMailInterface(req);
            if (asJson) {
                if (sequenceId == null) {
                    throw MailExceptionCode.MISSING_PARAM.create(PARAMETER_MAILATTCHMENT);
                }
                imageContentId = null;
            }
            long size = -1L;
            MailPart mailPart = null;
            ReconnectingInputStreamClosure isClosure = null;
            ThresholdFileHolder sink = null;
            Boolean markUnseen = null;
            if (imageContentId == null) {
                MailMessage nestedMailMessage;
                MailMessage mail;
                if (fromStructure) {
                    mail = mailInterface.getMessage(folderPath, uid);
                    if (null == mail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                    }
                    boolean wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
                    markUnseen = unseen && wasUnseen;
                    if (MimeStructureFixer.getInstance().isApplicableFor(mail)) {
                        boolean exactLength;
                        mail = MimeStructureFixer.getInstance().process(mail);
                        MailPartHandler handler = new MailPartHandler(sequenceId);
                        new MailMessageParser().parseMailMessage(mail, handler);
                        final MailPart ret = handler.getMailPart();
                        if (ret == null) {
                            throw MailExceptionCode.ATTACHMENT_NOT_FOUND.create(sequenceId, uid, folderPath);
                        }
                        mailPart = ret;
                        boolean bl = exactLength = AJAXRequestDataTools.parseBoolParameter(req.getParameter("exact_length")) || this.clientRequestsRange(req);
                        if (exactLength) {
                            sink = new ThresholdFileHolder();
                            InputStream in = Streams.getNonEmpty((InputStream)ret.getInputStream());
                            sink.write(null == in ? Streams.EMPTY_INPUT_STREAM : in);
                            size = sink.getLength();
                        } else {
                            isClosure = new IFileHolder.InputStreamClosure(){

                                public InputStream newStream() throws OXException, IOException {
                                    return ret.getInputStream();
                                }
                            };
                        }
                    }
                }
                if (null == mailPart) {
                    if (null == markUnseen && unseen) {
                        mail = mailInterface.getMessage(folderPath, uid);
                        if (null == mail) {
                            throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                        }
                        markUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
                    }
                    if ((mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, !saveToDisk)) == null) {
                        throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                    }
                }
                if (asJson && mailPart.getContentType().startsWith("message/rfc822") && null != (nestedMailMessage = MailMessageParser.getMessageContentFrom(mailPart))) {
                    nestedMailMessage.setAccountId(mailInterface.getAccountID());
                    AJAXRequestData requestData = req.getRequest();
                    requestData.putParameter("embedded", "true");
                    requestData.putParameter("allow_nested_messages", "false");
                    AJAXRequestResult requestResult = new AJAXRequestResult((Object)nestedMailMessage, "mail");
                    JSONObject jNestedMail = MailConverter.getInstance().convertSingle4Get(nestedMailMessage, ParamContainer.getInstance(requestData), req.getSession(), mailInterface);
                    jNestedMail.remove(MailJSONField.UNREAD.getKey());
                    jNestedMail.remove(MailJSONField.FLAGS.getKey());
                    jNestedMail.remove(MailJSONField.USER.getKey());
                    jNestedMail.remove(MailJSONField.COLOR_LABEL.getKey());
                    jNestedMail.remove(MailJSONField.MODIFIED.getKey());
                    return requestResult;
                }
                if (filter && !saveToDisk && (Strings.startsWithAny((String)Strings.toLowerCase((CharSequence)mailPart.getContentType().getSubType()), (String[])new String[]{"htm", "xhtm"}) && this.fileNameAbsentOrIndicatesHtml(mailPart.getFileName()) || this.fileNameIndicatesHtml(mailPart.getFileName()))) {
                    ContentType contentType;
                    String cs;
                    String htmlContent;
                    if (GetAttachmentAction.isEmpty(mailPart.getFileName())) {
                        mailPart.setFileName(MailMessageParser.generateFilename(sequenceId, mailPart.getContentType().getBaseType()));
                    }
                    if ((htmlContent = MessageUtility.readMailPart(mailPart, cs = (contentType = mailPart.getContentType()).containsCharsetParameter() ? contentType.getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset())).length() > HtmlServices.htmlThreshold()) {
                        OXException oxe = AjaxExceptionCodes.HTML_TOO_BIG.create();
                        Locale locale = req.getSession().getUser().getLocale();
                        htmlContent = SessionServlet.getErrorPage(200, oxe.getDisplayMessage(locale), "");
                    } else {
                        HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                        htmlContent = GetAttachmentAction.sanitizeHtml(htmlContent, htmlService);
                    }
                    final byte[] bytes = htmlContent.getBytes(Charsets.forName((String)cs));
                    contentType.setCharsetParameter(cs);
                    size = bytes.length;
                    isClosure = new IFileHolder.InputStreamClosure(){

                        public InputStream newStream() throws OXException, IOException {
                            return Streams.newByteArrayInputStream((byte[])bytes);
                        }
                    };
                    if (null != sink) {
                        Streams.close((Closeable)((Object)sink));
                        sink = null;
                    }
                } else {
                    boolean exactLength;
                    if (GetAttachmentAction.isEmpty(mailPart.getFileName())) {
                        mailPart.setFileName(MailMessageParser.generateFilename(sequenceId, mailPart.getContentType().getBaseType()));
                    }
                    boolean bl = exactLength = AJAXRequestDataTools.parseBoolParameter(req.getParameter("exact_length")) || this.clientRequestsRange(req);
                    if (exactLength) {
                        if (null == sink) {
                            sink = new ThresholdFileHolder();
                            InputStream in = Streams.getNonEmpty((InputStream)mailPart.getInputStream());
                            sink.write(null == in ? Streams.EMPTY_INPUT_STREAM : in);
                            size = sink.getLength();
                        }
                    } else if (null == isClosure) {
                        isClosure = new ReconnectingInputStreamClosure(mailPart, folderPath, uid, sequenceId, false, req.getSession());
                    }
                }
            } else {
                boolean exactLength;
                if (unseen) {
                    MailMessage mail = mailInterface.getMessage(folderPath, uid);
                    if (null == mail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                    }
                    markUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
                }
                if ((mailPart = mailInterface.getMessageImage(folderPath, uid, imageContentId)) == null) {
                    throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                }
                boolean bl = exactLength = AJAXRequestDataTools.parseBoolParameter(req.getParameter("exact_length")) || this.clientRequestsRange(req);
                if (exactLength) {
                    sink = new ThresholdFileHolder();
                    InputStream in = Streams.getNonEmpty((InputStream)mailPart.getInputStream());
                    sink.write(null == in ? Streams.EMPTY_INPUT_STREAM : in);
                    size = sink.getLength();
                } else {
                    isClosure = new ReconnectingInputStreamClosure(mailPart, folderPath, uid, imageContentId, true, req.getSession());
                }
            }
            AJAXRequestData requestData = req.getRequest();
            boolean isPreviewImage = "preview_image".equals(requestData.getFormat());
            String baseType = mailPart.getContentType().getBaseType();
            String filename = this.getFileName(fileNameFromRequest, mailPart.getFileName(), baseType);
            if (saveToDisk) {
                if (null == sink) {
                    FileHolder tmp2 = new FileHolder(isClosure, size, MimeType2ExtMap.getContentType(filename), filename);
                    tmp2.setDelivery("download");
                    fileHolder = tmp2;
                } else {
                    sink.setContentType(baseType);
                    sink.setName(filename);
                    sink.setDelivery("download");
                    fileHolder = sink;
                }
                req.getRequest().putParameter(PARAMETER_DELIVERY, "download");
            } else if (null == sink) {
                fileHolder = new FileHolder(isClosure, size, baseType, filename);
            } else {
                sink.setContentType(baseType);
                sink.setName(filename);
                fileHolder = sink;
            }
            AJAXRequestResult result = new AJAXRequestResult(fileHolder, "file");
            if (null != markUnseen && markUnseen.booleanValue()) {
                fileHolder.addPostProcessingTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MailServletInterface mailInterface = GetAttachmentAction.this.getMailInterface(req);
                            mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
                        }
                        catch (Exception e) {
                            Logger logger = LoggerFactory.getLogger(GetAttachmentAction.class);
                            logger.warn("Failed to unset \\Seen flag for message {} in folder {}", new Object[]{uid, folderPath, e});
                        }
                    }
                });
            }
            requestData.putParameter("cache", "false");
            if (!isPreviewImage) {
                requestData.setFormat("file");
            }
            this.setETag(this.getHash(folderPath, uid, imageContentId == null ? sequenceId : imageContentId), 1572480000000L, result);
            result.setHeader("Last-Modified", this.lastModified);
            return result;
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private boolean clientRequestsRange(MailRequest req) {
        return Tools.hasRangeHeader(req.getRequest().optHttpServletRequest());
    }

    private boolean fileNameIndicatesHtml(String fileName) {
        String mimeTypeByFileName = MimeType2ExtMap.getContentType(fileName, null);
        if (null == mimeTypeByFileName) {
            return false;
        }
        String lc = Strings.asciiLowerCase((String)mimeTypeByFileName);
        return lc.startsWith("text/htm") || lc.startsWith("text/xhtm");
    }

    private boolean fileNameAbsentOrIndicatesHtml(String fileName) {
        if (null == fileName) {
            return true;
        }
        String mimeTypeByFileName = MimeType2ExtMap.getContentType(fileName, null);
        if (null == mimeTypeByFileName) {
            return true;
        }
        String lc = Strings.asciiLowerCase((String)mimeTypeByFileName);
        return lc.startsWith("text/htm") || lc.startsWith("text/xhtm");
    }

    private boolean seemsToBeHtmlContent(InputStream in) throws IOException {
        return HTMLDetector.containsHTMLTags((InputStream)in, (boolean)true, (boolean)true);
    }

    private String getFileName(String fileNameFromRequest, String mailPartFileName, String baseType) {
        if (!GetAttachmentAction.isEmpty(fileNameFromRequest)) {
            return AJAXUtility.encodeUrl(fileNameFromRequest, true);
        }
        if (!GetAttachmentAction.isEmpty(mailPartFileName)) {
            return mailPartFileName;
        }
        String fileExtension = GetAttachmentAction.isEmpty(baseType) ? "dat" : MimeType2ExtMap.getFileExtension(baseType);
        return "file." + fileExtension;
    }

    private AJAXRequestResult performPUT(MailRequest req, JSONObject jsonFileObject) throws OXException {
        try {
            ServerSession session = req.getSession();
            String folderPath = req.checkParameter(PARAMETER_FOLDERID);
            String uid = req.checkParameter(PARAMETER_ID);
            String sequenceId = req.checkParameter(PARAMETER_MAILATTCHMENT);
            String destFolderIdentifier = req.checkParameter("dest_folder");
            MailServletInterface mailInterface = this.getMailInterface(req);
            MailAttachmentStorage attachmentStorage = DefaultMailAttachmentStorageRegistry.getInstance().getMailAttachmentStorage();
            if (!session.getUserPermissionBits().hasInfostore()) {
                throw MailExceptionCode.NO_MAIL_ACCESS.create();
            }
            MailPart mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, false);
            if (mailPart == null) {
                throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
            }
            String destFolderID = destFolderIdentifier;
            FileMetadataParserService parser = ServerServiceRegistry.getInstance().getService(FileMetadataParserService.class, true);
            File parsedFile = parser.parse(jsonFileObject);
            List fields = parser.getFields(jsonFileObject);
            EnumSet set = EnumSet.copyOf(fields);
            String mimeType = mailPart.getContentType().getBaseType();
            String fileName = mailPart.getFileName();
            if (GetAttachmentAction.isEmpty(fileName)) {
                fileName = "part_" + sequenceId + ".dat";
            } else {
                String contentTypeByFileName = MimeType2ExtMap.getContentType(fileName, null);
                if (null != contentTypeByFileName && !MimeTypes.equalPrimaryTypes(mimeType, contentTypeByFileName)) {
                    mimeType = contentTypeByFileName;
                    mailPart.getContentType().setBaseType(mimeType);
                }
            }
            if (set.contains(File.Field.FILENAME) && !GetAttachmentAction.isEmpty(parsedFile.getFileName())) {
                String givenFileName = parsedFile.getFileName();
                givenFileName = givenFileName.replaceAll(Pattern.quote("/"), "_");
                mailPart.setFileName(givenFileName);
            } else {
                fileName = fileName.replaceAll(Pattern.quote("/"), "_");
                mailPart.setFileName(fileName);
            }
            mailPart.setSize(0L);
            HashMap<String, Object> storeProps = new HashMap<String, Object>(4);
            storeProps.put(PARAMETER_FOLDERID, destFolderID);
            String description = parsedFile.getDescription();
            if (null != description) {
                storeProps.put("description", description);
            }
            String id = attachmentStorage.storeAttachment(mailPart, StoreOperation.SIMPLE_STORE, storeProps, session);
            MailPart updatedMailPart = attachmentStorage.getAttachment(id, session);
            String newFilename = updatedMailPart.getFileName();
            JSONObject jFileData = new JSONObject(8);
            jFileData.put("mailFolder", (Object)folderPath);
            jFileData.put("mailUID", (Object)uid);
            jFileData.put(PARAMETER_ID, (Object)id);
            jFileData.put("folder_id", (Object)destFolderID);
            jFileData.put("filename", (Object)newFilename);
            return new AJAXRequestResult((Object)jFileData, "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    static String sanitizeHtml(String htmlContent, HtmlService htmlService) {
        if (htmlService == null) {
            LOG.warn("HtmlService absent. Unable to sanitize content. Return unsanitized content.");
            return htmlContent;
        }
        return htmlService.sanitize(htmlContent, null, false, null, null);
    }

    private String getHash(String folderPath, String uid, String sequenceId) {
        return HashUtility.getHash(new StringBuilder(32).append(folderPath).append('/').append(uid).append('/').append(sequenceId).toString(), "md5", "hex");
    }

    private static final class ReconnectingInputStreamClosure
    implements IFileHolder.InputStreamClosure {
        private final ServerSession session;
        private final String id;
        private final String uid;
        private final MailPart mailPart;
        private final String folderPath;
        private final boolean image;
        private volatile ThresholdFileHolder tfh;

        ReconnectingInputStreamClosure(MailPart mailPart, String folderPath, String uid, String id, boolean image, ServerSession session) {
            this.session = session;
            this.id = id;
            this.uid = uid;
            this.mailPart = mailPart;
            this.folderPath = folderPath;
            this.image = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newStream() throws OXException, IOException {
            PushbackInputStream pushbackInputStream;
            block9: {
                int read;
                boolean error;
                PushbackInputStream in;
                block7: {
                    InputStream inputStream;
                    block8: {
                        ThresholdFileHolder tfh = this.tfh;
                        if (null != tfh) {
                            return tfh.getStream();
                        }
                        in = null;
                        error = true;
                        in = new PushbackInputStream(this.mailPart.getInputStream());
                        read = in.read();
                        if (read >= 0) break block7;
                        inputStream = Streams.EMPTY_INPUT_STREAM;
                        if (!error) break block8;
                        Streams.close((Closeable)in);
                    }
                    return inputStream;
                }
                try {
                    in.unread(read);
                    error = false;
                    pushbackInputStream = in;
                    if (!error) break block9;
                }
                catch (FolderClosedIOException e) {
                    InputStream inputStream;
                    block10: {
                        try {
                            inputStream = this.getReconnectedStream();
                            if (!error) break block10;
                        }
                        catch (Throwable throwable) {
                            if (error) {
                                Streams.close(in);
                            }
                            throw throwable;
                        }
                        Streams.close((Closeable)in);
                    }
                    return inputStream;
                }
                Streams.close((Closeable)in);
            }
            return pushbackInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized InputStream getReconnectedStream() throws OXException {
            InputStream inputStream;
            block8: {
                ThresholdFileHolder tfh = this.tfh;
                if (null != tfh) {
                    return tfh.getStream();
                }
                FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(this.folderPath);
                MailAccess<IMailFolderStorage, IMailMessageStorage> ma = null;
                ThresholdFileHolder newTfh = null;
                boolean error = true;
                try {
                    ma = MailAccess.getInstance(this.session, fa.getAccountId());
                    ma.connect(false);
                    newTfh = new ThresholdFileHolder();
                    if (this.image) {
                        newTfh.write(ma.getMessageStorage().getImageAttachment(fa.getFullName(), this.uid, this.id).getInputStream());
                    } else {
                        newTfh.write(ma.getMessageStorage().getAttachment(fa.getFullName(), this.uid, this.id).getInputStream());
                    }
                    this.tfh = newTfh;
                    error = false;
                    inputStream = newTfh.getStream();
                    if (null != ma) {
                        ma.close(true);
                    }
                    if (!error) break block8;
                }
                catch (Throwable throwable) {
                    if (null != ma) {
                        ma.close(true);
                    }
                    if (error) {
                        Streams.close(newTfh);
                    }
                    throw throwable;
                }
                Streams.close((Closeable)((Object)newTfh));
            }
            return inputStream;
        }
    }
}

