/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.utils.StorageUtility;
import java.io.InputStream;
import javax.activation.DataHandler;

public final class IDMailMessage
extends MailMessage {
    private static final long serialVersionUID = -8945006270321242506L;
    private long uid;
    private long originalUid;
    private String mailId;
    private int seqnum;
    private int unreadMessages = -1;

    public IDMailMessage() {
    }

    public IDMailMessage(String mailId, String folder) {
        this();
        this.mailId = mailId;
        this.uid = null == mailId ? -1L : StorageUtility.parseUnsignedLong(mailId);
        this.setFolder(folder);
        this.unreadMessages = -1;
    }

    public String toString() {
        String mailId;
        StringBuilder builder = new StringBuilder();
        builder.append("IDMailMessage [");
        String folder = this.getFolder();
        if (folder != null) {
            builder.append("folder=").append(folder).append(", ");
        }
        if ((mailId = this.getMailId()) != null) {
            builder.append("mail-id=").append(mailId);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getMailId() {
        return this.mailId;
    }

    @Override
    public int getUnreadMessages() {
        return this.unreadMessages;
    }

    @Override
    public void setMailId(String id) {
        this.mailId = id;
        this.uid = null == id ? -1L : StorageUtility.parseUnsignedLong(this.mailId);
    }

    public long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
        if (uid > 0L) {
            this.mailId = Long.toString(uid);
        }
    }

    public long getOriginalUid() {
        return this.originalUid;
    }

    public void setOriginalUid(long originalUid) {
        this.originalUid = originalUid;
        if (originalUid > 0L) {
            this.setOriginalId(Long.toString(originalUid));
        }
    }

    public int getSeqnum() {
        return this.seqnum;
    }

    public void setSeqnum(int seqnum) {
        this.seqnum = seqnum;
    }

    @Override
    public void setUnreadMessages(int unreadMessages) {
        this.unreadMessages = unreadMessages;
    }

    @Override
    public Object getContent() throws OXException {
        throw new UnsupportedOperationException("IDMailMessage.getContent() not supported");
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        throw new UnsupportedOperationException("IDMailMessage.getDataHandler() not supported");
    }

    @Override
    public int getEnclosedCount() throws OXException {
        throw new UnsupportedOperationException("IDMailMessage.getEnclosedCount() not supported");
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        throw new UnsupportedOperationException("IDMailMessage.getEnclosedMailPart() not supported");
    }

    @Override
    public InputStream getInputStream() throws OXException {
        throw new UnsupportedOperationException("IDMailMessage.getInputStream() not supported");
    }

    @Override
    public void loadContent() throws OXException {
    }

    @Override
    public void prepareForCaching() {
    }
}

